/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.Resource;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class DialogFloatingContainer
extends ResizableDialog
implements FloatingContainer {
    private final DockingManager _dockingManager;
    private final FloatingContainer.FloatingContainerManager _floatingContainerManager;
    private int _dockID = 0;

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame owner) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, "", false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame owner, String title) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, title, false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.setDefaultCloseOperation(2);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.initKeyBindings();
        this.resetDockID();
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog owner) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, "", false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog owner, String title) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, title, false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setFocusable(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.initKeyBindings();
        this.resetDockID();
    }

    protected void initListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                if (!(e.getOppositeWindow() instanceof FloatingContainer) && DialogFloatingContainer.this._floatingContainerManager != null) {
                    DialogFloatingContainer.this._floatingContainerManager.floatingFrameActivated(e);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                super.windowDeactivated(e);
                if (DialogFloatingContainer.this._floatingContainerManager != null) {
                    DialogFloatingContainer.this._floatingContainerManager.floatingFrameDeactivated(e);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                DockingUtils.closeFloatingContainer(DialogFloatingContainer.this.getDockingManager(), DialogFloatingContainer.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                DockingUtils.closeFloatingContainer(DialogFloatingContainer.this.getDockingManager(), DialogFloatingContainer.this);
            }
        });
    }

    protected void initKeyBindings() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DialogFloatingContainer.this.isFocusOwner() && e.getKeyCode() == 115 && e.isAltDown()) {
                    DockingUtils.closeFloatingContainer(DialogFloatingContainer.this.getDockingManager(), DialogFloatingContainer.this);
                    e.consume();
                }
            }
        });
    }

    @Override
    public Component getRoutingComponent() {
        return this._dockingManager.getMainContainer();
    }

    @Override
    public boolean hasTitleBar() {
        return !this.isUndecorated() || UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    @Override
    public Rectangle getInitialBounds(Rectangle savedBounds) {
        return savedBounds;
    }

    @Override
    public void updateUndecorated() {
        boolean show = this.isVisible();
        this.setVisible(false);
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            if (!DockingUtils.isFloatingContainerDecorated(this)) {
                this.setUndecorated(false);
                this.getRootPane().setWindowDecorationStyle(2);
                this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder()));
            }
        } else if (DockingUtils.isFloatingContainerDecorated(this)) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
        }
        this.updateBorders();
        if (this.getDockingManager().getMainContainer().isShowing() && (show || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
    }

    @Override
    public void updateBorders() {
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
            this.getResizable().setResizableCorners(0);
            if (this._dockingManager.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
            this.getResizable().setResizableCorners(DockingUtils.isFloatingContainerDecorated(this) ? 0 : 255);
            if (this._dockingManager.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        }
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public void hideItselfIfEmpty() {
        List<DockableFrame> frames = DockingUtils.getAllDockableFrameOf(this.getContentPane());
        if (frames == null || frames.size() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int id) {
        this._dockID = id;
    }

    @Override
    public void resetDockID() {
        this._dockID = -1;
        if (this._dockingManager != null) {
            this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component getMostRecentFocusOwner() {
        Component component;
        if (this.getContentPane().getComponentCount() < 1) return super.getMostRecentFocusOwner();
        Component comp = this.getContentPane().getComponent(0);
        List<Component> dockableFrameList = null;
        if (comp instanceof ContainerContainer) {
            dockableFrameList = DockingUtils.getAllChildrenOf((ContainerContainer)comp);
        } else if (comp instanceof FrameContainer) {
            dockableFrameList = DockingUtils.getAllChildrenOf((FrameContainer)comp);
        }
        if (dockableFrameList == null || dockableFrameList.size() <= 0 || !((component = dockableFrameList.get(0)) instanceof DockableFrame)) return super.getMostRecentFocusOwner();
        DockableFrame dockableFrame = (DockableFrame)component;
        Container parent = dockableFrame.getParent();
        if (parent != null && parent instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)parent;
            DockableFrame selectedFrame = frameContainer.getSelectedFrame();
            if (selectedFrame == null) return frameContainer;
            Component lastFocusedComp = selectedFrame.getFocusedComponent();
            if (lastFocusedComp == null || lastFocusedComp == selectedFrame) {
                lastFocusedComp = selectedFrame.getDefaultFocusComponent();
            }
            if (lastFocusedComp == selectedFrame) return super.getMostRecentFocusOwner();
            return lastFocusedComp;
        }
        Component lastFocusedComp = dockableFrame.getFocusedComponent();
        if (lastFocusedComp == dockableFrame) {
            lastFocusedComp = dockableFrame.getDefaultFocusComponent();
        }
        if (lastFocusedComp == dockableFrame) return super.getMostRecentFocusOwner();
        return lastFocusedComp;
    }

    @Override
    public void updateTitle() {
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
        this.getResizable().setResizableCorners(resizable ? 255 : 0);
    }

    @Override
    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }

    protected class CloseFloatingDockableFrameAction
    extends AbstractAction {
        public CloseFloatingDockableFrameAction() {
            super(DialogFloatingContainer.this.getDockingManager() != null ? DialogFloatingContainer.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeText") : Resource.getResourceBundle(Locale.getDefault()).getString("DockableFrameTitlePane.closeText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DockingUtils.closeFloatingContainer(DialogFloatingContainer.this.getDockingManager(), DialogFloatingContainer.this);
        }
    }
}

