/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ContainerContainer
extends JideSplitPane
implements ContainerListener,
Dockable,
PropertyChangeListener {
    private DockingManager _dockingManager;
    private int _dockID = 0;
    private double[] _eventualProportions;

    ContainerContainer() {
        this((DockingManager)null);
    }

    public ContainerContainer(DockingManager dockingManager) {
        this(dockingManager, 1);
    }

    public ContainerContainer(DockingManager dockingManager, int newOrientation) {
        super(newOrientation);
        this._dockingManager = dockingManager;
        if (this._dockingManager != null) {
            this.setHeavyweightComponentEnabled(this._dockingManager.isHeavyweightComponentEnabled());
            this.setContinuousLayout(this._dockingManager.isContinuousLayout());
            this.setProportionalLayout(this._dockingManager.isProportionalSplits());
            this.setShowGripper(this._dockingManager.isShowDividerGripper());
            this.addPropertyChangeListener(this);
            this.setInitiallyEven(false);
            this.resetDockID();
        }
    }

    @Override
    public void addImpl(Component comp, Object constraints, int index) {
        if (this.getDockingManager() != null) {
            Workspace workspace = this.getDockingManager().getWorkspace();
            if (comp instanceof Container && workspace.isVisible() && ((Container)comp).isAncestorOf(workspace) || comp == workspace) {
                super.addImpl(comp, workspace.getLayoutConstraint(), index);
            } else {
                super.addImpl(comp, constraints, index);
            }
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new ContainerContainerDivider(this);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    protected void startDragging(JideSplitPaneDivider divider) {
        this.setContinuousLayout(this._dockingManager.isContinuousLayout());
        super.startDragging(divider);
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideItselfIfEmpty() {
        Container parent;
        JPanel childPane;
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof ContainerContainer) {
            childPane = (ContainerContainer)this.getComponent(0);
            parent = this.getParent();
            Object object = parent.getTreeLock();
            synchronized (object) {
                if (((JideSplitPane)childPane).getOrientation() == this.getOrientation()) {
                    if (parent instanceof DockedFrameContainer) {
                        parent.add((Component)childPane, "Center");
                        ((ContainerContainer)childPane).setDockID(this.getDockID());
                    } else if (parent instanceof ContainerContainer) {
                        ContainerContainer containerContainer = (ContainerContainer)parent;
                        int index = containerContainer.indexOfPane(this);
                        containerContainer.insertPane(childPane, index);
                    }
                    parent.doLayout();
                }
            }
        }
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof Workspace && !this.getComponent(0).isVisible()) {
            childPane = (Workspace)this.getComponent(0);
            parent = this.getParent();
            if (parent instanceof DockedFrameContainer) {
                parent.add((Component)childPane, "Center");
            } else if (parent instanceof ContainerContainer) {
                ContainerContainer containerContainer = (ContainerContainer)parent;
                int index = containerContainer.indexOfPane(this);
                containerContainer.insertPane(childPane, index);
            }
            parent.doLayout();
        }
        if (this.getComponentCount() == 0 && this.getParent() != null) {
            Container container = this.getParent();
            Object object = container.getTreeLock();
            synchronized (object) {
                this.setVisible(false);
                container.remove(this);
                container.doLayout();
                if (container instanceof ContainerContainer) {
                    ((ContainerContainer)container).hideItselfIfEmpty();
                }
            }
        }
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int id) {
        this._dockID = id;
    }

    @Override
    public void resetDockID() {
        this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
    }

    void setEventualProportions(double[] proportions) {
        this._eventualProportions = proportions;
        this.updateProportions();
    }

    private void updateProportions() {
        if (this._eventualProportions != null && this.getPaneCount() == this._eventualProportions.length + 1) {
            this.setProportions(this._eventualProportions);
            this._eventualProportions = null;
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        super.componentAdded(e);
        if (!(e.getChild() instanceof JideSplitPaneDivider)) {
            this.updateProportions();
        }
    }

    boolean isComponentNextToDivider(ContainerContainerDivider divider, Component component) {
        if (divider == null || divider.getParent() != this) {
            return false;
        }
        if (component == null || component.getParent() != this) {
            return false;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (c == divider && i < this.getComponentCount() - 1 && component == this.getComponent(i + 1)) {
                return true;
            }
            if (c != component || i >= this.getComponentCount() - 1 || divider != this.getComponent(i + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        final int direction = this.getOrientation();
        if ("dividerLocation".equals(evt.getPropertyName())) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JideSwingUtilities.setRecursively(ContainerContainer.this, new JideSwingUtilities.Handler(){

                        @Override
                        public boolean condition(Component c) {
                            return c instanceof DockableFrame;
                        }

                        @Override
                        public void action(Component c) {
                            ((DockableFrame)c).updateDockedWidthOrHeight(direction);
                        }

                        @Override
                        public void postAction(Component c) {
                        }
                    });
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    protected void finishDraggingTo(JideSplitPaneDivider divider, int location) {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.finishDraggingTo(divider, location);
    }
}

