/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.PreviousState;
import java.awt.Rectangle;
import java.io.Serializable;

public class DockableBarContext
implements Serializable {
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_FLOATING = 1;
    public static final int STATE_HORI_DOCKED = 2;
    public static final int STATE_VERT_DOCKED = 3;
    public static final String[] STATE_NAMES = new String[]{"\"HIDE\"", "\"FLOAT\"", "\"HORI_DOCKED\"", "\"VERT_DOCKED\""};
    private int _initMode = 2;
    private int _currentMode = -1;
    public static final int DOCK_SIDE_NORTH = 1;
    public static final int DOCK_SIDE_SOUTH = 2;
    public static final int DOCK_SIDE_EAST = 4;
    public static final int DOCK_SIDE_WEST = 8;
    public static final int DOCK_SIDE_HORIZONTAL = 3;
    public static final int DOCK_SIDE_VERTICAL = 12;
    public static final int DOCK_SIDE_ALL = 15;
    public static final String[] SIDE_NAMES = new String[]{"\"NORTH\"", "\"SOUTH\"", "\"EAST\"", "\"WEST\""};
    private int _initSide = 1;
    private int _initIndex;
    private int _initSubindex;
    private boolean _initPosition = true;
    private int _currentDockSide = 1;
    private Rectangle _undockedBounds;
    private int _dockedWidth;
    private int _dockedHeight;
    private int _dockID;
    private PreviousState _hiddenPreviousState;
    private PreviousState _closePreviousState;
    private PreviousState _dockPreviousState;
    private PreviousState _floatPreviousState;
    private boolean _available = true;
    private PreviousState _availablePreviousState;

    public int getInitMode() {
        return this._initMode;
    }

    public void setInitMode(int initMode) {
        if (initMode > 3 || initMode < -3) {
            throw new IllegalArgumentException("initMode must be one of the following values - DockableBarContext.STATE_FLOATING, DockableBarContext.STATE_HIDDEN, DockableBarContext.STATE_HORI_DOCKED or DockableBarContext.STATE_VERT_DOCKED");
        }
        this._initMode = initMode;
    }

    public int getCurrentMode() {
        if (this._currentMode == -1) {
            return this._initMode;
        }
        return this._currentMode;
    }

    public void setCurrentMode(int currentMode) {
        if (currentMode != 1 && currentMode != 0 && currentMode != 2 && currentMode != 3) {
            throw new IllegalArgumentException("currentMode must be one of the following values - DockableBarContext.STATE_FLOATING, DockableBarContext.STATE_HIDDEN, DockableBarContext.STATE_HORI_DOCKED or DockableBarContext.STATE_VERT_DOCKED");
        }
        this._currentMode = currentMode;
    }

    public boolean isHidden() {
        return this.getCurrentMode() == 0;
    }

    public boolean isHoriDocked() {
        return this.getCurrentMode() == 2;
    }

    public boolean isVertDocked() {
        return this.getCurrentMode() == 3;
    }

    public boolean isFloating() {
        return this.getCurrentMode() == 1;
    }

    public int getInitSide() {
        return this._initSide;
    }

    public void setInitSide(int initSide) {
        if (initSide != 1 && initSide != 2 && initSide != 4 && initSide != 8) {
            throw new IllegalArgumentException("initSide must be one of the following values - DockableBarContext.DOCK_SIDE_NORTH, DockableBarContext.DOCK_SIDE_SOUTH, DockableBarContext.DOCK_SIDE_EAST or DockableBarContext.DOCK_SIDE_WEST");
        }
        this._initSide = initSide;
    }

    public boolean isInitPosition() {
        return this._initPosition;
    }

    public void setInitPosition(boolean initPosition) {
        this._initPosition = initPosition;
    }

    public int getInitIndex() {
        return this._initIndex;
    }

    public void setInitIndex(int initIndex) {
        this._initIndex = initIndex;
    }

    public int getInitSubindex() {
        return this._initSubindex;
    }

    public void setInitSubindex(int initSideSubindex) {
        this._initSubindex = initSideSubindex;
    }

    public int getCurrentDockSide() {
        return this._currentDockSide;
    }

    public void setCurrentDockSide(int currentDockSide) {
        if (currentDockSide != 1 && currentDockSide != 2 && currentDockSide != 4 && currentDockSide != 8) {
            throw new IllegalArgumentException("currentDockSide must be one of the following values - DockableBarContext.DOCK_SIDE_NORTH, DockableBarContext.DOCK_SIDE_SOUTH, DockableBarContext.DOCK_SIDE_EAST or DockableBarContext.DOCK_SIDE_WEST");
        }
        this._currentDockSide = currentDockSide;
    }

    public Rectangle getUndockedBounds() {
        return this._undockedBounds;
    }

    public void setUndockedBounds(Rectangle bound) {
        this._undockedBounds = bound;
    }

    public int getDockedWidth() {
        return this._dockedWidth;
    }

    public void setDockedWidth(int dockedWidth) {
        this._dockedWidth = dockedWidth;
    }

    public int getDockedHeight() {
        return this._dockedHeight;
    }

    public void setDockedHeight(int dockedHeight) {
        this._dockedHeight = dockedHeight;
    }

    public PreviousState getHiddenPreviousState() {
        return this._hiddenPreviousState;
    }

    public void setHiddenPreviousState(PreviousState hiddenPreviousState) {
        this._hiddenPreviousState = hiddenPreviousState;
    }

    public PreviousState getClosePreviousState() {
        return this._closePreviousState;
    }

    public void setClosePreviousState(PreviousState closePreviousState) {
        this._closePreviousState = closePreviousState;
    }

    public PreviousState getDockPreviousState() {
        return this._dockPreviousState;
    }

    public void setDockPreviousState(PreviousState dockPreviousState) {
        this._dockPreviousState = dockPreviousState;
    }

    public PreviousState getFloatPreviousState() {
        return this._floatPreviousState;
    }

    public void setFloatPreviousState(PreviousState floatPreviousState) {
        this._floatPreviousState = floatPreviousState;
    }

    public static String getDockSideName(int side) {
        return SIDE_NAMES[(int)(Math.log(side) / Math.log(2.0))];
    }

    public int getDockID() {
        return this._dockID;
    }

    public void setDockID(int dockID) {
        this._dockID = dockID;
    }

    public void resetDockID() {
    }

    public boolean isAvailable() {
        return this._available;
    }

    public void setAvailable(boolean available) {
        this._available = available;
    }

    public PreviousState getAvailablePreviousState() {
        return this._availablePreviousState;
    }

    public void setAvailablePreviousState(PreviousState availablePreviousState) {
        this._availablePreviousState = availablePreviousState;
    }
}

