/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SizeRequirements;
import javax.swing.SwingConstants;

public class DockableBarContainerLayout
implements LayoutManager2,
Serializable,
SwingConstants {
    private static final long serialVersionUID = 851502149842087020L;
    public int _verticalGap = 1;
    public int _horizontalGap = 3;
    private SizeRequirements[] _srWidth;
    private SizeRequirements[] _srHeight;
    private DockableBarContainer _target;
    private int _side;
    private int[] _rowHeights;

    public DockableBarContainerLayout(Container target, int side) {
        if (!(target instanceof DockableBarContainer)) {
            throw new IllegalArgumentException("target must be DockableBarContainer.");
        }
        this._target = (DockableBarContainer)target;
        this._side = side;
    }

    public int getVerticalGap() {
        return this._verticalGap;
    }

    public void setVerticalGap(int vGap) {
        this._verticalGap = vGap;
    }

    public int getHorizontalGap() {
        return this._horizontalGap;
    }

    public void setHorizontalGap(int hGap) {
        this._horizontalGap = hGap;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLayout(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this._rowHeights = new int[this._target.getRowCount()];
            this._srWidth = new SizeRequirements[this._target.getRowCount()];
            this._srHeight = new SizeRequirements[this._target.getRowCount()];
            for (int i = 0; i < this._target.getRowCount(); ++i) {
                SizeRequirements srH;
                SizeRequirements srW = this.getPrimarySizeRequirements(i);
                this._srHeight[i] = srH = this.getSecondarySizeRequirements(i);
                this._srWidth[i] = srW;
                this._rowHeights[i] = this._srHeight[i].preferred;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this.internalAddComponent(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this.internalAddComponent(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this.internalRemoveComponent(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            Dimension size = new Dimension(SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._srWidth).preferred, SizeRequirements.getTiledSizeRequirements((SizeRequirements[])this._srHeight).preferred + (this._srHeight.length <= 0 ? 0 : this._verticalGap * (this._srHeight.length - 1)));
            if (this._target.isHorizontal()) {
                return size;
            }
            return new Dimension(size.height, size.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            Dimension size = new Dimension(SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._srWidth).minimum, SizeRequirements.getTiledSizeRequirements((SizeRequirements[])this._srHeight).minimum + (this._srHeight.length <= 0 ? 0 : this._verticalGap * (this._srHeight.length - 1)));
            if (this._target.isHorizontal()) {
                return size;
            }
            return new Dimension(size.height, size.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            Dimension size = new Dimension(SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._srWidth).maximum, SizeRequirements.getTiledSizeRequirements((SizeRequirements[])this._srHeight).maximum + (this._srHeight.length <= 0 ? 0 : this._verticalGap * (this._srHeight.length - 1)));
            if (this._target.isHorizontal()) {
                return size;
            }
            return new Dimension(size.height, size.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            int rowLocation = 0;
            for (int i = 0; i < this._target.getRowCount(); ++i) {
                this.layoutRow(i, rowLocation);
                rowLocation += this._srHeight[i].preferred + this._verticalGap;
            }
        }
    }

    private void sort(List row) {
        Collections.sort(row, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof DockableBarItem && o2 instanceof DockableBarItem) {
                    int x2;
                    int x1 = ((DockableBarItem)o1).getStart();
                    if (x1 == (x2 = ((DockableBarItem)o2).getStart())) {
                        return 0;
                    }
                    if (x1 > x2) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    private void layoutRow(int rowIndex, int rowLocation) {
        int totalSize = this.getPrimarySize(this._target.getSize());
        if (totalSize >= this._srWidth[rowIndex].preferred + this._horizontalGap * (this.internalGetRow(rowIndex).size() - 1)) {
            this.layoutRowIfFitted(rowIndex, rowLocation, totalSize);
        } else if (totalSize >= this._srWidth[rowIndex].minimum + this._horizontalGap * (this.internalGetRow(rowIndex).size() - 1)) {
            this.layoutRowIfNotFitted(rowIndex, rowLocation, totalSize);
        }
    }

    private void layoutRowIfFitted(int rowIndex, int rowLocation, int availSize) {
        Rectangle rect;
        List row = (List)this._target.getDockableBarList().get(rowIndex);
        int nextX = 0;
        ArrayList<DockableBarItem> rows = new ArrayList<DockableBarItem>();
        for (Object aRow : row) {
            DockableBarItem toolBarPaneItem = (DockableBarItem)aRow;
            toolBarPaneItem.setDragging(false);
            rows.add(toolBarPaneItem);
        }
        this.sort(rows);
        Rectangle[] rects = new Rectangle[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            DockableBarItem item = (DockableBarItem)rows.get(i);
            rect = new Rectangle();
            if (this._target.isHorizontal()) {
                rect.height = this._srHeight[rowIndex].preferred;
                rect.y = rowLocation;
                rect.x = item.getStart() > nextX ? item.getStart() : nextX;
                rect.width = item.getComponent() instanceof DockableBar && ((DockableBar)item.getComponent()).isStretch() ? (i == rows.size() - 1 ? (i != 0 ? this._target.getWidth() - rect.x : this._target.getWidth()) : item.getComponent().getPreferredSize().width) : item.getComponent().getPreferredSize().width;
                rects[i] = rect;
                nextX = rect.x + rect.width;
                if (i == rows.size() - 1) continue;
                nextX += this._horizontalGap;
                continue;
            }
            rect.width = this._srHeight[rowIndex].preferred;
            rect.x = rowLocation;
            rect.y = item.getStart() > nextX ? item.getStart() : nextX;
            rect.height = item.getComponent() instanceof DockableBar && ((DockableBar)item.getComponent()).isStretch() ? (i == rows.size() - 1 ? (i != 0 ? this._target.getHeight() - rect.y : this._target.getHeight()) : item.getComponent().getPreferredSize().height) : item.getComponent().getPreferredSize().height;
            rects[i] = rect;
            nextX = rect.y + rect.height;
            if (i == rows.size() - 1) continue;
            nextX += this._horizontalGap;
        }
        int pushBack = 0;
        if (nextX > availSize) {
            pushBack = nextX - availSize;
        }
        for (int i = rects.length - 1; i >= 0; --i) {
            rect = rects[i];
            if (this._target.isHorizontal()) {
                rect.x -= pushBack;
                if (i <= 0) continue;
                if (rect.x >= rects[i - 1].x + rects[i - 1].width) {
                    pushBack = 0;
                    continue;
                }
                pushBack = rects[i - 1].x + rects[i - 1].width - rect.x;
                continue;
            }
            rect.y -= pushBack;
            if (i <= 0) continue;
            pushBack = rect.y >= rects[i - 1].y + rects[i - 1].height ? 0 : rects[i - 1].y + rects[i - 1].height - rect.y;
        }
        if (!this._target.getComponentOrientation().isLeftToRight()) {
            for (Rectangle rect2 : rects) {
                rect2.x = this._target.getWidth() - rect2.x - rect2.width;
            }
        }
        for (int i = 0; i < rects.length; ++i) {
            DockableBarItem item = (DockableBarItem)rows.get(i);
            item.getComponent().setBounds(rects[i]);
        }
    }

    private void internalAddRow(DockableBarList row) {
        this._target.getDockableBarList().add(row);
    }

    private void internalRemoveRow(int rowIndex) {
        this._target.getDockableBarList().remove(rowIndex);
    }

    private List internalGetRow(int rowIndex) {
        DockableBarList row;
        if (rowIndex >= this._target.getDockableBarList().size() || rowIndex == -1) {
            row = new DockableBarList(this._target.getDockableBarList());
            this.internalAddRow(row);
        } else {
            row = (DockableBarList)this._target.getDockableBarList().get(rowIndex);
        }
        return row;
    }

    private void internalRemoveComponent(Component component) {
        this._target.getDockableBarList().removeComponent(component);
    }

    private void internalAddComponent(Component component) {
        this.internalAddComponent(component, -1, 0);
    }

    private void internalAddComponent(Component component, int rowIndex, int x) {
        if (this._target.getDockableBarList().getDockableBarItemOf(component) != null) {
            return;
        }
        if (rowIndex == -1) {
            this._target.getDockableBarList().insertComponent(component, this._target.getDockableBarList().size(), x);
        } else {
            this._target.getDockableBarList().insertComponent(component, rowIndex, x);
        }
    }

    private int getPrimarySize(Dimension size) {
        if (this._side == 1 || this._side == 5) {
            return size.width;
        }
        return size.height;
    }

    private SizeRequirements getPrimarySizeRequirements(int rowIndex) {
        List row = this.internalGetRow(rowIndex);
        SizeRequirements[] srsW = new SizeRequirements[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            SizeRequirements srH;
            SizeRequirements srW;
            DockableBarItem item = (DockableBarItem)row.get(i);
            srsW[i] = this._target.getOrientation() == 0 ? (srW = new SizeRequirements(item.getComponent().getMinimumSize().width, item.getComponent().getPreferredSize().width, item.getComponent().getMaximumSize().width, 0.5f)) : (srH = new SizeRequirements(item.getComponent().getMinimumSize().height, item.getComponent().getPreferredSize().height, item.getComponent().getMaximumSize().height, 0.5f));
        }
        return SizeRequirements.getTiledSizeRequirements(srsW);
    }

    private SizeRequirements getSecondarySizeRequirements(int rowIndex) {
        List row = this.internalGetRow(rowIndex);
        SizeRequirements[] srsH = new SizeRequirements[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            SizeRequirements srH;
            DockableBarItem item = (DockableBarItem)row.get(i);
            srsH[i] = this._target.getOrientation() == 0 ? (srH = new SizeRequirements(item.getComponent().getMinimumSize().height, item.getComponent().getPreferredSize().height, item.getComponent().getMaximumSize().height, 0.5f)) : (srH = new SizeRequirements(item.getComponent().getMinimumSize().width, item.getComponent().getPreferredSize().width, item.getComponent().getMaximumSize().width, 0.5f));
        }
        return SizeRequirements.getAlignedSizeRequirements(srsH);
    }

    public int getRowHeightAt(int row) {
        if (this._rowHeights == null) {
            return -1;
        }
        if (row >= 0 && row < this._rowHeights.length) {
            return this._rowHeights[row];
        }
        return -1;
    }

    int getActiveIndex(List items) {
        for (int i = 0; i < items.size(); ++i) {
            DockableBarItem item = (DockableBarItem)items.get(i);
            if (!item.isDragging()) continue;
            return i;
        }
        return -1;
    }

    boolean isResizing(List items) {
        for (int i = 0; i < items.size(); ++i) {
            DockableBarItem item = (DockableBarItem)items.get(i);
            if (!item.isDragging()) continue;
            return item.isResizing();
        }
        return false;
    }

    private void layoutRowIfNotFitted(int rowIndex, int rowLocation, int totalSize) {
        int minimumSize;
        int preferredStart;
        int i;
        totalSize -= this._horizontalGap * (this.internalGetRow(rowIndex).size() - 1);
        List row = (List)this._target.getDockableBarList().get(rowIndex);
        ArrayList<DockableBarItem> items = new ArrayList<DockableBarItem>();
        for (Object barItem : row) {
            DockableBarItem toolBarPaneItem = (DockableBarItem)barItem;
            items.add(toolBarPaneItem);
        }
        this.sort(items);
        int activeIndex = -1;
        boolean resizing = false;
        DockableBarItem activeItem = null;
        SizeRequirements[] srsW = new SizeRequirements[items.size()];
        for (int i2 = 0; i2 < items.size(); ++i2) {
            SizeRequirements srH;
            SizeRequirements srW;
            DockableBarItem item = (DockableBarItem)items.get(i2);
            srsW[i2] = this._target.getOrientation() == 0 ? (srW = new SizeRequirements(item.getComponent().getMinimumSize().width, item.getComponent().getPreferredSize().width, item.getComponent().getMaximumSize().width, 0.5f)) : (srH = new SizeRequirements(item.getComponent().getMinimumSize().height, item.getComponent().getPreferredSize().height, item.getComponent().getMaximumSize().height, 0.5f));
            if (!item.isDragging()) continue;
            activeIndex = i2;
            activeItem = item;
            if (!activeItem.isResizing()) continue;
            resizing = true;
        }
        Rectangle[] rects = new Rectangle[items.size()];
        for (i = 0; i < rects.length; ++i) {
            rects[i] = new Rectangle();
            if (!resizing) continue;
            DockableBarItem item = (DockableBarItem)items.get(i);
            if (this._target.getOrientation() == 0) {
                rects[i].x = item.getComponent().getX() - this._horizontalGap * i;
                rects[i].width = item.getComponent().getWidth();
                continue;
            }
            rects[i].y = item.getComponent().getY() - this._horizontalGap * i;
            rects[i].height = item.getComponent().getHeight();
        }
        for (i = 0; i < items.size(); ++i) {
            DockableBarItem toolBarPaneItem = (DockableBarItem)items.get(i);
            toolBarPaneItem.setDragging(false);
        }
        if (this._target.getOrientation() == 0) {
            if (resizing) {
                int prefAfter;
                int prefBefore;
                preferredStart = activeItem.getStart() - activeIndex * this._horizontalGap;
                int minBefore = activeIndex < 0 ? 0 : this.getMinimumSize(0, activeIndex, srsW);
                int n = prefBefore = activeIndex < 0 ? totalSize : this.getPreferredSize(0, activeIndex, srsW);
                if (preferredStart < minBefore) {
                    preferredStart = minBefore;
                } else if (preferredStart > prefBefore) {
                    preferredStart = prefBefore;
                }
                int minAfter = activeIndex >= items.size() - 1 ? 0 : this.getMinimumSize(activeIndex + 1, items.size(), srsW);
                int n2 = prefAfter = activeIndex >= items.size() - 1 ? totalSize : this.getPreferredSize(activeIndex + 1, items.size(), srsW);
                if (preferredStart + srsW[activeIndex].preferred < totalSize - prefAfter) {
                    preferredStart = totalSize - prefAfter - srsW[activeIndex].preferred;
                    rects[activeIndex].width = srsW[activeIndex].preferred;
                } else if (preferredStart + srsW[activeIndex].minimum > totalSize - minAfter) {
                    preferredStart = totalSize - minAfter - srsW[activeIndex].minimum;
                    rects[activeIndex].width = srsW[activeIndex].minimum;
                } else if (minAfter == 0 && preferredStart + srsW[activeIndex].preferred < totalSize) {
                    preferredStart = totalSize - minAfter - srsW[activeIndex].preferred;
                    rects[activeIndex].width = srsW[activeIndex].preferred;
                }
                rects[activeIndex].x = preferredStart;
                if (activeIndex < items.size() - 1) {
                    rects[activeIndex].width = rects[activeIndex + 1].x - rects[activeIndex].x;
                    if (rects[activeIndex].width > srsW[activeIndex].preferred) {
                        rects[activeIndex].width = srsW[activeIndex].preferred;
                    }
                    if (rects[activeIndex].width < srsW[activeIndex].minimum) {
                        rects[activeIndex].width = srsW[activeIndex].minimum;
                    }
                    rects[activeIndex + 1].x = rects[activeIndex].x + rects[activeIndex].width;
                    this.shrink(rects, activeIndex + 1, items.size(), srsW, totalSize - rects[activeIndex + 1].x, true);
                } else {
                    rects[activeIndex].width = totalSize - rects[activeIndex].x;
                }
                this.shrink(rects, 0, activeIndex, srsW, rects[activeIndex].x, false);
            } else {
                int i3;
                int[] shrinkOrder;
                minimumSize = this.getMinimumSize(0, items.size(), srsW);
                for (int i4 = 0; i4 < items.size(); ++i4) {
                    rects[i4].width = srsW[i4].minimum;
                }
                int gapToGrow = totalSize - minimumSize;
                if (gapToGrow > 0 && activeIndex >= 0) {
                    int growWidth = Math.max(0, Math.min(gapToGrow, srsW[activeIndex].preferred - srsW[activeIndex].minimum));
                    rects[activeIndex].width += growWidth;
                    gapToGrow -= growWidth;
                }
                if (this._target.getShrinkOrderProvider() == null) {
                    shrinkOrder = new int[items.size()];
                    for (i3 = 0; i3 < items.size(); ++i3) {
                        shrinkOrder[i3] = items.size() - i3 - 1;
                    }
                } else {
                    shrinkOrder = this._target.getShrinkOrderProvider().getShrinkOrder(rowIndex);
                }
                for (int growIndex = items.size() - 1; gapToGrow > 0 && growIndex >= 0; --growIndex) {
                    if (growIndex == activeIndex) continue;
                    int index = items.indexOf(((DockableBarList)this._target.getDockableBarList().get(rowIndex)).get(shrinkOrder[growIndex]));
                    int growWidth = Math.max(0, Math.min(gapToGrow, srsW[index].preferred - srsW[index].minimum));
                    rects[index].width += growWidth;
                    gapToGrow -= growWidth;
                }
                for (i3 = 1; i3 < items.size(); ++i3) {
                    rects[i3].x = rects[i3 - 1].x + rects[i3 - 1].width;
                }
            }
            for (i = 0; i < rects.length; ++i) {
                Rectangle rect = rects[i];
                rect.y = rowLocation;
                rect.height = this._srHeight[rowIndex].preferred;
                DockableBarItem item = (DockableBarItem)items.get(i);
                rect.x += this._horizontalGap * i;
                item.getComponent().setBounds(rect);
            }
        } else {
            if (resizing) {
                int prefAfter;
                int prefBefore;
                preferredStart = activeItem.getStart() - activeIndex * this._horizontalGap;
                int minBefore = activeIndex < 0 ? 0 : this.getMinimumSize(0, activeIndex, srsW);
                int n = prefBefore = activeIndex < 0 ? totalSize : this.getPreferredSize(0, activeIndex, srsW);
                if (preferredStart < minBefore) {
                    preferredStart = minBefore;
                } else if (preferredStart > prefBefore) {
                    preferredStart = prefBefore;
                }
                int minAfter = activeIndex >= items.size() - 1 ? 0 : this.getMinimumSize(activeIndex + 1, items.size(), srsW);
                int n3 = prefAfter = activeIndex >= items.size() - 1 ? totalSize : this.getPreferredSize(activeIndex + 1, items.size(), srsW);
                if (preferredStart + srsW[activeIndex].preferred < totalSize - prefAfter) {
                    preferredStart = totalSize - prefAfter - srsW[activeIndex].preferred;
                    rects[activeIndex].height = srsW[activeIndex].preferred;
                } else if (preferredStart + srsW[activeIndex].minimum > totalSize - minAfter) {
                    preferredStart = totalSize - minAfter - srsW[activeIndex].minimum;
                    rects[activeIndex].height = srsW[activeIndex].minimum;
                } else if (minAfter == 0 && preferredStart + srsW[activeIndex].preferred < totalSize) {
                    preferredStart = totalSize - minAfter - srsW[activeIndex].preferred;
                    rects[activeIndex].height = srsW[activeIndex].preferred;
                }
                rects[activeIndex].y = preferredStart;
                if (activeIndex < items.size() - 1) {
                    rects[activeIndex].height = rects[activeIndex + 1].y - rects[activeIndex].y;
                    if (rects[activeIndex].height > srsW[activeIndex].preferred) {
                        rects[activeIndex].height = srsW[activeIndex].preferred;
                    }
                    if (rects[activeIndex].height < srsW[activeIndex].minimum) {
                        rects[activeIndex].height = srsW[activeIndex].minimum;
                    }
                    rects[activeIndex + 1].y = rects[activeIndex].y + rects[activeIndex].height;
                    this.shrink(rects, activeIndex + 1, items.size(), srsW, totalSize - rects[activeIndex + 1].y, true);
                } else {
                    rects[activeIndex].height = totalSize - rects[activeIndex].y;
                }
                this.shrink(rects, 0, activeIndex, srsW, rects[activeIndex].y, false);
            } else {
                int i5;
                int[] shrinkOrder;
                minimumSize = this.getMinimumSize(0, items.size(), srsW);
                for (int i6 = 0; i6 < items.size(); ++i6) {
                    rects[i6].height = srsW[i6].minimum;
                }
                int gapToGrow = totalSize - minimumSize;
                if (gapToGrow > 0 && activeIndex >= 0) {
                    int growHeight = Math.max(0, Math.min(gapToGrow, srsW[activeIndex].preferred - srsW[activeIndex].minimum));
                    rects[activeIndex].height += growHeight;
                    gapToGrow -= growHeight;
                }
                if (this._target.getShrinkOrderProvider() == null) {
                    shrinkOrder = new int[items.size()];
                    for (i5 = 0; i5 < items.size(); ++i5) {
                        shrinkOrder[i5] = items.size() - i5 - 1;
                    }
                } else {
                    shrinkOrder = this._target.getShrinkOrderProvider().getShrinkOrder(rowIndex);
                }
                for (int growIndex = items.size() - 1; gapToGrow > 0 && growIndex >= 0; --growIndex) {
                    if (growIndex == activeIndex) continue;
                    int index = items.indexOf(((DockableBarList)this._target.getDockableBarList().get(rowIndex)).get(shrinkOrder[growIndex]));
                    int growHeight = Math.max(0, Math.min(gapToGrow, srsW[index].preferred - srsW[index].minimum));
                    rects[index].height += growHeight;
                    gapToGrow -= growHeight;
                }
                for (i5 = 1; i5 < items.size(); ++i5) {
                    rects[i5].y = rects[i5 - 1].y + rects[i5 - 1].height;
                }
            }
            for (i = 0; i < rects.length; ++i) {
                Rectangle rect = rects[i];
                rect.x = rowLocation;
                rect.width = this._srHeight[rowIndex].preferred;
                DockableBarItem item = (DockableBarItem)items.get(i);
                rect.y += this._horizontalGap * i;
                item.getComponent().setBounds(rect);
            }
        }
    }

    private void shrink(Rectangle[] rects, int start, int end, SizeRequirements[] sizes, int avail, boolean order) {
        int preferred = this.getPreferredSize(start, end, sizes);
        int gap = preferred - avail;
        if (gap < 0) {
            gap = 0;
        }
        if (this._target.getOrientation() == 0) {
            if (order) {
                for (int i = start; i < end; ++i) {
                    if (i != start) {
                        rects[i].x = rects[i - 1].x + rects[i - 1].width;
                    }
                    if (gap > 0) {
                        if (sizes[i].preferred - sizes[i].minimum >= gap) {
                            rects[i].width = sizes[i].preferred - gap;
                            gap -= sizes[i].preferred - rects[i].width;
                            continue;
                        }
                        if (sizes[i].preferred - sizes[i].minimum < gap) {
                            rects[i].width = sizes[i].minimum;
                            gap -= sizes[i].preferred - rects[i].width;
                            continue;
                        }
                        rects[i].width = sizes[i].minimum;
                        gap -= sizes[i].preferred - rects[i].width;
                        continue;
                    }
                    rects[i].width = sizes[i].preferred;
                }
            } else {
                for (int i = end - 1; i >= start; --i) {
                    if (gap > 0) {
                        if (sizes[i].preferred - sizes[i].minimum >= gap) {
                            rects[i].width = sizes[i].preferred - gap;
                            gap -= sizes[i].preferred - rects[i].width;
                        } else if (sizes[i].preferred - sizes[i].minimum < gap) {
                            rects[i].width = sizes[i].minimum;
                            gap -= sizes[i].preferred - rects[i].width;
                        } else {
                            rects[i].width = sizes[i].minimum;
                            gap -= sizes[i].preferred - rects[i].width;
                        }
                    } else {
                        rects[i].width = sizes[i].preferred;
                    }
                    if (i == rects.length - 1) continue;
                    rects[i].x = rects[i + 1].x - rects[i].width;
                }
            }
        } else if (order) {
            for (int i = start; i < end; ++i) {
                if (i != start) {
                    rects[i].y = rects[i - 1].y + rects[i - 1].height;
                }
                if (gap > 0) {
                    if (sizes[i].preferred - sizes[i].minimum >= gap) {
                        rects[i].height = sizes[i].preferred - gap;
                        gap -= sizes[i].preferred - rects[i].height;
                        continue;
                    }
                    if (sizes[i].preferred - sizes[i].minimum < gap) {
                        rects[i].height = sizes[i].minimum;
                        gap -= sizes[i].preferred - rects[i].height;
                        continue;
                    }
                    rects[i].height = sizes[i].minimum;
                    gap -= sizes[i].preferred - rects[i].height;
                    continue;
                }
                rects[i].height = sizes[i].preferred;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (gap > 0) {
                    if (sizes[i].preferred - sizes[i].minimum >= gap) {
                        rects[i].height = sizes[i].preferred - gap;
                        gap -= sizes[i].preferred - rects[i].height;
                    } else if (sizes[i].preferred - sizes[i].minimum < gap) {
                        rects[i].height = sizes[i].minimum;
                        gap -= sizes[i].preferred - rects[i].height;
                    } else {
                        rects[i].height = sizes[i].minimum;
                        gap -= sizes[i].preferred - rects[i].height;
                    }
                } else {
                    rects[i].height = sizes[i].preferred;
                }
                if (i == rects.length - 1) continue;
                rects[i].y = rects[i + 1].y - rects[i].height;
            }
        }
    }

    private int getMinimumSize(int start, int end, SizeRequirements[] sizes) {
        int total = 0;
        for (int i = start; i < end; ++i) {
            SizeRequirements size = sizes[i];
            total += size.minimum;
        }
        return total;
    }

    private int getPreferredSize(int start, int end, SizeRequirements[] sizes) {
        int total = 0;
        for (int i = start; i < end; ++i) {
            SizeRequirements size = sizes[i];
            total += size.preferred;
        }
        return total;
    }
}

