/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBarPaneLayout;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingConstants;

class CommandBarPane
extends JPanel
implements Alignable,
SwingConstants,
MenuElement,
TopLevelMenuContainer {
    protected int _orientation = 0;
    private int _preferredRowCount;
    private boolean _usePreferredRowCount;
    private ArrayList _hiddenComponents = new ArrayList();
    private CommandBarPaneLayout _layout;

    public CommandBarPane() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this._layout = new CommandBarPaneLayout(this);
        this.setLayout(this._layout);
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    @Override
    public void setOrientation(int orientation) {
        this.checkOrientation(orientation);
        int old = this._orientation;
        if (this._orientation != orientation) {
            this._orientation = orientation;
            JideSwingUtilities.setChildrenOrientationOf(this, orientation);
            this.firePropertyChange("orientation", old, orientation);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    protected void checkOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public int getPreferredRowCount() {
        return this._preferredRowCount;
    }

    public void setPreferredRowCount(int preferredRowCount) {
        this._preferredRowCount = preferredRowCount;
    }

    public boolean isUsePreferredRowCount() {
        return this._usePreferredRowCount;
    }

    public void setUsePreferredRowCount(boolean usePreferredRowCount) {
        this._usePreferredRowCount = usePreferredRowCount;
    }

    public Component[] getHiddenComponents() {
        return this._hiddenComponents.toArray(new Component[this._hiddenComponents.size()]);
    }

    public void addHiddenComponent(Component component) {
        if (!this._hiddenComponents.contains(component)) {
            this._hiddenComponents.add(component);
        }
        if (component.getParent() == this) {
            this.remove(component);
        }
    }

    public void removeHiddenComponent(Component component) {
        if (this._hiddenComponents.contains(component)) {
            this._hiddenComponents.remove(component);
        }
        if (component.getParent() != this) {
            this.add(component);
        }
    }

    public void removeAllHiddenComponents() {
        this._hiddenComponents.clear();
    }

    @Override
    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
    }

    @Override
    public MenuElement[] getSubElements() {
        int i;
        Vector<Component> tmp = new Vector<Component>();
        int c = this.getComponentCount();
        for (i = 0; i < c; ++i) {
            Component m = this.getComponent(i);
            if (!(m instanceof MenuElement)) continue;
            tmp.addElement(m);
        }
        MenuElement[] result = new MenuElement[tmp.size()];
        c = tmp.size();
        for (i = 0; i < c; ++i) {
            result[i] = (MenuElement)tmp.elementAt(i);
        }
        return result;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public Rectangle getActualSize(int x, int y, int width, int height, int orientation, boolean start, boolean shrink) {
        return this._layout.getActualSize(this, x, y, width, height, orientation, start, shrink);
    }

    @Override
    public boolean isMenuBar() {
        return false;
    }
}

