/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.swing.DraggableHandle;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class CommandBarBorderListener
extends MouseInputAdapter
implements SwingConstants {
    private static int _eventMouseScreenX;
    private static int _eventMouseScreenY;
    private static int _eventMouseRelativeX;
    private static int _eventMouseRelativeY;
    private static double _relativeX;
    private static double _relativeY;
    private static Rectangle _startingBounds;
    private int _resizeDir;
    private static boolean _startInFloat;
    protected static final int RESIZE_NONE = 0;
    private boolean _discardRelease = false;
    private DockableBar _component;
    private DockableBarManager _dockableBarManager;
    static String _currentName;

    public CommandBarBorderListener(DockableBar component) {
        this._component = component;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._dockableBarManager = this._component.getDockableBarManager();
        if (this._dockableBarManager == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Container topLevelAncestor = this._component.getTopLevelAncestor();
        if (CommandBarBorderListener.isStartInDockingMode(topLevelAncestor)) {
            _startInFloat = false;
        } else {
            _startInFloat = true;
            if (topLevelAncestor instanceof Window) {
                ((Window)topLevelAncestor).toFront();
            }
        }
        if (this._component != null) {
            Point point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._component);
            _eventMouseRelativeX = point.x;
            _eventMouseRelativeY = point.y;
        }
        _startingBounds = this._component.getBounds();
        _relativeX = (double)_eventMouseRelativeX / (double)CommandBarBorderListener._startingBounds.width;
        _relativeY = (double)_eventMouseRelativeY / (double)CommandBarBorderListener._startingBounds.height;
        Point screenPoint = new Point(e.getX(), e.getY());
        CommandBarBorderListener.convertPointToScreen(screenPoint, (Component)e.getSource(), _startInFloat);
        _eventMouseScreenX = screenPoint.x;
        _eventMouseScreenY = screenPoint.y;
        if (this._component != null && e.getSource() instanceof DraggableHandle) {
            this._dockableBarManager.beginDraggingDockableBar(this._component, screenPoint.x, screenPoint.y, _relativeX, _relativeY, _startInFloat);
            return;
        }
        if (!_startInFloat) {
            return;
        }
        this._resizeDir = 0;
        if (e.getSource() == this._component) {
            Insets i = this._component.getInsets();
            if (i.right > 0 && e.getX() >= this._component.getWidth() - i.right) {
                this._resizeDir = 3;
            } else if (i.bottom > 0 && e.getY() >= this._component.getHeight() - i.bottom) {
                this._resizeDir = 5;
            } else {
                this._discardRelease = true;
                return;
            }
            Cursor s = Cursor.getDefaultCursor();
            switch (this._resizeDir) {
                case 5: {
                    s = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 3: {
                    s = Cursor.getPredefinedCursor(11);
                }
            }
            Container c = topLevelAncestor;
            if (c instanceof JFrame) {
                ((JFrame)c).getGlassPane().setVisible(true);
                ((JFrame)c).getGlassPane().setCursor(s);
            } else if (c instanceof JApplet) {
                ((JApplet)c).getGlassPane().setVisible(true);
                ((JApplet)c).getGlassPane().setCursor(s);
            } else if (c instanceof JWindow) {
                ((JWindow)c).getGlassPane().setVisible(true);
                ((JWindow)c).getGlassPane().setCursor(s);
            } else if (c instanceof JDialog) {
                ((JDialog)c).getGlassPane().setVisible(true);
                ((JDialog)c).getGlassPane().setCursor(s);
            }
            if (this._dockableBarManager != null) {
                this._dockableBarManager.beginResizingDockableBar(this._component, this._resizeDir);
            }
            return;
        }
    }

    private static boolean isStartInDockingMode(Component c) {
        return c instanceof JFrame || c instanceof JDialog;
    }

    public static void convertPointFromScreen(Point p, Component c, boolean startInFloat) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || (startInFloat ? c instanceof Window : CommandBarBorderListener.isStartInDockingMode(c))) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x -= x;
            p.y -= y;
            if (!startInFloat ? CommandBarBorderListener.isStartInDockingMode(c) : c instanceof Window) break;
        } while (!(c instanceof Applet) && (c = c.getParent()) != null);
    }

    public static void convertPointToScreen(Point p, Component c, boolean startInFloat) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || (startInFloat ? c instanceof Window : CommandBarBorderListener.isStartInDockingMode(c))) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x += x;
            p.y += y;
            if (!startInFloat ? CommandBarBorderListener.isStartInDockingMode(c) : c instanceof Window) break;
        } while (!(c instanceof Applet) && (c = c.getParent()) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._dockableBarManager == null) {
            return;
        }
        if (_startingBounds == null || this._discardRelease) {
            return;
        }
        Object object = this._component.getTreeLock();
        synchronized (object) {
            if (this._component != null && this._resizeDir == 0) {
                return;
            }
            Point screenPoint = new Point(e.getPoint());
            if (((Component)e.getSource()).isShowing()) {
                CommandBarBorderListener.convertPointToScreen(screenPoint, (Component)e.getSource(), _startInFloat);
            } else {
                CommandBarBorderListener.convertPointToScreen(screenPoint, (Component)e.getSource(), _startInFloat);
            }
            int deltaX = _eventMouseScreenX - screenPoint.x;
            int deltaY = _eventMouseScreenY - screenPoint.y;
            int newX = this._component.getX();
            int newY = this._component.getY();
            int newW = this._component.getWidth();
            int newH = this._component.getHeight();
            switch (this._resizeDir) {
                case 0: {
                    return;
                }
                case 3: {
                    newW = CommandBarBorderListener._startingBounds.width - deltaX;
                    newH = -1;
                    break;
                }
                case 5: {
                    newW = -1;
                    newH = CommandBarBorderListener._startingBounds.height - deltaY;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this._dockableBarManager != null) {
                this._dockableBarManager.resizingDockableBar(this._component, newX, newY, newW, newH, deltaX, deltaY);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._dockableBarManager == null) {
            return;
        }
        _startingBounds = null;
        if (this._discardRelease) {
            this._discardRelease = false;
            return;
        }
        if (this._resizeDir == 0) {
            if (this._component != null && this._dockableBarManager != null) {
                this._dockableBarManager.endDraggingDockableBar();
                return;
            }
        } else {
            Container c = this._component.getTopLevelAncestor();
            if (c instanceof JFrame) {
                ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setVisible(false);
            } else if (c instanceof JApplet) {
                ((JApplet)c).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JApplet)c).getGlassPane().setVisible(false);
            } else if (c instanceof JWindow) {
                ((JWindow)c).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JWindow)c).getGlassPane().setVisible(false);
            } else if (c instanceof JDialog) {
                ((JDialog)c).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JDialog)c).getGlassPane().setVisible(false);
            }
            if (this._dockableBarManager != null) {
                this._dockableBarManager.endResizingDockableBar(this._component);
            }
        }
        _eventMouseScreenX = 0;
        _eventMouseScreenY = 0;
        _eventMouseRelativeX = 0;
        _eventMouseRelativeY = 0;
        _startingBounds = null;
        this._resizeDir = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this._component) {
            if (!this._component.isFloating()) {
                return;
            }
            Insets i = this._component.getInsets();
            if (e.getX() >= this._component.getWidth() - i.right) {
                this._component.setCursor(Cursor.getPredefinedCursor(11));
            } else if (e.getY() >= this._component.getHeight() - i.bottom) {
                this._component.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this._component.setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        this._component.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this._component == null) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this._component == null) {
            return;
        }
        this._component.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this._component.getDockableBarManager() != null && e.getClickCount() == 2 && e.getButton() == 1 && this._component.getDockableBarManager().getDoubleClickAction() == 0) {
            this._component.getDockableBarManager().toggleState(this._component);
        }
    }
}

