/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBarBorderListener;
import com.jidesoft.action.CommandBarLayout;
import com.jidesoft.action.CommandBarSeparator;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.CommandBarUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;

public class CommandBar
extends DockableBar
implements SwingConstants,
TopLevelMenuContainer {
    private static final String uiClassID = "CommandBarUI";
    private boolean _paintBorder = true;
    private Insets _margin = null;
    private CommandBarBorderListener _borderListener;
    private int _preferredRowCount;
    private List<Component> _hiddenComponents = new ArrayList<Component>();
    protected CommandBarContainerListener _commandBarContainerListener;
    protected boolean _changingContainer;
    static boolean sUseScreenMenuBar = false;

    public CommandBar() {
        this(0);
    }

    public CommandBar(int orientation) {
        this("", null, orientation);
    }

    public CommandBar(String key) {
        this(key, null, 0);
    }

    public CommandBar(String key, String title) {
        this(key, title, 0);
    }

    public CommandBar(String key, String title, int orientation) {
        super(key, title);
        this.setOpaque(false);
        this.setPaintBackground(true);
        this.checkOrientation(orientation);
        this._orientation = orientation;
        DefaultCommandBarLayout layout = new DefaultCommandBarLayout(orientation);
        this.setLayout(layout);
        this.addPropertyChangeListener(layout);
        this._borderListener = this.createBorderListener();
        this.addMouseListener(this._borderListener);
        this.addMouseMotionListener(this._borderListener);
        this._commandBarContainerListener = new CommandBarContainerListener();
        this.addContainerListener(this._commandBarContainerListener);
        this.updateUI();
    }

    private CommandBarBorderListener createBorderListener() {
        return new CommandBarBorderListener(this);
    }

    @Override
    public MenuBarUI getUI() {
        return (CommandBarUI)this.ui;
    }

    @Override
    public void updateUI() {
        CommandBarUI ui;
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
        this.invalidate();
        if (!CommandBar.isScreenMenuBar(this) && (ui = (CommandBarUI)this.getUI()) != null) {
            Component[] components;
            Component titleBar;
            Component gripper = ui.getGripper();
            if (gripper != null) {
                gripper.addMouseListener(this._borderListener);
                gripper.addMouseMotionListener(this._borderListener);
            }
            if ((titleBar = ui.getTitleBar()) != null) {
                titleBar.addMouseListener(this._borderListener);
                titleBar.addMouseMotionListener(this._borderListener);
            }
            for (Component component : components = this.getHiddenComponents()) {
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).updateUI();
            }
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setMargin(Insets m) {
        Insets old = this._margin;
        this._margin = m;
        this.firePropertyChange("margin", old, m);
        this.revalidate();
        this.repaint();
    }

    @Override
    public Insets getMargin() {
        if (this._margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this._margin;
    }

    @Override
    public boolean isBorderPainted() {
        return this._paintBorder;
    }

    @Override
    public void setBorderPainted(boolean b) {
        if (this._paintBorder != b) {
            boolean old = this._paintBorder;
            this._paintBorder = b;
            this.firePropertyChange("borderPainted", old, b);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    public void setChangingContainer(boolean newChangingContainer) {
        if (this._changingContainer == newChangingContainer) {
            return;
        }
        this._changingContainer = newChangingContainer;
        if (!newChangingContainer) {
            this.validateWindowIfFloating();
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().invalidate();
            }
            if (this.getParent() != null && this.getParent().getParent() != null) {
                this.getParent().getParent().invalidate();
                this.getParent().getParent().validate();
            } else if (this.getParent() != null) {
                this.getParent().validate();
            } else {
                this.validate();
            }
        }
    }

    public void validateWindowIfFloating() {
        if (this._changingContainer) {
            return;
        }
        if (!this.isFloating()) {
            return;
        }
        JWindow window = (JWindow)SwingUtilities.getAncestorOfClass(JWindow.class, this);
        if (window != null) {
            this.invalidate();
            window.getRootPane().validate();
        }
    }

    public void addSeparator() {
        CommandBarSeparator s = new CommandBarSeparator();
        this.add(s);
    }

    public void addSeparator(Dimension size) {
        CommandBarSeparator s = new CommandBarSeparator();
        this.add(s);
    }

    public JComponent add(Action a) {
        JComponent b = this.createActionComponent(a);
        this.add(b);
        return b;
    }

    protected JComponent createActionComponent(Action a) {
        return this.createButton(a);
    }

    private JComponent createButton(Action a) {
        String text = a != null ? (String)a.getValue("Name") : null;
        Icon icon = a != null ? (Icon)a.getValue("SmallIcon") : null;
        boolean enabled = a == null || a.isEnabled();
        String tooltip = a != null ? (String)a.getValue("ShortDescription") : null;
        JideButton b = new JideButton(text, icon){

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = CommandBar.this.createActionChangeListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        if (icon != null) {
            b.putClientProperty("hideActionText", Boolean.TRUE);
        }
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setEnabled(enabled);
        b.setToolTipText(tooltip);
        b.setAction(a);
        return b;
    }

    protected PropertyChangeListener createActionChangeListener(JComponent component) {
        return null;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof UIResource) {
            super.addImpl(comp, constraints, index);
        } else if (!(this.isDuringLayout() || this._hiddenComponents.size() == 0 || index != -1 && index < this.getMenuCount())) {
            if (index == -1) {
                this.addHiddenComponent(comp);
            } else {
                this.addHiddenComponent(comp, index - this.getMenuCount());
            }
        } else if (index < 0) {
            super.addImpl(comp, constraints, index);
        } else {
            Component[] components = this.getComponents();
            int skip = 0;
            for (Component component : components) {
                if (!(component instanceof UIResource)) break;
                ++skip;
            }
            super.addImpl(comp, constraints, index + skip);
        }
        if (comp instanceof JButton) {
            ((JButton)comp).setDefaultCapable(false);
        }
    }

    public static boolean isScreenMenuBar(JMenuBar jMenuBar) {
        if (sUseScreenMenuBar) {
            Container container;
            if (jMenuBar instanceof CommandMenuBar) {
                return true;
            }
            MenuBarUI ui = jMenuBar.getUI();
            if (ui instanceof CommandBarUI && (container = jMenuBar.getTopLevelAncestor()) instanceof JFrame) {
                boolean flag;
                MenuBar menuBar = ((JFrame)container).getMenuBar();
                boolean bl = flag = ((JFrame)container).getJMenuBar() == jMenuBar;
                if (menuBar == null) {
                    return flag;
                }
                return menuBar.getClass().getName().endsWith("ScreenMenuBar") && flag;
            }
        }
        return false;
    }

    void purposeBounds(int x, int y, int width, int height, int deltaX, int saveDeltaX, int deltaY, int saveDeltaY) {
        if (this.isFloating()) {
            DefaultCommandBarLayout layout = (DefaultCommandBarLayout)this.getLayout();
            Rectangle rect = null;
            if (width == -1 && deltaY != saveDeltaY) {
                rect = y == this.getY() ? layout.getActualSize(this, x, y, width, height, 1, true, deltaY > saveDeltaY) : layout.getActualSize(this, x, y, width, height, 1, false, deltaY < saveDeltaY);
            } else if (deltaX != saveDeltaX && height == -1) {
                rect = x == this.getX() ? layout.getActualSize(this, x, y, width, height, 0, true, deltaX > saveDeltaX) : layout.getActualSize(this, x, y, width, height, 0, false, deltaX < saveDeltaX);
            }
            if (rect != null) {
                x = rect.x;
                y = rect.y;
                width = rect.width;
                height = rect.height;
            }
        }
        if (width == -1) {
            width = this.getWidth();
        }
        if (height == -1) {
            height = this.getHeight();
        }
        super.setBounds(x, y, width, height);
    }

    public int getPreferredRowCount() {
        return this._preferredRowCount;
    }

    public void setPreferredRowCount(int preferredRowCount) {
        if (this._preferredRowCount != preferredRowCount) {
            this.invalidate();
        }
        this._preferredRowCount = preferredRowCount;
    }

    public Component[] getHiddenComponents() {
        if (this._hiddenComponents == null) {
            return new Component[0];
        }
        return this._hiddenComponents.toArray(new Component[this._hiddenComponents.size()]);
    }

    void addHiddenComponent(Component component) {
        if (!this._hiddenComponents.contains(component)) {
            this._hiddenComponents.add(component);
        }
        if (component.getParent() == this) {
            this.remove(component);
        }
    }

    boolean isComponentHidden(Component component) {
        return this._hiddenComponents != null && this._hiddenComponents.contains(component);
    }

    void addHiddenComponent(Component component, int index) {
        if (!this._hiddenComponents.contains(component)) {
            this._hiddenComponents.add(index, component);
        }
        if (component.getParent() == this) {
            this.remove(component);
        }
    }

    @Override
    public void remove(Component comp) {
        Component[] comps = this.getComponents();
        boolean contains = false;
        for (Component component : comps) {
            if (component != comp) continue;
            contains = true;
            break;
        }
        if (contains) {
            super.remove(comp);
        } else if (this._hiddenComponents.contains(comp)) {
            this._hiddenComponents.remove(comp);
        }
    }

    @Override
    public void removeAll() {
        Component[] components;
        this._hiddenComponents.clear();
        for (Component component : components = this.getComponents()) {
            if (component instanceof UIResource) continue;
            this.remove(component);
        }
    }

    void removeHiddenComponent(Component component) {
        if (this._hiddenComponents.contains(component)) {
            this._hiddenComponents.remove(component);
        }
        if (component.getParent() != this) {
            this.add(component);
        }
    }

    public void removeAllHiddenComponents() {
        Component[] components;
        for (Component component : components = this._hiddenComponents.toArray(new Component[this._hiddenComponents.size()])) {
            this.removeHiddenComponent(component);
        }
    }

    @Override
    public int getMenuCount() {
        Component[] components = this.getComponents();
        int actualCount = 0;
        for (Component component : components) {
            if (component instanceof UIResource) continue;
            ++actualCount;
        }
        return actualCount;
    }

    @Override
    public JMenu getMenu(int index) {
        Component[] components = this.getComponents();
        int actualCount = 0;
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof UIResource) continue;
            if (index == actualCount) {
                return super.getMenu(i);
            }
            ++actualCount;
        }
        return null;
    }

    public void addExpansion() {
        this.add(new Expansion());
    }

    @Override
    public void adjustChildrenOrientation(int orientation) {
        Component[] components;
        super.adjustChildrenOrientation(orientation);
        for (Component component : components = this.getHiddenComponents()) {
            JideSwingUtilities.setOrientationOf(component, orientation);
        }
    }

    static {
        if (SystemInfo.isMacOSX()) {
            String[] as = new String[]{""};
            boolean flag = false;
            try {
                as[0] = SecurityUtils.getProperty("apple.laf.useScreenMenuBar", null);
                if (as[0] != null && as[0].equals("true")) {
                    flag = true;
                } else {
                    as[0] = SecurityUtils.getProperty("com.apple.macos.useScreenMenuBar", null);
                    if (as[0] != null && as[0].equals("true")) {
                        System.err.println("com.apple.macos.useScreenMenuBar has been deprecated. Please switch to apple.laf.useScreenMenuBar");
                        flag = true;
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.println("Problem in Menu Bar static initializer! :  " + throwable);
                throwable.printStackTrace();
            }
            sUseScreenMenuBar = flag;
        }
    }

    private class DefaultCommandBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        CommandBarLayout lm;

        DefaultCommandBarLayout(int orientation) {
            this.lm = orientation == 1 ? new CommandBarLayout(CommandBar.this, 3) : new CommandBarLayout(CommandBar.this, 2);
            CommandBar.this.addPropertyChangeListener(this);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.lm.addLayoutComponent(name, comp);
            this.lm.invalidateLayout(CommandBar.this);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.lm.addLayoutComponent(comp, constraints);
            this.lm.invalidateLayout(CommandBar.this);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.lm.removeLayoutComponent(comp);
            this.lm.invalidateLayout(CommandBar.this);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.lm.preferredLayoutSize(target);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.lm.minimumLayoutSize(target);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            if (this.lm != null) {
                return this.lm.maximumLayoutSize(target);
            }
            return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }

        @Override
        public void layoutContainer(Container target) {
            this.lm.layoutContainer(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            if (this.lm != null) {
                return this.lm.getLayoutAlignmentX(target);
            }
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            if (this.lm != null) {
                return this.lm.getLayoutAlignmentY(target);
            }
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            if (this.lm != null) {
                this.lm.invalidateLayout(target);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("floating")) {
                this.lm.invalidateLayout(CommandBar.this);
            } else if (name.equals("horiDocked")) {
                this.lm.invalidateLayout(CommandBar.this);
            } else if (name.equals("vertDocked")) {
                this.lm.invalidateLayout(CommandBar.this);
            } else if (name.equals("orientation")) {
                int o = (Integer)e.getNewValue();
                this.lm = o == 1 ? new CommandBarLayout(CommandBar.this, 3) : new CommandBarLayout(CommandBar.this, 2);
            }
        }

        public Rectangle getActualSize(Container target, int x, int y, int width, int height, int orientation, boolean start, boolean shrink) {
            return this.lm.getActualSize(target, x, y, width, height, orientation, start, shrink);
        }
    }

    protected class CommandBarContainerListener
    implements ContainerListener {
        protected CommandBarContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            CommandBar.this.validateWindowIfFloating();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            CommandBar.this.validateWindowIfFloating();
        }
    }

    public static class Expansion
    extends Box.Filler
    implements Alignable {
        private int _orientation;

        public Expansion() {
            super(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        }

        @Override
        public boolean supportVerticalOrientation() {
            return true;
        }

        @Override
        public boolean supportHorizontalOrientation() {
            return true;
        }

        @Override
        public int getOrientation() {
            return this._orientation;
        }

        @Override
        public void setOrientation(int orientation) {
            this._orientation = orientation;
        }
    }
}

