/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUris;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.xmlgraphics.io.Resource;

public class FontInfoFinder {
    private final Log log = LogFactory.getLog(FontInfoFinder.class);
    private FontEventListener eventListener;
    private final Pattern quotePattern = Pattern.compile("'");

    public void setEventListener(FontEventListener listener) {
        this.eventListener = listener;
    }

    private void generateTripletsFromFont(CustomFont customFont, Collection<FontTriplet> triplets) {
        int guessedWeight;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Font: " + customFont.getFullName() + ", family: " + customFont.getFamilyNames() + ", PS: " + customFont.getFontName() + ", EmbedName: " + customFont.getEmbedFontName()));
        }
        String strippedName = this.stripQuotes(customFont.getStrippedFontName());
        String fullName = this.stripQuotes(customFont.getFullName());
        String searchName = fullName.toLowerCase();
        String style = this.guessStyle(customFont, searchName);
        int weight = guessedWeight = FontUtil.guessWeight((String)searchName);
        triplets.add(new FontTriplet(fullName, "normal", 400));
        if (!fullName.equals(strippedName)) {
            triplets.add(new FontTriplet(strippedName, "normal", 400));
        }
        Set familyNames = customFont.getFamilyNames();
        for (String familyName : familyNames) {
            if (fullName.equals(familyName = this.stripQuotes(familyName))) continue;
            int priority = fullName.startsWith(familyName) ? fullName.length() - familyName.length() : fullName.length();
            triplets.add(new FontTriplet(familyName, style, weight, priority));
        }
    }

    private String stripQuotes(String name) {
        return this.quotePattern.matcher(name).replaceAll("");
    }

    private String guessStyle(CustomFont customFont, String fontName) {
        String style = "normal";
        style = customFont.getItalicAngle() > 0 ? "italic" : FontUtil.guessStyle((String)fontName);
        return style;
    }

    private EmbedFontInfo getFontInfoFromCustomFont(URI fontUri, CustomFont customFont, FontCache fontCache, InternalResourceResolver resourceResolver) {
        FontUris fontUris = new FontUris(fontUri, null);
        ArrayList<FontTriplet> fontTripletList = new ArrayList<FontTriplet>();
        this.generateTripletsFromFont(customFont, fontTripletList);
        String subFontName = null;
        if (customFont instanceof MultiByteFont) {
            subFontName = ((MultiByteFont)customFont).getTTCName();
        }
        EmbedFontInfo fontInfo = new EmbedFontInfo(fontUris, customFont.isKerningEnabled(), customFont.isAdvancedEnabled(), fontTripletList, subFontName);
        fontInfo.setPostScriptName(customFont.getFontName());
        if (fontCache != null) {
            fontCache.addFont(fontInfo, resourceResolver);
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedFontInfo[] find(URI fontURI, InternalResourceResolver resourceResolver, FontCache fontCache) {
        URI embedUri = resourceResolver.resolveFromBase(fontURI);
        String embedStr = embedUri.toASCIIString();
        boolean useKerning = true;
        boolean useAdvanced = true;
        long fileLastModified = -1L;
        if (fontCache != null) {
            fileLastModified = FontCache.getLastModified((URI)fontURI);
            if (fontCache.containsFont(embedStr)) {
                EmbedFontInfo[] fontInfos = fontCache.getFontInfos(embedStr, fileLastModified);
                if (fontInfos != null) {
                    return fontInfos;
                }
            } else if (fontCache.isFailedFont(embedStr, fileLastModified)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping font file that failed to load previously: " + embedUri));
                }
                return null;
            }
        }
        CustomFont customFont = null;
        if (fontURI.toASCIIString().toLowerCase().endsWith(".ttc")) {
            List ttcNames = null;
            Resource in = null;
            try {
                in = resourceResolver.getResource(fontURI);
                try {
                    TTFFile ttf = new TTFFile(false, false);
                    FontFileReader reader = new FontFileReader((InputStream)in);
                    ttcNames = ttf.getTTCnames(reader);
                    if (ttcNames == null) {
                        EmbedFontInfo[] embedFontInfoArray = null;
                        return embedFontInfoArray;
                    }
                }
                catch (OutOfMemoryError oom) {
                    this.handleOOM(fontURI);
                }
            }
            catch (Throwable e) {
                if (this.eventListener != null) {
                    this.eventListener.fontLoadingErrorAtAutoDetection((Object)this, fontURI.toASCIIString(), (Exception)new RuntimeException(e));
                }
                Iterator iterator = null;
                return iterator;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            ArrayList<EmbedFontInfo> embedFontInfoList = new ArrayList<EmbedFontInfo>();
            for (String fontName : ttcNames) {
                EmbedFontInfo fi;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading " + fontName));
                }
                try {
                    try {
                        OFFontLoader ttfLoader = new OFFontLoader(fontURI, fontName, true, EmbeddingMode.AUTO, EncodingMode.AUTO, useKerning, useAdvanced, resourceResolver, false, false, true);
                        customFont = ttfLoader.getFont();
                        if (this.eventListener != null) {
                            customFont.setEventListener(this.eventListener);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        this.handleOOM(fontURI);
                    }
                }
                catch (Throwable e) {
                    if (fontCache != null) {
                        fontCache.registerFailedFont(embedUri.toASCIIString(), fileLastModified);
                    }
                    if (this.eventListener == null) continue;
                    this.eventListener.fontLoadingErrorAtAutoDetection((Object)this, embedUri.toASCIIString(), (Exception)new RuntimeException(e));
                    continue;
                }
                if ((fi = this.getFontInfoFromCustomFont(fontURI, customFont, fontCache, resourceResolver)) == null) continue;
                embedFontInfoList.add(fi);
            }
            return embedFontInfoList.toArray(new EmbedFontInfo[embedFontInfoList.size()]);
        }
        try {
            FontUris fontUris = new FontUris(fontURI, null);
            customFont = FontLoader.loadFont((FontUris)fontUris, null, (boolean)true, (EmbeddingMode)EmbeddingMode.AUTO, (EncodingMode)EncodingMode.AUTO, (boolean)useKerning, (boolean)useAdvanced, (InternalResourceResolver)resourceResolver, (boolean)false, (boolean)false, (boolean)true);
            if (this.eventListener != null) {
                customFont.setEventListener(this.eventListener);
            }
        }
        catch (Throwable e) {
            if (fontCache != null) {
                fontCache.registerFailedFont(embedUri.toASCIIString(), fileLastModified);
            }
            if (this.eventListener != null) {
                this.eventListener.fontLoadingErrorAtAutoDetection((Object)this, embedUri.toASCIIString(), (Exception)new RuntimeException(e));
            }
            return null;
        }
        EmbedFontInfo fi = this.getFontInfoFromCustomFont(fontURI, customFont, fontCache, resourceResolver);
        if (fi != null) {
            return new EmbedFontInfo[]{fi};
        }
        return null;
    }

    private void handleOOM(URI fontURI) throws IOException {
        Object sizeMsg = "";
        if ("file".equals(fontURI.getScheme())) {
            sizeMsg = "The font file size was: " + new File(fontURI).length() + " bytes";
        }
        throw new IOException("Font is too large. If you need this font in your PDF, see the userguide about increasing the maximum memory size for the publishing process. " + (String)sizeMsg);
    }
}

