/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.xsd.XsdProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ValidatorImpl
extends ParserConfigurationSettings
implements Validator,
ContentHandler,
DTDHandler,
XMLLocator,
XMLEntityResolver,
EntityState {
    private final XMLSchemaValidator schemaValidator = new XMLSchemaValidator();
    private final XMLErrorReporter errorReporter = new XMLErrorReporter();
    private final XMLEntityManager entityManager = new XMLEntityManager();
    private final ValidationManager validationManager = new ValidationManager();
    private final NamespaceContext namespaceContext = new NamespaceSupport();
    private final XMLAttributes attributes = new XMLAttributesImpl();
    private final SymbolTable symbolTable;
    private final XMLComponent[] components;
    private Locator locator;
    private final Set<String> entities = new HashSet<String>();
    private boolean pushedContext = false;
    private static final String[] recognizedFeatures = new String[]{"http://apache.org/xml/features/validation/schema/augment-psvi", "http://apache.org/xml/features/validation/schema-full-checking", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/cta-full-xpath-checking"};
    private static final String[] recognizedProperties = new String[]{"http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/validation/schema/version"};

    ValidatorImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool, PropertyMap properties) {
        this.symbolTable = symbolTable;
        ErrorHandlerWrapper errorHandlerWrapper = new ErrorHandlerWrapper(properties.get(ValidateProperty.ERROR_HANDLER));
        this.components = new XMLComponent[]{this.errorReporter, this.schemaValidator, this.entityManager};
        for (int i = 0; i < this.components.length; ++i) {
            this.addRecognizedFeatures(this.components[i].getRecognizedFeatures());
            this.addRecognizedProperties(this.components[i].getRecognizedProperties());
        }
        this.addRecognizedFeatures(recognizedFeatures);
        this.addRecognizedProperties(recognizedProperties);
        this.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", true);
        this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.setFeature("http://apache.org/xml/features/validation/id-idref-checking", true);
        this.setFeature("http://apache.org/xml/features/validation/identity-constraint-checking", true);
        this.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
        this.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
        this.errorReporter.setDocumentLocator((XMLLocator)this);
        this.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.errorReporter);
        this.setProperty("http://apache.org/xml/properties/internal/error-handler", errorHandlerWrapper);
        this.setProperty("http://apache.org/xml/properties/internal/validation-manager", this.validationManager);
        this.setProperty("http://apache.org/xml/properties/internal/entity-manager", this.entityManager);
        this.setProperty("http://apache.org/xml/properties/internal/entity-resolver", this);
        String xsdVersion = properties.get(XsdProperty.XSD_VERSION);
        if (xsdVersion != null) {
            this.setProperty("http://apache.org/xml/properties/validation/schema/version", "http://www.w3.org/XML/XMLSchema/v" + xsdVersion);
            this.setFeature("http://apache.org/xml/features/validation/type-alternative-checking", Boolean.TRUE);
        }
        if (properties.get(XsdProperty.FULL_XPATH) != null) {
            this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.validationManager.reset();
        this.namespaceContext.reset();
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].reset((XMLComponentManager)this);
        }
        this.validationManager.setEntityState((EntityState)this);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        this.entities.add(name);
    }

    public boolean isEntityDeclared(String name) {
        return this.entities.contains(name);
    }

    public boolean isEntityUnparsed(String name) {
        return this.entities.contains(name);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.schemaValidator.startDocument((XMLLocator)(this.locator == null ? null : this), null, this.namespaceContext, null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.schemaValidator.endDocument(null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (!this.pushedContext) {
                this.namespaceContext.pushContext();
            } else {
                this.pushedContext = false;
            }
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                this.attributes.addAttribute(this.makeQName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i)), this.symbolTable.addSymbol(atts.getType(i)), atts.getValue(i));
            }
            this.schemaValidator.startElement(this.makeQName(namespaceURI, localName, qName), this.attributes, null);
            this.attributes.removeAllAttributes();
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.schemaValidator.endElement(this.makeQName(namespaceURI, localName, qName), null);
            this.namespaceContext.popContext();
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (!this.pushedContext) {
                this.namespaceContext.pushContext();
                this.pushedContext = true;
            }
            prefix = prefix == null ? XMLSymbols.EMPTY_STRING : this.symbolTable.addSymbol(prefix);
            if (uri != null) {
                uri = uri.equals("") ? null : this.symbolTable.addSymbol(uri);
            }
            this.namespaceContext.declarePrefix(prefix, uri);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.schemaValidator.characters(new XMLString(ch, start, length), null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.schemaValidator.ignorableWhitespace(new XMLString(ch, start, length), null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private QName makeQName(String namespaceURI, String localName, String qName) {
        String prefix;
        localName = this.symbolTable.addSymbol(localName);
        if (namespaceURI.equals("")) {
            namespaceURI = null;
            prefix = XMLSymbols.EMPTY_STRING;
            qName = localName;
        } else {
            namespaceURI = this.symbolTable.addSymbol(namespaceURI);
            if (qName.equals("")) {
                prefix = this.namespaceContext.getPrefix(namespaceURI);
                qName = prefix == XMLSymbols.EMPTY_STRING ? localName : (prefix == null ? localName : this.symbolTable.addSymbol(prefix + ":" + localName));
            } else {
                int colon = (qName = this.symbolTable.addSymbol(qName)).indexOf(58);
                prefix = colon > 0 ? this.symbolTable.addSymbol(qName.substring(0, colon)) : XMLSymbols.EMPTY_STRING;
            }
        }
        return new QName(prefix, localName, qName, namespaceURI);
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        return null;
    }

    public String getPublicId() {
        return this.locator.getPublicId();
    }

    public String getEncoding() {
        return null;
    }

    public String getBaseSystemId() {
        return null;
    }

    public String getLiteralSystemId() {
        return null;
    }

    public String getExpandedSystemId() {
        return this.locator.getSystemId();
    }

    public int getLineNumber() {
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator.getColumnNumber();
    }

    public int getCharacterOffset() {
        return -1;
    }

    public String getXMLVersion() {
        return "1.0";
    }

    static SAXException toSAXException(XNIException e) {
        if (e instanceof XMLParseException) {
            XMLParseException pe = (XMLParseException)e;
            return new SAXParseException(pe.getMessage(), pe.getPublicId(), pe.getExpandedSystemId(), pe.getLineNumber(), pe.getColumnNumber(), pe.getException());
        }
        Exception nested = e.getException();
        if (nested == null) {
            return new SAXException(e.getMessage());
        }
        if (nested instanceof SAXException) {
            return (SAXException)nested;
        }
        if (nested instanceof RuntimeException) {
            throw (RuntimeException)nested;
        }
        return new SAXException(nested);
    }
}

