/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.ApplyAfterFunction;
import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DataDerivTypeFunction;
import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.StartAttributeDerivFunction;
import com.thaiopensource.relaxng.pattern.StartTagOpenDerivFunction;
import com.thaiopensource.relaxng.pattern.StartTagOpenRecoverDerivFunction;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.ValidationContext;

public final class PatternMemo {
    private final Pattern pattern;
    private final ValidatorPatternBuilder builder;
    private final boolean notAllowed;
    private PatternMemo memoEndAttributes;
    private PatternMemo memoTextOnly;
    private PatternMemo memoEndTagDeriv;
    private PatternMemo memoMixedTextDeriv;
    private PatternMemo memoIgnoreMissingAttributes;
    private Map<Name, PatternMemo> startTagOpenDerivMap;
    private Map<Name, PatternMemo> startTagOpenRecoverDerivMap;
    private Map<Name, PatternMemo> startAttributeDerivMap;
    private DataDerivType memoDataDerivType;
    private PatternMemo memoRecoverAfter;
    private PatternMemo memoEmptyAfter;
    private NormalizedNameClass memoPossibleAttributeNames;
    private NormalizedNameClass memoPossibleStartTagNames;

    public PatternMemo(Pattern pattern, ValidatorPatternBuilder builder) {
        this.pattern = pattern;
        this.builder = builder;
        this.notAllowed = pattern.isNotAllowed();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    ValidatorPatternBuilder getPatternBuilder() {
        return this.builder;
    }

    public boolean isNotAllowed() {
        return this.notAllowed;
    }

    public PatternMemo endAttributes() {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(this.builder.getEndAttributesFunction());
        }
        return this.memoEndAttributes;
    }

    PatternMemo endAttributes(PatternFunction<Pattern> f) {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(f);
        }
        return this.memoEndAttributes;
    }

    public PatternMemo ignoreMissingAttributes() {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(this.builder.getIgnoreMissingAttributesFunction());
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo ignoreMissingAttributes(PatternFunction<Pattern> f) {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(f);
        }
        return this.memoIgnoreMissingAttributes;
    }

    public PatternMemo textOnly() {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(this.builder.getTextOnlyFunction());
        }
        return this.memoTextOnly;
    }

    PatternMemo textOnly(PatternFunction<Pattern> f) {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(f);
        }
        return this.memoTextOnly;
    }

    public PatternMemo endTagDeriv() {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(this.builder.getEndTagDerivFunction());
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo endTagDeriv(PatternFunction<Pattern> f) {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(f);
        }
        return this.memoEndTagDeriv;
    }

    public PatternMemo mixedTextDeriv() {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(this.builder.getMixedTextDerivFunction());
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo mixedTextDeriv(PatternFunction<Pattern> f) {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(f);
        }
        return this.memoMixedTextDeriv;
    }

    public PatternMemo startTagOpenDeriv(Name name) {
        return this.startTagOpenDeriv(name, null);
    }

    PatternMemo startTagOpenDeriv(StartTagOpenDerivFunction f) {
        return this.startTagOpenDeriv(f.getName(), f);
    }

    private PatternMemo startTagOpenDeriv(Name name, StartTagOpenDerivFunction f) {
        PatternMemo tem;
        if (this.startTagOpenDerivMap == null) {
            this.startTagOpenDerivMap = new HashMap<Name, PatternMemo>();
        } else {
            tem = this.startTagOpenDerivMap.get(name);
            if (tem != null) {
                return tem;
            }
        }
        if (f == null) {
            f = new StartTagOpenDerivFunction(name, this.builder);
        }
        tem = this.applyForPatternMemo(f);
        this.startTagOpenDerivMap.put(name, tem);
        return tem;
    }

    public PatternMemo startTagOpenRecoverDeriv(Name name) {
        return this.startTagOpenRecoverDeriv(name, null);
    }

    PatternMemo startTagOpenRecoverDeriv(StartTagOpenRecoverDerivFunction f) {
        return this.startTagOpenRecoverDeriv(f.getName(), f);
    }

    private PatternMemo startTagOpenRecoverDeriv(Name name, StartTagOpenRecoverDerivFunction f) {
        PatternMemo tem;
        if (this.startTagOpenRecoverDerivMap == null) {
            this.startTagOpenRecoverDerivMap = new HashMap<Name, PatternMemo>();
        } else {
            tem = this.startTagOpenRecoverDerivMap.get(name);
            if (tem != null) {
                return tem;
            }
        }
        if (f == null) {
            f = new StartTagOpenRecoverDerivFunction(name, this.builder);
        }
        tem = this.applyForPatternMemo(f);
        this.startTagOpenRecoverDerivMap.put(name, tem);
        return tem;
    }

    public PatternMemo startAttributeDeriv(Name name) {
        return this.startAttributeDeriv(name, null);
    }

    PatternMemo startAttributeDeriv(StartAttributeDerivFunction f) {
        return this.startAttributeDeriv(f.getName(), f);
    }

    private PatternMemo startAttributeDeriv(Name name, StartAttributeDerivFunction f) {
        PatternMemo tem;
        if (this.startAttributeDerivMap == null) {
            this.startAttributeDerivMap = new HashMap<Name, PatternMemo>();
        } else {
            tem = this.startAttributeDerivMap.get(name);
            if (tem != null) {
                return tem;
            }
        }
        if (f == null) {
            f = new StartAttributeDerivFunction(name, this.builder);
        }
        tem = this.applyForPatternMemo(f);
        this.startAttributeDerivMap.put(name, tem);
        return tem;
    }

    DataDerivType dataDerivType() {
        if (this.memoDataDerivType == null) {
            this.memoDataDerivType = DataDerivTypeFunction.dataDerivType(this.builder, this.pattern).copy();
        }
        return this.memoDataDerivType;
    }

    public PatternMemo dataDeriv(String str, ValidationContext vc) {
        return this.dataDerivType().dataDeriv(this.builder, this.pattern, str, vc, null);
    }

    PatternMemo dataDeriv(String str, ValidationContext vc, List<DataDerivFailure> fail) {
        return this.dataDerivType().dataDeriv(this.builder, this.pattern, str, vc, fail);
    }

    public PatternMemo recoverAfter() {
        if (this.memoRecoverAfter == null) {
            this.memoRecoverAfter = this.applyForPatternMemo(this.builder.getRecoverAfterFunction());
        }
        return this.memoRecoverAfter;
    }

    PatternMemo emptyAfter() {
        if (this.memoEmptyAfter == null) {
            this.memoEmptyAfter = this.applyForPatternMemo(new ApplyAfterFunction(this.builder){

                @Override
                public Pattern apply(Pattern p) {
                    return PatternMemo.this.builder.makeEmpty();
                }

                @Override
                public Pattern caseOther(Pattern p) {
                    return p;
                }
            });
        }
        return this.memoEmptyAfter;
    }

    NormalizedNameClass possibleStartTagNames() {
        if (this.memoPossibleStartTagNames == null) {
            this.memoPossibleStartTagNames = this.builder.getPossibleStartTagNamesFunction().applyTo(this.pattern);
        }
        return this.memoPossibleStartTagNames;
    }

    NormalizedNameClass possibleAttributeNames() {
        if (this.memoPossibleAttributeNames == null) {
            this.memoPossibleAttributeNames = this.builder.getPossibleAttributeNamesFunction().applyTo(this.pattern);
        }
        return this.memoPossibleAttributeNames;
    }

    private PatternMemo applyForPatternMemo(PatternFunction<Pattern> f) {
        return this.builder.getPatternMemo(this.pattern.apply(f));
    }
}

