/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.SAXException;

public class OneOrMorePattern
extends Pattern {
    private final Pattern p;

    OneOrMorePattern(Pattern p) {
        super(p.isNullable(), p.getContentType(), OneOrMorePattern.combineHashCode(19, p.hashCode()));
        this.p = p;
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep = this.p.expand(b);
        if (ep != this.p) {
            return b.makeOneOrMore(ep);
        }
        return this;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_one_or_more");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_one_or_more");
            }
        }
        this.p.checkRestrictions(context == 1 ? 2 : context, dad, alpha);
        if (context != 6 && !OneOrMorePattern.contentTypeGroupable(this.p.getContentType(), this.p.getContentType())) {
            throw new RestrictionViolationException("one_or_more_string");
        }
    }

    @Override
    boolean samePattern(Pattern other) {
        return other instanceof OneOrMorePattern && this.p == ((OneOrMorePattern)other).p;
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseOneOrMore(this);
    }

    public Pattern getOperand() {
        return this.p;
    }
}

