/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.HashSet;
import java.util.Set;

public class FindElementFunction
extends AbstractPatternFunction<VoidValue> {
    private final ValidatorPatternBuilder builder;
    private final Name name;
    private final Set<Pattern> processed = new HashSet<Pattern>();
    private int specificity = -1;
    private Pattern pattern = null;

    public static Pattern findElement(ValidatorPatternBuilder builder, Name name, Pattern start) {
        FindElementFunction f = new FindElementFunction(builder, name);
        start.apply(f);
        if (f.pattern == null) {
            return builder.makeNotAllowed();
        }
        return f.pattern;
    }

    private FindElementFunction(ValidatorPatternBuilder builder, Name name) {
        this.builder = builder;
        this.name = name;
    }

    private boolean haveProcessed(Pattern p) {
        if (this.processed.contains(p)) {
            return true;
        }
        this.processed.add(p);
        return false;
    }

    private VoidValue caseBinary(BinaryPattern p) {
        if (!this.haveProcessed(p)) {
            p.getOperand1().apply(this);
            p.getOperand2().apply(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseGroup(GroupPattern p) {
        return this.caseBinary(p);
    }

    @Override
    public VoidValue caseInterleave(InterleavePattern p) {
        return this.caseBinary(p);
    }

    @Override
    public VoidValue caseChoice(ChoicePattern p) {
        return this.caseBinary(p);
    }

    @Override
    public VoidValue caseOneOrMore(OneOrMorePattern p) {
        if (!this.haveProcessed(p)) {
            p.getOperand().apply(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseElement(ElementPattern p) {
        if (!this.haveProcessed(p)) {
            int s = p.getNameClass().containsSpecificity(this.name);
            if (s > this.specificity) {
                this.specificity = s;
                this.pattern = p.getContent();
            } else if (s == this.specificity && s != -1) {
                this.pattern = this.builder.makeChoice(this.pattern, p.getContent());
            }
            p.getContent().apply(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseOther(Pattern p) {
        return VoidValue.VOID;
    }
}

