/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DefaultValuesExtractor {
    private DefaultValuesListener listener;
    private final List<Pattern> patternList = new ArrayList<Pattern>();
    private final HashSet<Pattern> patternSet = new HashSet();
    private ElementContentVisitor ecv = new ElementContentVisitor();
    private ElementsVisitor ev = new ElementsVisitor();

    public DefaultValuesExtractor(DefaultValuesListener listener) {
        this.listener = listener;
    }

    public void parsePattern(Pattern p) {
        p.apply(this.ecv);
        for (int i = 0; i < this.patternList.size(); ++i) {
            Pattern tem = this.patternList.get(i);
            tem.apply(this.ev);
        }
    }

    private void addPattern(Pattern p) {
        if (!this.patternSet.contains(p)) {
            this.patternList.add(p);
            this.patternSet.add(p);
        }
    }

    class ElementContentVisitor
    extends BaseVisitor {
        ElementContentVisitor() {
        }

        @Override
        public VoidValue caseElement(ElementPattern p) {
            DefaultValuesExtractor.this.addPattern(p);
            return VoidValue.VOID;
        }
    }

    class ElementsVisitor
    extends BaseVisitor {
        private List<Name> elements;

        ElementsVisitor() {
            this.elements = new ArrayList<Name>();
        }

        @Override
        public VoidValue caseElement(ElementPattern p) {
            this.elements.clear();
            p.getNameClass().accept(this);
            if (this.elements.size() > 0) {
                p.getContent().apply(new AttributesVisitor(this.elements));
            }
            p.getContent().apply(DefaultValuesExtractor.this.ecv);
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
            this.elements.add(name);
        }
    }

    public static interface DefaultValuesListener {
        public void defaultValue(String var1, String var2, String var3, String var4, String var5);
    }

    class AttributesVisitor
    extends BaseVisitor {
        private String defaultValue;
        private List<Name> elements;

        public AttributesVisitor(List<Name> elements) {
            this.elements = elements;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern p) {
            this.defaultValue = p.getDefaultValue();
            if (this.defaultValue != null) {
                p.getNameClass().accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
            for (Name eName : this.elements) {
                DefaultValuesExtractor.this.listener.defaultValue(eName.getLocalName(), eName.getNamespaceUri(), name.getLocalName(), name.getNamespaceUri(), this.defaultValue);
            }
        }
    }

    class BaseVisitor
    implements PatternFunction<VoidValue>,
    NameClassVisitor {
        BaseVisitor() {
        }

        @Override
        public VoidValue caseElement(ElementPattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseError(ErrorPattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseEmpty(EmptyPattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseNotAllowed(NotAllowedPattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseGroup(GroupPattern g) {
            g.getOperand1().apply(this);
            g.getOperand2().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseInterleave(InterleavePattern i) {
            i.getOperand1().apply(this);
            i.getOperand2().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseChoice(ChoicePattern c) {
            c.getOperand1().apply(this);
            c.getOperand2().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOneOrMore(OneOrMorePattern p) {
            p.getOperand().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseData(DataPattern d) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseDataExcept(DataExceptPattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseValue(ValuePattern p) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseText(TextPattern t) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseList(ListPattern l) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseRef(RefPattern p) {
            p.getPattern().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAfter(AfterPattern p) {
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
        }

        @Override
        public void visitChoice(NameClass nc1, NameClass nc2) {
            nc1.accept(this);
            nc2.accept(this);
        }

        @Override
        public void visitNsName(String ns) {
        }

        @Override
        public void visitNsNameExcept(String ns, NameClass nc) {
        }

        @Override
        public void visitAnyName() {
        }

        @Override
        public void visitAnyNameExcept(NameClass nc) {
        }

        @Override
        public void visitNull() {
        }

        @Override
        public void visitError() {
        }
    }
}

