/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class AttributePattern
extends Pattern {
    private final NameClass nameClass;
    private final Pattern p;
    private final Locator loc;
    private final String defaultValue;

    AttributePattern(NameClass nameClass, Pattern value, Locator loc, String defaultValue) {
        super(false, 0, AttributePattern.combineHashCode(29, nameClass.hashCode(), value.hashCode()));
        this.nameClass = nameClass;
        this.p = value;
        this.loc = loc;
        this.defaultValue = defaultValue;
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep = this.p.expand(b);
        if (ep != this.p) {
            return b.makeAttribute(this.nameClass, ep, this.loc, this.defaultValue);
        }
        return this;
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_attribute");
            }
            case 1: {
                if (!this.nameClass.isOpen()) break;
                throw new RestrictionViolationException("open_name_class_not_repeated");
            }
            case 3: {
                throw new RestrictionViolationException("one_or_more_contains_group_contains_attribute");
            }
            case 4: {
                throw new RestrictionViolationException("one_or_more_contains_interleave_contains_attribute");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_attribute");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_attribute");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_attribute");
            }
        }
        dad.addAttribute(this.nameClass);
        try {
            this.p.checkRestrictions(5, null, null);
        }
        catch (RestrictionViolationException e) {
            e.maybeSetLocator(this.loc);
            throw e;
        }
    }

    @Override
    boolean samePattern(Pattern other) {
        if (!(other instanceof AttributePattern)) {
            return false;
        }
        AttributePattern ap = (AttributePattern)other;
        boolean sameDefaults = this.defaultValue == ap.defaultValue ? true : (this.defaultValue != null ? this.defaultValue.equals(ap.defaultValue) : false);
        return this.nameClass.equals(ap.nameClass) && this.p == ap.p && sameDefaults;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth);
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseAttribute(this);
    }

    public Pattern getContent() {
        return this.p;
    }

    public NameClass getNameClass() {
        return this.nameClass;
    }

    public Locator getLocator() {
        return this.loc;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }
}

