/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.player;

import java.awt.Dimension;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.media.player.JFXMediaPlayerIcons;
import ro.sync.jfx.media.player.MediaPlayerPaneUtil;

public abstract class AbstractMediaPlayerPane
extends Pane {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractMediaPlayerPane.class.getName());
    private ImageView mute;
    private ImageView unmute;
    private ImageView play;
    protected ImageView pause;
    protected MediaPlayer mp;
    protected Dimension size;
    private Button playButton;
    private ToggleButton muteButton;
    private Label playTime;
    private Slider volumeSlider;
    protected HBox mediaBottomBar;
    private Duration duration;
    private Slider timeSlider;
    private MediaView mediaView;
    private static final int SECS_IN_MINUTE = 60;
    private static final int SECS_IN_HOUR = 3600;

    public AbstractMediaPlayerPane(MediaPlayer mp, Dimension size) {
        this.mp = mp;
        this.size = size;
        this.initializePlayer();
    }

    protected void initializePlayer() {
        this.mediaView = new MediaView(this.mp);
        this.playButton = new Button();
        this.muteButton = new ToggleButton();
        this.playTime = new Label();
        this.volumeSlider = new Slider();
        this.mediaBottomBar = new HBox();
        this.muteButton = new ToggleButton();
        this.timeSlider = new Slider();
        this.mediaBottomBar.setSpacing(5.0);
        HBox.setHgrow((Node)this.timeSlider, (Priority)Priority.ALWAYS);
        this.mute = new ImageView(JFXMediaPlayerIcons.getImage("/images/Audio_off.png"));
        this.unmute = new ImageView(JFXMediaPlayerIcons.getImage("/images/Audio_on.png"));
        this.play = new ImageView(JFXMediaPlayerIcons.getImage("/images/Play24.png"));
        this.pause = new ImageView(JFXMediaPlayerIcons.getImage("/images/Pause24.png"));
        this.playButton.setStyle("-fx-background-color: transparent;");
        this.muteButton.setStyle("-fx-background-color: transparent;");
        this.playButton.setGraphic((Node)this.play);
        this.muteButton.setGraphic((Node)this.unmute);
        LOGGER.debug("Impose play width {}", (Object)this.play.getImage().getRequestedWidth());
        MediaPlayerPaneUtil.setControlFixedSize((Control)this.playButton, this.play.getImage().getRequestedWidth());
        MediaPlayerPaneUtil.setControlFixedSize((Control)this.muteButton, this.mute.getImage().getRequestedWidth());
        this.playTime.setMinWidth(150.0);
        this.playTime.setPrefWidth(150.0);
        this.playButton.setCursor(Cursor.HAND);
        this.timeSlider.setCursor(Cursor.HAND);
        this.volumeSlider.setCursor(Cursor.HAND);
        this.muteButton.setCursor(Cursor.HAND);
        this.playTime.setTextFill((Paint)Color.WHITE);
        this.mediaBottomBar.setAlignment(Pos.CENTER);
        this.mediaBottomBar.setOpacity(1.0);
        this.mediaBottomBar.getChildren().add((Object)this.playButton);
        this.mediaBottomBar.getChildren().add((Object)this.timeSlider);
        this.mediaBottomBar.getChildren().add((Object)this.playTime);
        this.mediaBottomBar.getChildren().add((Object)this.muteButton);
        this.mediaBottomBar.getChildren().add((Object)this.volumeSlider);
        this.mediaBottomBar.setStyle("-fx-background-color: rgb(0, 0, 0, 0.5);");
        this.getChildren().addAll((Object[])new Node[]{this.mediaView, this.mediaBottomBar});
        this.initActionsAndListeners();
    }

    private void initActionsAndListeners() {
        this.mp.currentTimeProperty().addListener((observable, oldValue, newValue) -> this.updateValues());
        this.mp.setOnReady(() -> {
            this.duration = this.mp.getMedia().getDuration();
            this.mp.setVolume(0.7);
            this.updateValues();
            this.updateSizes();
        });
        this.mp.setOnEndOfMedia(() -> {
            this.mp.seek(Duration.ZERO);
            this.mp.pause();
            this.playButton.setGraphic((Node)this.play);
            this.updateValues();
        });
        this.timeSlider.valueProperty().addListener(ov -> {
            if (this.timeSlider.isValueChanging() || this.timeSlider.isPressed()) {
                if (this.duration != null) {
                    this.mp.seek(this.duration.multiply(this.timeSlider.getValue() / 100.0));
                }
                this.updateValues();
            }
        });
        this.volumeSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.volumeSlider.isValueChanging() || this.volumeSlider.isPressed()) {
                this.mp.setVolume(this.volumeSlider.getValue() / 100.0);
                if (this.muteButton.isSelected()) {
                    this.muteButton.setGraphic((Node)this.unmute);
                    this.muteButton.setSelected(false);
                    this.mp.setMute(false);
                }
            }
        });
        this.playButton.setOnAction(event -> this.togglePlay());
        this.muteButton.setOnAction(event -> {
            boolean isMute = this.muteButton.isSelected();
            this.muteButton.setGraphic((Node)(isMute ? this.mute : this.unmute));
            this.mp.setMute(isMute);
        });
    }

    private void updateValues() {
        if (this.playTime != null && this.timeSlider != null && this.volumeSlider != null && this.duration != null) {
            Platform.runLater(() -> {
                Duration currentTime = this.mp.getCurrentTime();
                this.playTime.setText(AbstractMediaPlayerPane.formatTime(currentTime, this.duration) + "/" + AbstractMediaPlayerPane.formatTime(this.duration, this.duration));
                this.timeSlider.setDisable(this.duration.isUnknown());
                if (!this.timeSlider.isDisabled() && this.duration.greaterThan(Duration.ZERO) && !this.timeSlider.isValueChanging()) {
                    this.timeSlider.setValue(currentTime.divide(this.duration).toMillis() * 100.0);
                }
                if (!this.volumeSlider.isValueChanging()) {
                    this.volumeSlider.setValue((double)((int)Math.round(this.mp.getVolume() * 100.0)));
                }
            });
        }
    }

    protected void updateSizes() {
        this.mediaView.relocate(0.0, 0.0);
        this.mediaView.setFitWidth((double)this.size.width);
        this.mediaView.setFitHeight((double)this.size.height);
        this.mediaBottomBar.setPrefWidth((double)this.size.width);
        int volumeSliderWidth = 23;
        this.volumeSlider.setMinWidth((double)volumeSliderWidth);
        LOGGER.debug("time slider width: {}", (Object)this.timeSlider.getWidth());
        LOGGER.debug("time slider height: {}", (Object)this.timeSlider.getHeight());
        LOGGER.debug("vol slider width: {}", (Object)this.volumeSlider.getWidth());
        LOGGER.debug("vol slider height: {}", (Object)this.volumeSlider.getHeight());
    }

    private static String formatTime(Duration elapsed, Duration duration) {
        Object[] values;
        String format;
        int intElapsed = (int)Math.floor(elapsed.toSeconds());
        int elapsedHours = (int)Math.floor(elapsed.toHours());
        if (elapsedHours > 0) {
            intElapsed -= elapsedHours * 3600;
        }
        int elapsedMinutes = intElapsed / 60;
        int elapsedSeconds = intElapsed % 60;
        if (duration.greaterThan(Duration.ZERO)) {
            int intDuration = (int)Math.floor(duration.toSeconds());
            int durationHours = (int)Math.floor(duration.toHours());
            if (durationHours > 0) {
                intDuration -= durationHours * 3600;
            }
            if (durationHours > 0) {
                format = "%d:%02d:%02d";
                values = new Integer[]{elapsedHours, elapsedMinutes, elapsedSeconds};
            } else {
                format = "%02d:%02d";
                values = new Integer[]{elapsedMinutes, elapsedSeconds};
            }
        } else if (elapsedHours > 0) {
            format = "%d:%02d:%02d";
            values = new Integer[]{elapsedHours, elapsedMinutes, elapsedSeconds};
        } else {
            format = "%02d:%02d";
            values = new Integer[]{elapsedMinutes, elapsedSeconds};
        }
        return String.format(format, values);
    }

    public void togglePlay() {
        if (this.mp.getStatus().compareTo((Enum)MediaPlayer.Status.READY) == 0 || this.mp.getStatus().compareTo((Enum)MediaPlayer.Status.PAUSED) == 0) {
            this.mp.play();
            this.playButton.setGraphic((Node)this.pause);
        } else if (this.mp.getStatus().compareTo((Enum)MediaPlayer.Status.PLAYING) == 0) {
            this.mp.pause();
            this.playButton.setGraphic((Node)this.play);
        }
    }
}

