/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.player;

import java.awt.Dimension;
import java.net.URL;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import ro.sync.jfx.media.player.AbstractMediaPlayerPane;

public abstract class AbstractMediaPlayer {
    protected Media media;
    protected MediaPlayer mediaPlayer;

    protected AbstractMediaPlayer(URL toPlayURL, Dimension size) {
        this.media = new Media(toPlayURL.toExternalForm());
        this.mediaPlayer = new MediaPlayer(this.media);
        this.mediaPlayer.setAutoPlay(false);
    }

    public void play() {
        MediaPlayer.Status status = this.mediaPlayer.getStatus();
        if (status == MediaPlayer.Status.UNKNOWN || status == MediaPlayer.Status.HALTED) {
            return;
        }
        if (status == MediaPlayer.Status.PAUSED || status == MediaPlayer.Status.STOPPED || status == MediaPlayer.Status.READY) {
            this.mediaPlayer.play();
        }
    }

    public void stop() {
        this.mediaPlayer.stop();
    }

    public void pause() {
        MediaPlayer.Status status = this.mediaPlayer.getStatus();
        if (status == MediaPlayer.Status.PLAYING) {
            this.getPlayerView().togglePlay();
        }
    }

    public void dispose() {
        this.mediaPlayer.setOnReady(null);
        this.mediaPlayer.setOnEndOfMedia(null);
        this.mediaPlayer.setOnError(null);
        this.mediaPlayer.dispose();
    }

    public MediaPlayer getMediaPlayerForTests() {
        return this.mediaPlayer;
    }

    public abstract AbstractMediaPlayerPane getPlayerView();
}

