/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.browser;

import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.web.WebEngine;

public class WebEngineStateTracker {
    private static final int DEFAULT_HEIGHT = 80;
    private static final int DEFAULT_WIDTH = 80;
    private static final int PAGE_LOADING_TIME = 200;
    private final WebEngine engine;
    private final ProgressIndicator indicator;
    private Timer timer;
    private TimerTask progressPresentTask;
    private StateTrackerListener listener;

    private static ProgressIndicator createProgressIndicator() {
        double scaledWidth = 80.0;
        double scaledHeight = 80.0;
        ProgressIndicator pi = new ProgressIndicator();
        pi.setPrefSize(scaledWidth, scaledHeight);
        pi.setMaxWidth(scaledWidth);
        pi.setMaxHeight(scaledHeight);
        return pi;
    }

    WebEngineStateTracker(WebEngine engine) {
        this.engine = engine;
        this.indicator = WebEngineStateTracker.createProgressIndicator();
        this.indicator.setVisible(false);
    }

    public ProgressIndicator getIndicator() {
        return this.indicator;
    }

    void start() {
        this.progressPresentTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    if (WebEngineStateTracker.this.engine.getLoadWorker().getState() != Worker.State.SUCCEEDED) {
                        WebEngineStateTracker.this.indicator.setVisible(true);
                    }
                });
            }
        };
        if (this.timer == null) {
            this.timer = new Timer(false);
        }
        this.timer.schedule(this.progressPresentTask, 200L);
    }

    void stop() {
        if (this.progressPresentTask != null) {
            this.progressPresentTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.listener != null) {
            this.listener.stopped();
        }
    }

    public void setStateTrackerListener(StateTrackerListener listener) {
        this.listener = listener;
    }

    static interface StateTrackerListener {
        public void stopped();
    }
}

