/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.browser;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.media.browser.BrowserEventHandler;
import ro.sync.jfx.media.browser.HyperlinkCallback;
import ro.sync.jfx.media.browser.JfxWebEngine;
import ro.sync.jfx.media.browser.WebEngineStateTracker;

class BrowserPanelChangeListener
implements ChangeListener<Worker.State> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BrowserPanelChangeListener.class.getName());
    private final WebView view;
    private final BrowserEventHandler handler;
    private final HyperlinkCallback hyperlinkCallback;
    private final JFXPanel parentPanel;
    private final WebEngineStateTracker webEngineStateTracker;
    private final ScrollInfo scrollInfo = new ScrollInfo();
    private static final String HREF_SCRIPT_TEMPLATE = "document.addEventListener(\"click\", function (e) {\n    var currentTag = null;\n    var isLink = false;\n    var currentElement = e.target;\n    while (currentElement) {\n        currentTag = currentElement.tagName;\n        if (currentTag == '<HREF_TAG>') {\n            isLink = true;\n            break;\n        }\n        currentElement = currentElement.parentNode;\n    }\n    if (isLink) {\n        var hr = currentElement.<HREF_ATTR>;\n        var index = hr.indexOf(\"#\");\n        /*nu am link cu # */\n        if(index === -1){\n             hyperlinkCallback.hyperlink(hr); \n             e.preventDefault();\n             e.stopPropagation();\n        } else {\n            /* Aici am un #, daca e la sfarsitul link-ului */\n            /* daca e #scroll-to, permite-l */\n            /* Daca e #blank_space, deschide in system app */\n            /* Daca e #/ sa fac remove slashes  */\n            /*  Scapa de # */\n            index += 1;\n            /* sa vedem ancora */\n            var anc = hr.substr(index);\n            var ancLen = anc.trim().length;\n            /* am ancora */\n            if(ancLen > 0){\n            /* Si ancora are slash-uri in ea in ea */\n                /* Pot sa pun slash ca sa ocolesc scriptul */\n                if(anc.indexOf(\"/\") !== -1){\n                    /* Scap de slash-uri */\n                    anc = anc.replace(/\\/+$/, \"\");\n                    anc = anc.replace(/%20/g, \"\");\n                    anc = anc.replace(\" \", \"\");\n                    /* Daca slash-ul era pus \"de forma\" */\n                    if(anc.trim().length === 0){\n                    /* System app scrie pe tine */\n                        hyperlinkCallback.hyperlink(hr);\n                        e.preventDefault();\n                        e.stopPropagation();\n                    }\n                }\n            } else {\n                hyperlinkCallback.hyperlink(hr); e.preventDefault(); e.stopPropagation(); \n            }\n        }\n    }\n},\ntrue);";
    private static final Pattern HREF_TAG_PATTERN = Pattern.compile("<HREF_TAG>");
    private static final Pattern HREF_ATTR_PATTERN = Pattern.compile("<HREF_ATTR>");

    private static ScrollBar getVScrollBar(WebView webView) {
        for (Node scrollNode : webView.lookupAll(".scroll-bar")) {
            ScrollBar scroll;
            if (!ScrollBar.class.isInstance(scrollNode) || (scroll = (ScrollBar)scrollNode).getOrientation() != Orientation.VERTICAL) continue;
            return scroll;
        }
        return null;
    }

    BrowserPanelChangeListener(WebView view, BrowserEventHandler handler, JFXPanel parentPanel, WebEngineStateTracker webEngineStateTracker) {
        this.view = view;
        this.handler = handler;
        this.hyperlinkCallback = new HyperlinkCallback(handler);
        this.parentPanel = parentPanel;
        this.webEngineStateTracker = webEngineStateTracker;
    }

    private void forwardScrollEventToParent(MouseWheelEvent e) {
        Boolean shouldScroll;
        ScrollBar vScrollBar = BrowserPanelChangeListener.getVScrollBar(this.view);
        if (vScrollBar != null && (shouldScroll = this.scrollInfo.shouldScroll(vScrollBar.getValue())) != null) {
            SwingUtilities.invokeLater(() -> {
                Container parent = SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)this.parentPanel);
                if (parent != null) {
                    parent.dispatchEvent(SwingUtilities.convertMouseEvent((Component)this.parentPanel, e, parent));
                }
            });
        }
    }

    public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
        WebEngine engine = this.view.getEngine();
        if (newState == Worker.State.SCHEDULED) {
            this.handler.pageAboutToLoad(new JfxWebEngine(engine));
        } else if (newState == Worker.State.SUCCEEDED) {
            this.handler.pageLoaded(new JfxWebEngine(engine));
            this.webEngineStateTracker.stop();
            this.parentPanel.addMouseWheelListener(e -> {
                if (!e.isConsumed()) {
                    this.forwardScrollEventToParent(e);
                }
            });
            if (engine.getLocation() != null) {
                engine.setOnError(event -> this.handler.error(event.getMessage(), event.getException()));
                engine.setOnAlert(event -> this.handler.alert((String)event.getData()));
                JSObject window = (JSObject)engine.executeScript("window");
                try {
                    window.setMember("hyperlinkCallback", this.hyperlinkCallback);
                    window.eval(BrowserPanelChangeListener.getScriptForHrefs(engine.getLocation().toLowerCase().endsWith(".svg")));
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                    engine.getLoadWorker().cancel();
                    engine.load(engine.getLocation());
                }
            }
        }
    }

    private static String getScriptForHrefs(boolean isSVG) {
        String hrefTag = "A";
        String hrefAttr = "href";
        if (isSVG) {
            hrefTag = "a";
            hrefAttr = "getAttribute(\"xlink:href\")";
        }
        String replacedHrefTag = HREF_TAG_PATTERN.matcher(HREF_SCRIPT_TEMPLATE).replaceAll(hrefTag);
        return HREF_ATTR_PATTERN.matcher(replacedHrefTag).replaceAll(hrefAttr);
    }

    private static class ScrollInfo {
        private boolean up;
        private double lastPosition;

        private ScrollInfo() {
        }

        private Boolean shouldScroll(double value) {
            if (this.lastPosition == value) {
                return this.up;
            }
            this.up = this.lastPosition - value > 0.0;
            this.lastPosition = value;
            return null;
        }
    }
}

