/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.componentinfo.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Optional;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import ro.sync.exml.componentinfo.help.HelpPresenter;
import ro.sync.exml.componentinfo.help.HelpURLProvider;
import ro.sync.net.InternetConnectionChecker;
import ro.sync.net.OpenProxyHandler;

public class JFXHelpPresenter
extends JPanel
implements HelpPresenter,
OpenProxyHandler {
    public static final String OXYGEN_DYNAMIC_HELP_USER_AGENT = "oxygen_dynamic_help_user_agent";
    private WebView jfxBrowser;
    private final OpenProxyHandler handler;
    private String pageId;
    private boolean created;
    private String pageIdToLoadAfterCreation;
    private final String unableToConnect;
    private final String noNetwork;
    private final String proxySettings;
    private final float scaleFactor;
    private final InternetConnectionChecker internetConnectionChecker;
    private final HelpURLProvider urlProvider;

    public JFXHelpPresenter(HelpURLProvider urlProvider, InternetConnectionChecker internetConnectionChecker, OpenProxyHandler handler, String unableToConnect, String noNetwork, String proxySettings, float scaleFactor) {
        super(new BorderLayout());
        this.urlProvider = urlProvider;
        this.internetConnectionChecker = internetConnectionChecker;
        this.handler = handler;
        this.unableToConnect = unableToConnect;
        this.noNetwork = noNetwork;
        this.proxySettings = proxySettings;
        this.scaleFactor = scaleFactor;
    }

    private void createScene() {
        JFXPanel jfxPanel = new JFXPanel();
        this.add((Component)jfxPanel, "Center");
        Platform.runLater(() -> {
            Platform.setImplicitExit((boolean)false);
            this.jfxBrowser = new WebView();
            this.jfxBrowser.getEngine().setUserAgent(OXYGEN_DYNAMIC_HELP_USER_AGENT);
            jfxPanel.setScene(new Scene((Parent)this.jfxBrowser));
            this.created = true;
            this.setCurrentPageID(this.pageIdToLoadAfterCreation);
            this.jfxBrowser.setFontScale((double)this.scaleFactor);
        });
    }

    @Override
    public void setCurrentPageID(String pageId) {
        if (pageId != null) {
            if (!this.created) {
                this.pageIdToLoadAfterCreation = pageId;
                this.createScene();
            } else {
                String fullPath = this.urlProvider.getURL(pageId);
                Platform.runLater(() -> {
                    if (this.internetConnectionChecker.isEthernetReachable()) {
                        this.jfxBrowser.getEngine().load(fullPath);
                        this.pageIdToLoadAfterCreation = null;
                    } else {
                        StringBuilder htmlMessage = new StringBuilder(108).append("<html><body>").append(MessageFormat.format(this.unableToConnect, "<br> <a href=" + fullPath + ">" + fullPath)).append("</a><br><br>").append(this.noNetwork).append("<a id=\"openProxySettings\" href=\"#\" onclick=\"openProxyHandler.open()\">").append("<br/><br/><u>").append(this.proxySettings).append("</u></a></body></html>");
                        this.jfxBrowser.getEngine().loadContent(htmlMessage.toString());
                        this.jfxBrowser.getEngine().getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
                            if (newState == Worker.State.SUCCEEDED) {
                                JSObject window = (JSObject)this.jfxBrowser.getEngine().executeScript("window");
                                window.setMember("openProxyHandler", this);
                            }
                        });
                    }
                });
            }
        }
    }

    @Override
    public void open() {
        Optional.ofNullable(this.handler).ifPresent(t -> t.open());
    }

    @Override
    public String getCurrentPageID() {
        return this.pageId;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public WebView getFXBrowserForTests() {
        return this.jfxBrowser;
    }
}

