/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.simpletable.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.ShowTablePropertiesBaseOperation;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelper;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.properties.SimpleTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class SimpleTableShowPropertiesOperationBase
extends ShowTablePropertiesBaseOperation {
    private static final String FRAME_DITA_CONREF = "-dita-use-conref-target";
    private static final String[] TABLE_FRAME_VALUES = new String[]{"none", "all", "top", "topbot", "bottom", "sides", "-dita-use-conref-target"};

    public SimpleTableShowPropertiesOperationBase(TablePropertiesHelper helper) {
        super(helper);
    }

    @Override
    protected List<TabInfo> getCategoriesAndProperties(List<Integer[]> selections) {
        TabInfo rowsTabInformation;
        ArrayList<TabInfo> categories = new ArrayList<TabInfo>();
        TabInfo tableTabInformation = this.getTableInformation(selections);
        if (tableTabInformation != null) {
            categories.add(tableTabInformation);
        }
        if ((rowsTabInformation = this.getRowsTabInformation(selections)) != null) {
            categories.add(rowsTabInformation);
        }
        return categories;
    }

    private TabInfo getRowsTabInformation(List<Integer[]> selections) {
        SimpleTableHelper simpleTableHelper = (SimpleTableHelper)this.tableHelper;
        TabInfo tabInfo = null;
        ArrayList<TableProperty> rowsProperties = new ArrayList<TableProperty>();
        List<AuthorElement> collectedRows = TableOperationsUtil.getTableElementsOfType(this.authorAccess, selections, 0, this.tableHelper);
        if (collectedRows.size() == 1) {
            AuthorElement rowElement = collectedRows.get(0);
            String currentType = null;
            if (simpleTableHelper.isBodyRow(rowElement)) {
                currentType = "Body";
            } else if (simpleTableHelper.isHeaderRow(rowElement)) {
                currentType = "Header";
            }
            boolean canMoveToHeader = true;
            if ("Body".equals(currentType)) {
                AuthorElement tableHead = this.tableHelper.getFirstChildOfTypeFromParentWithType(rowElement, 2, 5);
                boolean bl = canMoveToHeader = tableHead == null;
            }
            if (canMoveToHeader) {
                ArrayList<String> attrValues = new ArrayList<String>();
                attrValues.add("Header");
                attrValues.add("Body");
                HashMap<String, String> icons = new HashMap<String, String>();
                icons.put("Header", "/images/table-properties/RowTypeHeader.png");
                icons.put("Body", "/images/table-properties/RowTypeBody.png");
                rowsProperties.add(new TableProperty("rowType", "Row_type", attrValues, currentType, "Row_type", GuiElements.RADIO_BUTTONS, icons, false, true));
                tabInfo = new TabInfo(collectedRows.size() > 1 ? "Rows" : "Row", rowsProperties, collectedRows);
                tabInfo.setContextInfo(MessageFormat.format(this.authorAccess.getAuthorResourceBundle().getMessage("Affected_rows"), collectedRows.size()));
            }
        }
        return tabInfo;
    }

    @Override
    protected boolean computeFragmentsToMoveInsideFooter(List<AuthorDocumentFragment> fragments, List<Position> offsets, TabInfo tabInfo, List<AuthorElement> nodesToModify, AuthorElement currentNode) throws AuthorOperationException {
        return false;
    }

    @Override
    protected boolean computeFragmentMoveInsideHeader(List<AuthorDocumentFragment> fragments, List<Position> offsets, TabInfo tabInfo, List<AuthorElement> nodesToModify, AuthorElement currentNode) throws AuthorOperationException {
        int offset = -1;
        if (!this.tableHelper.isTableHead(currentNode)) {
            try {
                AuthorElement tableElem = TableOperationsUtil.getElementAncestor((AuthorNode)currentNode, 5, this.tableHelper);
                this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(2), (AuthorNode)tableElem, "Inside as first child");
                AuthorElement tableHead = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 2, 5);
                List contentNodes = currentNode.getContentNodes();
                if (tableHead != null) {
                    offset = tableHead.getStartOffset() + 1;
                    for (int i = 0; i < contentNodes.size(); ++i) {
                        AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                        Position pos = this.authorAccess.getDocumentController().createPositionInContent(offset);
                        offsets.add(pos);
                        fragments.add(this.authorAccess.getDocumentController().createDocumentFragment(authorNode, true));
                    }
                    if (!nodesToModify.contains(currentNode)) {
                        nodesToModify.add(currentNode);
                    }
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    protected boolean computeFragmentsToMoveInsideBody(List<AuthorDocumentFragment> fragments, List<Position> offsets, TabInfo tabInfo, List<AuthorElement> nodesToModify, AuthorElement currentNode) throws AuthorOperationException {
        int offset = -1;
        if (!this.tableHelper.isTableBody(currentNode)) {
            try {
                AuthorElement elementAncestor = TableOperationsUtil.getElementAncestor((AuthorNode)currentNode, 5, this.tableHelper);
                AuthorElement headerElem = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 2, 5);
                if (headerElem == null) {
                    this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(1), (AuthorNode)elementAncestor, "Inside as first child");
                } else {
                    this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(1), headerElem.getEndOffset() + 1);
                }
                AuthorElement tableBody = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 1, 5);
                if (tableBody != null) {
                    offset = tableBody.getStartOffset() + 1;
                }
                if (offset != -1) {
                    List contentNodes = currentNode.getContentNodes();
                    for (int i = 0; i < contentNodes.size(); ++i) {
                        AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                        Position pos = this.authorAccess.getDocumentController().createPositionInContent(offset);
                        offsets.add(pos);
                        fragments.add(this.authorAccess.getDocumentController().createDocumentFragment(authorNode, true));
                    }
                    if (!nodesToModify.contains(currentNode)) {
                        nodesToModify.add(currentNode);
                    }
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    protected List<TableProperty> getTableAttribute() {
        ArrayList<TableProperty> attributes = new ArrayList<TableProperty>();
        HashMap<String, String> frameIcons = new HashMap<String, String>();
        frameIcons.put("none", "/images/table-properties/EmptyIcon.png");
        frameIcons.put("all", "/images/table-properties/FrameAll.png");
        frameIcons.put("top", "/images/table-properties/FrameTop.png");
        frameIcons.put("topbot", "/images/table-properties/FrameTopbot.png");
        frameIcons.put("bottom", "/images/table-properties/FrameBottom.png");
        frameIcons.put("sides", "/images/table-properties/FrameSides.png");
        frameIcons.put(FRAME_DITA_CONREF, "/images/table-properties/EmptyIcon.png");
        attributes.add(new TableProperty("frame", "Frame", Arrays.asList(TABLE_FRAME_VALUES), null, "Frame", GuiElements.COMBOBOX, frameIcons, true, true));
        return attributes;
    }

    @Override
    protected String getHelpPageID() {
        return "dita-table-properties";
    }
}

