/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.cals.properties;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelperBase;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITACALSTableHelper
extends TablePropertiesHelperBase {
    private static final String ENTRY = "entry";
    private static final String ROW = "row";
    private static final String THEAD = "thead";
    private static final String TBODY = "tbody";
    private static final String ATTRIBUTE_CLASS = "class";

    @Override
    public boolean isTable(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && (classAttr.getValue().contains(" topic/table ") || classAttr.getValue().contains(" topic/tgroup "));
    }

    @Override
    public boolean isTableBody(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/tbody ");
    }

    @Override
    public boolean isTableCell(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/entry ");
    }

    @Override
    public boolean isTableGroup(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/tgroup ");
    }

    @Override
    public boolean isTableHead(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/thead ");
    }

    @Override
    public boolean isTableRow(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/row ");
    }

    @Override
    public boolean isTableColspec(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" topic/colspec ");
    }

    @Override
    public String getElementTag(int elementType) {
        return "<" + this.getElementName(elementType) + "/>";
    }

    @Override
    public String getElementName(int elementType) {
        String elementName = "";
        switch (elementType) {
            case 1: {
                elementName = TBODY;
                break;
            }
            case 2: {
                elementName = THEAD;
                break;
            }
            case 0: {
                elementName = ROW;
                break;
            }
            case 6: {
                elementName = ENTRY;
                break;
            }
        }
        return elementName;
    }
}

