/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.cals.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.properties.CALSShowTableProperties;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.ecss.extensions.dita.topic.table.cals.properties.DITACALSTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
@WebappRestSafe
public class DITACALSShowTablePropertiesOperation
extends CALSShowTableProperties {
    public static final String FRAME_DITA_CONREF = "-dita-use-conref-target";
    private static final String[] TABLE_FRAME_VALUES = new String[]{"none", "all", "top", "topbot", "bottom", "sides", "-dita-use-conref-target"};

    public DITACALSShowTablePropertiesOperation() {
        super(new DITACALSTableHelper());
    }

    @Override
    protected List<TableProperty> getTableAttribute() {
        ArrayList<TableProperty> attrs = new ArrayList<TableProperty>();
        ArrayList<String> newValues = new ArrayList<String>();
        newValues.addAll(Arrays.asList(HORIZONTAL_ALIGN_VALUES));
        newValues.add(FRAME_DITA_CONREF);
        attrs.add(new TableProperty("align", "Horizontal_alignment", newValues, null, "Horizontal_alignment", GuiElements.RADIO_BUTTONS, null, true, true));
        attrs.add(new TableProperty("colsep", "Column_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        attrs.add(new TableProperty("rowsep", "Row_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        HashMap<String, String> frameIcons = new HashMap<String, String>();
        frameIcons.put("none", "/images/table-properties/EmptyIcon.png");
        frameIcons.put("all", "/images/table-properties/FrameAll.png");
        frameIcons.put("top", "/images/table-properties/FrameTop.png");
        frameIcons.put("topbot", "/images/table-properties/FrameTopbot.png");
        frameIcons.put("bottom", "/images/table-properties/FrameBottom.png");
        frameIcons.put("sides", "/images/table-properties/FrameSides.png");
        frameIcons.put(FRAME_DITA_CONREF, "/images/table-properties/EmptyIcon.png");
        attrs.add(new TableProperty("frame", "Frame", Arrays.asList(TABLE_FRAME_VALUES), null, "Frame", GuiElements.COMBOBOX, frameIcons, true, true));
        return attrs;
    }

    @Override
    protected List<TableProperty> getRowsAttributesToEdit() {
        List<TableProperty> rowsAttributesToEdit = super.getRowsAttributesToEdit();
        for (int i = 0; i < rowsAttributesToEdit.size(); ++i) {
            TableProperty tableProperty = rowsAttributesToEdit.get(i);
            if (!"valign".equals(tableProperty.getAttributeName())) continue;
            ArrayList<String> newValues = new ArrayList<String>();
            newValues.addAll(tableProperty.getValues());
            newValues.add(FRAME_DITA_CONREF);
            tableProperty.setValues(newValues);
            break;
        }
        return rowsAttributesToEdit;
    }

    @Override
    protected List<TableProperty> getCellsAttributes() {
        List<TableProperty> cellsAttributes = super.getCellsAttributes();
        for (int i = 0; i < cellsAttributes.size(); ++i) {
            TableProperty tableProperty = cellsAttributes.get(i);
            if (!"valign".equals(tableProperty.getAttributeName()) && !"align".equals(tableProperty.getAttributeName())) continue;
            ArrayList<String> newValues = new ArrayList<String>();
            newValues.addAll(tableProperty.getValues());
            newValues.add(FRAME_DITA_CONREF);
            tableProperty.setValues(newValues);
        }
        return cellsAttributes;
    }

    @Override
    protected List<TableProperty> getColumnsAttributes() {
        List<TableProperty> columnsAttributes = super.getColumnsAttributes();
        for (int i = 0; i < columnsAttributes.size(); ++i) {
            TableProperty tableProperty = columnsAttributes.get(i);
            if (!"align".equals(tableProperty.getAttributeName())) continue;
            ArrayList<String> newValues = new ArrayList<String>();
            newValues.addAll(tableProperty.getValues());
            newValues.add(FRAME_DITA_CONREF);
            tableProperty.setValues(newValues);
            break;
        }
        return columnsAttributes;
    }

    @Override
    protected String getHelpPageID() {
        return "dita-table-properties";
    }
}

