/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.MediaInfo;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.commons.ObjectChooser;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertMediaOperation
implements AuthorOperation {
    public static final String ARGUMENT_MEDIA_URL = "data";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("data", 0, "The URL of the media. If not defined, a file chooser will be shown.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object mediaURL = args.getArgumentValue(ARGUMENT_MEDIA_URL);
        MediaInfo ref = null;
        if (mediaURL instanceof String && ((String)mediaURL).trim().length() > 0) {
            ref = new MediaInfo("href", ObjectChooser.makeUrlRelative(authorAccess, (String)mediaURL));
            String fileName = URLUtil.extractFileName((String)mediaURL.toString());
            String extension = fileName != null ? URLUtil.getExtension((String)fileName) : null;
            String outputclass = "iframe";
            if (extension != null) {
                if ("mp3".equals(extension = extension.toLowerCase()) || "wav".equals(extension) || "aiff".equals(extension)) {
                    outputclass = "audio";
                } else if ("mp4".equals(extension) || "flv".equals(extension)) {
                    outputclass = "video";
                }
            }
            ref.getProperties().put("mediaType", outputclass);
        } else {
            ref = DITAAccess.chooseMediaReference((AuthorAccess)authorAccess);
        }
        if (ref != null) {
            DITAAccess.insertMedia((AuthorAccess)authorAccess, (MediaInfo)ref);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a DITA media file";
    }
}

