/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic;

import java.net.URL;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorWorkspaceAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.dita.id.DITAUniqueAttributesRecognizerUtil;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class CreateNewTopicFromSelectionOperation
implements AuthorOperation {
    public String getDescription() {
        return "Create a new topic using the selected content.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        if (!authorAccess.getEditorAccess().hasSelection()) {
            String message = authorAccess.getAuthorResourceBundle().getMessage("No_content_selected_in_editor");
            throw new AuthorOperationException(message);
        }
        int selectionStart = authorAccess.getEditorAccess().getBalancedSelectionStart();
        int selectionEnd = authorAccess.getEditorAccess().getBalancedSelectionEnd();
        try {
            AuthorDocumentController currentDocumentController = authorAccess.getDocumentController();
            DocContent docContent = this.extractNewDocContent(currentDocumentController, selectionStart, selectionEnd);
            URL newTopicUrl = DITAAccess.showNewFileDialog((AuthorAccess)authorAccess, (String)docContent.title);
            AuthorWorkspaceAccess workspaceAccess = authorAccess.getWorkspaceAccess();
            if (newTopicUrl != null) {
                AuthorDocumentFragment otherSectionContent = docContent.extractedContent;
                DITAUniqueAttributesRecognizerUtil.correctFragmentReferences(otherSectionContent, authorAccess.getEditorAccess().getEditorLocation(), newTopicUrl);
                WSAuthorEditorPage authorPage = CreateNewTopicFromSelectionOperation.openAndGetAuthorPage(workspaceAccess, newTopicUrl);
                if (otherSectionContent != null) {
                    this.insertInTopicBody(authorPage.getAuthorAccess().getDocumentController(), otherSectionContent);
                }
                currentDocumentController.delete(selectionStart, selectionEnd);
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
    }

    private DocContent extractNewDocContent(AuthorDocumentController sourceCtrl, int selectionStart, int selectionEnd) throws BadLocationException {
        AuthorNode authorNode;
        boolean isSection = false;
        boolean isTopic = false;
        AuthorDocumentFragment fragmentFromSelection = sourceCtrl.createDocumentFragment(selectionStart, selectionEnd - 1);
        List contentNodes = fragmentFromSelection.getContentNodes();
        if (contentNodes.size() == 1 && (authorNode = (AuthorNode)contentNodes.get(0)) instanceof AuthorElement) {
            AuthorElement authorElement = (AuthorElement)authorNode;
            String clazz = CreateNewTopicFromSelectionOperation.getAttribute(authorElement, "class");
            isTopic = clazz != null && clazz.contains(" topic/topic ");
            isSection = clazz != null && clazz.contains(" topic/section ");
        }
        String title = null;
        AuthorDocumentFragment otherContent = null;
        if (isTopic || isSection) {
            AuthorNode sectionNode = sourceCtrl.getNodeAtOffset(selectionStart + 1);
            if (sectionNode instanceof AuthorElement) {
                AuthorElement sectionEl = (AuthorElement)sectionNode;
                AuthorNode firstChildOfSection = (AuthorNode)sectionEl.getContentNodes().get(0);
                if (CreateNewTopicFromSelectionOperation.isTitle(firstChildOfSection) && firstChildOfSection.getStartOffset() + 1 < firstChildOfSection.getEndOffset()) {
                    int endOffset;
                    title = firstChildOfSection.getTextContent();
                    int startOffset = firstChildOfSection.getEndOffset() + 1;
                    if (startOffset < (endOffset = sectionNode.getEndOffset() - 1)) {
                        otherContent = sourceCtrl.createDocumentFragment(startOffset, endOffset);
                    }
                } else {
                    otherContent = sourceCtrl.createDocumentFragment(sectionNode.getStartOffset() + 1, sectionNode.getEndOffset() - 1);
                }
            }
        } else {
            otherContent = fragmentFromSelection;
        }
        return new DocContent(title, otherContent);
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    private static boolean isTitle(AuthorNode node) {
        if (node instanceof AuthorElement) {
            AuthorElement authorElement = (AuthorElement)node;
            String clazz = CreateNewTopicFromSelectionOperation.getAttribute(authorElement, "class");
            return clazz != null && clazz.contains(" topic/title ");
        }
        return false;
    }

    private static WSAuthorEditorPage openAndGetAuthorPage(AuthorWorkspaceAccess workspaceAccess, URL toOpen) {
        workspaceAccess.open(toOpen, "Author");
        WSEditor editorAccess = workspaceAccess.getEditorAccess(toOpen);
        WSEditorPage currentPage = editorAccess.getCurrentPage();
        if (currentPage instanceof WSAuthorEditorPage) {
            return (WSAuthorEditorPage)currentPage;
        }
        return null;
    }

    private void insertInTopicBody(AuthorDocumentController controller, AuthorDocumentFragment fragmentToInsert) throws AuthorOperationException {
        int insertOffset = -1;
        AuthorNode[] nodes = controller.findNodesByXPath("//*[contains(@class, ' topic/body ')][1]", true, true, true);
        if (nodes.length > 0) {
            int endOffset;
            AuthorNode body = nodes[0];
            int startOffset = body.getStartOffset();
            if (startOffset + 1 < (endOffset = body.getEndOffset())) {
                controller.delete(startOffset + 1, endOffset - 1);
            }
            insertOffset = startOffset + 1;
        } else {
            insertOffset = controller.getAuthorDocumentNode().getRootElement().getStartOffset() + 1;
        }
        controller.insertFragmentSchemaAware(insertOffset, fragmentToInsert);
    }

    private static String getAttribute(AuthorElement element, String attrName) {
        String value = null;
        AttrValue attrValue = element.getAttribute(attrName);
        if (attrValue != null) {
            value = attrValue.getValue();
        }
        return value;
    }

    private static class DocContent {
        private final String title;
        private final AuthorDocumentFragment extractedContent;

        public DocContent(String title, AuthorDocumentFragment extractedContent) {
            this.title = title;
            this.extractedContent = extractedContent;
        }

        public String toString() {
            return String.format("DocContent [title=%s, otherContent=%s]", this.title, this.extractedContent);
        }
    }
}

