/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.search;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ShowKeyDefinitionOperation
implements AuthorOperation {
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        try {
            List nodesToSelect;
            AttrValue keyAttr = null;
            AuthorNode currentNode = null;
            int selectionStart = authorAccess.getEditorAccess().getSelectionStart();
            int selectionEnd = authorAccess.getEditorAccess().getSelectionEnd();
            if (selectionStart != selectionEnd && (nodesToSelect = authorAccess.getDocumentController().getNodesToSelect(selectionStart, selectionEnd)) != null && !nodesToSelect.isEmpty()) {
                currentNode = (AuthorNode)nodesToSelect.get(0);
            }
            if (currentNode == null) {
                currentNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            }
            while (currentNode != null) {
                if (currentNode instanceof AuthorElement) {
                    AttrValue attribute = ((AuthorElement)currentNode).getAttribute("conkeyref");
                    if (attribute != null) {
                        keyAttr = attribute;
                    } else {
                        attribute = ((AuthorElement)currentNode).getAttribute("keyref");
                        if (attribute != null) {
                            keyAttr = attribute;
                        }
                    }
                    if (keyAttr != null) break;
                }
                currentNode = currentNode.getParent();
            }
            if (keyAttr != null && !"".equals(keyAttr.getValue())) {
                ShowKeyDefinitionOperation.showKeyDefinition(authorAccess, keyAttr.getValue(), currentNode);
            }
        }
        catch (Exception e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
    }

    private static void showKeyDefinition(AuthorAccess authorAccess, String keyName, AuthorNode node) {
        LinkedHashMap keys;
        int slashIndex = keyName.indexOf(47);
        if (slashIndex != -1) {
            keyName = keyName.substring(0, slashIndex);
        }
        if ((keys = DITAAccess.getKeys((URL)authorAccess.getEditorAccess().getEditorLocation())) != null) {
            URL definitionLocation;
            KeyInfo keyInfo;
            String rewrittenKeyref;
            if (!keys.containsKey(keyName) && node != null && (rewrittenKeyref = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)authorAccess.getEditorAccess().getEditorLocation(), (ContextKeyManager)ContextKeyManager.getDefault()), (LinkedHashMap)keys, (AuthorNode)node, (String)keyName)) != null && (slashIndex = (keyName = rewrittenKeyref).indexOf(47)) != -1) {
                keyName = keyName.substring(0, slashIndex);
            }
            if ((keyInfo = (KeyInfo)keys.get(keyName)) != null && (definitionLocation = keyInfo.getDefinitionLocation()) != null) {
                authorAccess.getWorkspaceAccess().open(definitionLocation, "Text");
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Shows the definition of the key used on the current element.";
    }
}

