/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
class TopicrefInsertionPositionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TopicrefInsertionPositionResolver.class.getName());
    private AuthorAccess authorAccess;

    public TopicrefInsertionPositionResolver(AuthorAccess authorAccess) {
        this.authorAccess = authorAccess;
    }

    public void moveCaretToPosition(String insertionLocation) {
        int caretOffset = this.authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode currentNode = this.authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if ("Before".equals(insertionLocation)) {
                caretOffset = currentNode.getStartOffset();
            } else if ("Inside as first child".equals(insertionLocation)) {
                caretOffset = this.getFirstPositionInNodeWhereTopicrefCanBeInserted(currentNode);
            } else if ("Inside as last child".equals(insertionLocation)) {
                caretOffset = currentNode.getEndOffset();
            } else if ("After".equals(insertionLocation)) {
                caretOffset = currentNode.getEndOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            LOGGER.warn("Cannot compute insertion position", (Throwable)e);
        }
        this.authorAccess.getEditorAccess().setCaretPosition(caretOffset);
    }

    private int getFirstPositionInNodeWhereTopicrefCanBeInserted(AuthorNode currentNode) {
        int caretOffset = currentNode.getStartOffset() + 1;
        try {
            AuthorDocumentFragment topicrefFrag = this.createTopicrefFragment();
            return this.getInsertionPositionsInNode(currentNode).stream().filter(offset -> this.canTopicRefBeInsertedAtPosition((int)offset, topicrefFrag)).findFirst().orElse(caretOffset);
        }
        catch (AuthorOperationException e) {
            LOGGER.debug("Cannot test whether topicref can be inserted", (Throwable)e);
            return caretOffset;
        }
    }

    private boolean canTopicRefBeInsertedAtPosition(int caretOffset, AuthorDocumentFragment topicrefFrag) {
        Optional<AuthorSchemaManager> usableSchemaManager = this.getUsableSchemaManager();
        if (usableSchemaManager.isPresent()) {
            return usableSchemaManager.get().canInsertDocumentFragment(topicrefFrag, caretOffset, (short)4);
        }
        return true;
    }

    private AuthorDocumentFragment createTopicrefFragment() throws AuthorOperationException {
        int caretOffset = this.authorAccess.getEditorAccess().getCaretOffset();
        AuthorDocumentController ctrl = this.authorAccess.getDocumentController();
        return ctrl.createNewDocumentFragmentInContext("<topicref/>", caretOffset);
    }

    private Optional<AuthorSchemaManager> getUsableSchemaManager() {
        AuthorSchemaManager authorSchemaManager = this.authorAccess.getDocumentController().getAuthorSchemaManager();
        if (authorSchemaManager != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema()) {
            return Optional.of(authorSchemaManager);
        }
        return Optional.empty();
    }

    private List<AuthorNode> getElementChildren(AuthorNode context) {
        if (context instanceof AuthorParentNode) {
            return ((AuthorParentNode)context).getContentNodes();
        }
        return Collections.emptyList();
    }

    private List<Integer> getInsertionPositionsInNode(AuthorNode context) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        offsets.add(context.getStartOffset() + 1);
        this.getElementChildren(context).stream().map(child -> child.getEndOffset() + 1).forEach(offsets::add);
        return offsets;
    }
}

