/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.dita.map.topicref.TopicrefInsertionPositionResolver;
import ro.sync.ecss.extensions.dita.map.topicref.util.FileProber;
import ro.sync.ecss.extensions.dita.map.topicref.util.Slugifier;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappRestSafe
public class CreateAndInsertTopicRef
implements AuthorOperation {
    private static final String DITA_FILE_EXTENSION = "dita";
    private static final String TITLE_ARGUMENT = "title";
    private static final String FOLDER_URL_ARGUMENT = "folderUrl";
    private static final String TOPIC_CONTENT_ARGUMENT = "templateContent";
    private static final String TOPIC_CONTENT_PATH_ARGUMENT = "templatePath";
    private static final String RELATIVE_LOCATION_ARGUMENT = "insertPosition";
    private static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the current node.\n", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        File frameworkFolder = this.getFrameworkFolder(authorAccess);
        Arguments arguments = new Arguments(args, frameworkFolder);
        try {
            this.createTopicAndInsertReference(authorAccess, arguments);
        }
        catch (IOException e) {
            throw new AuthorOperationException("Cannot save topic \"" + arguments.getTitle() + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    private File getFrameworkFolder(AuthorAccess authorAccess) {
        String frameworkLocation = authorAccess.getEditorAccess().getDocumentTypeInformation().getFrameworkStoreLocation();
        File frameworkFolder = new File(frameworkLocation).getParentFile();
        return frameworkFolder;
    }

    @VisibleForTesting
    void createTopicAndInsertReference(AuthorAccess authorAccess, Arguments arguments) throws IOException, AuthorOperationException {
        URL editorLocation = authorAccess.getEditorAccess().getEditorLocation();
        URL folderUrl = this.getFolderUrl(editorLocation, arguments).orElseGet(() -> this.proposeFolderUrl(authorAccess));
        URL topicUrl = this.createTopic(folderUrl, arguments);
        new TopicrefInsertionPositionResolver(authorAccess).moveCaretToPosition(arguments.getInsertionLocation());
        DITAAccess.handleTopicRefInsertUrl((AuthorAccess)authorAccess, (URL)topicUrl);
    }

    @VisibleForTesting
    URL createTopic(URL folderUrl, Arguments args) throws IOException {
        URL topicUrl = this.getTopicUrl(folderUrl, args);
        String topicContent = this.getContentForNewTopic(args);
        IOUtil.saveInURLWithUTF8((URL)topicUrl, (String)topicContent);
        return topicUrl;
    }

    private String getContentForNewTopic(Arguments args) {
        String templateContent;
        File templateFile = args.getTopicFile();
        if (templateFile != null) {
            try {
                templateContent = IOUtil.readFile((File)templateFile, (String)StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read template file: " + templateFile, e);
            }
        } else {
            templateContent = args.getTopicContent();
        }
        String title = args.getTitle();
        return templateContent.replace("${title}", title).replace("${id}", new Slugifier().slugify(title));
    }

    @VisibleForTesting
    URL proposeFolderUrl(AuthorAccess access) {
        AuthorNode authorNode = this.getReferenceNodeOfInsertionPosition(access);
        if (authorNode instanceof AuthorElement) {
            return DITAAccess.proposeFolderUrlForChildTopicref((AuthorElement)((AuthorElement)authorNode));
        }
        return this.getFolderOfMap(access);
    }

    private URL getFolderOfMap(AuthorAccess access) {
        try {
            return URLUtil.getParentURL((URL)access.getEditorAccess().getEditorLocation());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Editor URL is malformed", e);
        }
    }

    private AuthorNode getReferenceNodeOfInsertionPosition(AuthorAccess access) {
        AuthorNode authorNode;
        int caretOffset = access.getEditorAccess().getCaretOffset();
        try {
            authorNode = access.getDocumentController().getNodeAtOffset(caretOffset);
        }
        catch (BadLocationException e) {
            authorNode = null;
        }
        return authorNode;
    }

    @VisibleForTesting
    URL getTopicUrl(URL folderUrl, Arguments args) {
        String title = args.getTitle();
        String slugifiedTitle = new Slugifier().slugify(title);
        FileProber fileProber = new FileProber();
        try {
            for (int i = 0; i < 100; ++i) {
                Object suffix = i == 0 ? "" : "-" + i;
                String fileNameWithoutExtension = slugifiedTitle + (String)suffix;
                URL topicUrl = new URL(folderUrl, fileNameWithoutExtension + ".dita");
                if (fileProber.exists(topicUrl) == FileProber.Status.EXISTS) continue;
                return topicUrl;
            }
            throw new IllegalArgumentException("File already exists: " + title);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL obtained from title is malformed: " + title, e);
        }
    }

    private Optional<URL> getFolderUrl(URL editorLocation, Arguments args) {
        return args.getFolderUrl().map(folderUrlString -> this.resolveRelativeUrl(editorLocation, (String)folderUrlString));
    }

    private URL resolveRelativeUrl(URL baseUrl, String relative) {
        try {
            return new URL(baseUrl, relative);
        }
        catch (MalformedURLException e1) {
            throw new IllegalArgumentException("Invalid folder url: " + relative, e1);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(TOPIC_CONTENT_ARGUMENT, 0, "The content of the topic"), new ArgumentDescriptor(TOPIC_CONTENT_PATH_ARGUMENT, 0, "The absolute URL of the topic template. Can contain editor variables."), new ArgumentDescriptor(FOLDER_URL_ARGUMENT, 0, "The OXY-URL of the folder in which the topic is saved"), new ArgumentDescriptor(TITLE_ARGUMENT, 0, "The title of the topic"), ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION};
    }

    public String getDescription() {
        return "Create a new topic and insert a reference to it";
    }

    public static class Arguments {
        private ArgumentsMap args;
        private File frameworkFolder;

        public Arguments(ArgumentsMap args, File frameworkFolder) {
            this.args = args;
            this.frameworkFolder = frameworkFolder;
        }

        public String getTitle() {
            return (String)this.args.getArgumentValue(CreateAndInsertTopicRef.TITLE_ARGUMENT);
        }

        public String getTopicContent() {
            return (String)this.args.getArgumentValue(CreateAndInsertTopicRef.TOPIC_CONTENT_ARGUMENT);
        }

        public Optional<String> getFolderUrl() {
            return Optional.ofNullable((String)this.args.getArgumentValue(CreateAndInsertTopicRef.FOLDER_URL_ARGUMENT));
        }

        public String getInsertionLocation() {
            return (String)this.args.getArgumentValue(CreateAndInsertTopicRef.RELATIVE_LOCATION_ARGUMENT);
        }

        public File getTopicFile() {
            String topicPath = (String)this.args.getArgumentValue(CreateAndInsertTopicRef.TOPIC_CONTENT_PATH_ARGUMENT);
            if (topicPath != null) {
                return this.resolveToFrameworkFolder(topicPath);
            }
            return null;
        }

        @VisibleForTesting
        File resolveToFrameworkFolder(String topicPath) {
            File frameworkFile = new File(this.frameworkFolder, topicPath);
            try {
                if (!frameworkFile.getCanonicalPath().startsWith(this.frameworkFolder.getCanonicalPath() + File.separator)) {
                    throw new IllegalArgumentException("Topic path is not inside the framework folder: " + topicPath);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Topic path is invalid: " + topicPath, e);
            }
            return frameworkFile;
        }
    }
}

