/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.table;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelperBase;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class RelTablePropertiesHelper
extends TablePropertiesHelperBase {
    private static final String RELCOLSPEC = "relcolspec";
    private static final String RELCELL = "relcell";
    private static final String RELHEADER = "relheader";
    private static final String RELROW = "relrow";
    private static final String ATTRIBUTE_CLASS = "class";

    @Override
    public boolean isTable(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" map/reltable ");
    }

    @Override
    public boolean isTableRow(AuthorElement node) {
        return this.isHeaderRow(node) || this.isBodyRow(node);
    }

    public boolean isHeaderRow(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" map/relheader ");
    }

    public boolean isBodyRow(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && classAttr.getValue().contains(" map/relrow ");
    }

    @Override
    public boolean isTableHead(AuthorElement node) {
        return this.isHeaderRow(node);
    }

    @Override
    public boolean isTableBody(AuthorElement node) {
        return this.isBodyRow(node);
    }

    @Override
    public boolean isTableCell(AuthorElement node) {
        AttrValue classAttr = node.getAttribute(ATTRIBUTE_CLASS);
        return classAttr != null && (classAttr.getValue().contains(" map/relcell ") || classAttr.getValue().contains(" map/relcolspec "));
    }

    @Override
    public String getElementTag(int elementType) {
        return "<" + this.getElementName(elementType) + "/>";
    }

    @Override
    public String getElementName(int elementType) {
        String elementName = "";
        switch (elementType) {
            case 1: {
                elementName = RELROW;
                break;
            }
            case 2: {
                elementName = RELHEADER;
                break;
            }
            case 6: {
                elementName = RELCELL;
                break;
            }
            case 8: {
                elementName = RELCOLSPEC;
                break;
            }
        }
        return elementName;
    }
}

