/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAMapTopicTitlesResolveListener
implements AuthorExtensionStateListener {
    public String getDescription() {
        return "Extension handling the DITA Map topic titles resolving on open";
    }

    public void activated(AuthorAccess authorAccess) {
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        if (editorAccess == null) {
            return;
        }
        boolean shouldShowTopicTitles = Boolean.parseBoolean((String)editorAccess.getEditingContext().getAttribute("showTopicTitles"));
        if (shouldShowTopicTitles) {
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            AuthorElement documentRootElement = documentController.getAuthorDocumentNode().getRootElement();
            documentController.setPseudoClass("-oxy-show-topic-titles", documentRootElement);
        }
    }

    public void deactivated(AuthorAccess authorAccess) {
        authorAccess = null;
    }
}

