/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.id;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.dita.id.AttributeReferenceValueDetector;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAUniqueAttributesRecognizerUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAUniqueAttributesRecognizerUtil.class.getName());

    private DITAUniqueAttributesRecognizerUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void correctFragmentReferences(AuthorDocumentFragment fragment, URL sourceURL, URL destinationURL) {
        try {
            if (fragment != null && sourceURL != null && destinationURL != null && !URLUtil.getParentURL((URL)sourceURL).equals(URLUtil.getParentURL((URL)destinationURL))) {
                List contentNodes = fragment.getContentNodes();
                DITAUniqueAttributesRecognizerUtil.updateNodeHrefsBeforeInsert(contentNodes, sourceURL.toExternalForm(), destinationURL);
            }
        }
        catch (MalformedURLException e) {
            logger.warn(e.getMessage(), e.getCause());
        }
    }

    private static void updateNodeHrefsBeforeInsert(List<AuthorNode> contentNodes, String sourceSystemID, URL destinationURL) {
        Optional.ofNullable(contentNodes).ifPresent(nodes -> nodes.stream().filter(authorNode -> authorNode.getType() == 0).map(AuthorElement.class::cast).forEach(authorElement -> {
            String source;
            String newHref;
            String initialRefVal;
            AttributeReferenceValueDetector attrRefValueDetector = new AttributeReferenceValueDetector((AuthorElement)authorElement);
            AttrValue attr = attrRefValueDetector.detectRefAttrValue();
            Optional<String> attributeValue = Optional.ofNullable(attr).map(AttrValue::getValue).filter(Objects::nonNull).filter(attrInternalValue -> !attrInternalValue.trim().isEmpty());
            if (attributeValue.isPresent() && !DITAUniqueAttributesRecognizerUtil.targetAlreadyExists(destinationURL, initialRefVal = attr.getValue()) && !Equaler.verifyEquals((Object)initialRefVal, (Object)(newHref = URLUtil.makeRelative((URL)destinationURL, (URL)URLUtil.convertToURL((String)(source = URLUtil.makeAbsolute((String)sourceSystemID, (String)initialRefVal))))))) {
                authorElement.setAttribute(attrRefValueDetector.getDetectedRefAttrName(), new AttrValue(newHref));
            }
            DITAUniqueAttributesRecognizerUtil.updateNodeHrefsBeforeInsert(authorElement.getContentNodes(), sourceSystemID, destinationURL);
        }));
    }

    private static boolean targetAlreadyExists(URL destinationURL, String initialRefVal) {
        String potentialTarget = URLUtil.makeAbsolute((String)destinationURL.toExternalForm(), (String)initialRefVal);
        try {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)new URL(potentialTarget));
            return file != null && file.isFile();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }
}

