/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.id;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.link.CannotRecognizeIDException;
import ro.sync.ecss.extensions.api.link.IDTypeIdentifier;
import ro.sync.ecss.extensions.api.link.IDTypeRecognizer;
import ro.sync.ecss.extensions.dita.id.DITAIDTypeIdentifier;
import ro.sync.outline.xml.Attribute;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAIDTypeRecognizer
extends IDTypeRecognizer {
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String HREF_ATTRIBUTE_NAME = "href";
    private static final String KEYREF_ATTRIBUTE_NAME = "keyref";
    private static final String CONREF_ATTRIBUTE_NAME = "conref";
    private static final String CONKEYREF_ATTRIBUTE_NAME = "conkeyref";
    public static final String FIRST_TOPIC_ID = "FIRST_TOPIC_ID";
    private static final String SAME_TOPIC_ID = ".";

    public List<IDTypeIdentifier> detectIDType(String systemID, Context context, String attrName, String attrNs, String attributeValue, int offset) throws CannotRecognizeIDException {
        ContextElement parentElement;
        Stack elStack;
        ArrayList<IDTypeIdentifier> idTypeIdentifiers = new ArrayList<IDTypeIdentifier>();
        if (attributeValue != null && attributeValue.trim().length() > 0 && ID_ATTRIBUTE_NAME.equals(attrName) && !(elStack = context.getElementStack()).isEmpty() && (parentElement = (ContextElement)elStack.peek()) != null) {
            boolean isTopicElement = DITAIDTypeRecognizer.isTopicElement(context, parentElement);
            DITAIDTypeIdentifier idTypeIdentifier = null;
            if (isTopicElement) {
                idTypeIdentifier = new DITAIDTypeIdentifier(systemID, attributeValue.trim(), null, elStack.size() == 1, true);
            } else {
                ClosestTopicIDDetails details = DITAIDTypeRecognizer.getClosestTopicID(context);
                if (details != null) {
                    idTypeIdentifier = new DITAIDTypeIdentifier(systemID, details.topicID, attributeValue.trim(), details.firstTopicInFile, true);
                } else if (DITAIDTypeRecognizer.isMapElement(context, (ContextElement)elStack.get(0))) {
                    idTypeIdentifier = new DITAIDTypeIdentifier(systemID, null, attributeValue.trim(), false, true);
                    idTypeIdentifier.setElementInMap(true);
                }
            }
            if (idTypeIdentifier != null) {
                idTypeIdentifiers.add((IDTypeIdentifier)idTypeIdentifier);
            }
        }
        return idTypeIdentifiers.isEmpty() ? null : idTypeIdentifiers;
    }

    private static ClosestTopicIDDetails getClosestTopicID(Context context) {
        Stack elStack = context.getElementStack();
        for (int i = elStack.size() - 2; i >= 0; --i) {
            Attribute[] attrs;
            ContextElement ce = (ContextElement)elStack.get(i);
            boolean isTopicElement = DITAIDTypeRecognizer.isTopicElement(context, ce);
            if (!isTopicElement || (attrs = ce.getAttributes()) == null) continue;
            for (int j = 0; j < attrs.length; ++j) {
                if (!ID_ATTRIBUTE_NAME.equals(attrs[j].getQName())) continue;
                ClosestTopicIDDetails details = new ClosestTopicIDDetails();
                details.topicID = attrs[j].getValue();
                details.firstTopicInFile = i == 0;
                return details;
            }
        }
        return null;
    }

    private static boolean isMapElement(Context context, ContextElement contextElement) {
        boolean isMap = false;
        String contextClass = context.getDefaultAttributeValue(contextElement, "class");
        isMap = contextClass != null ? contextClass.contains(" map/map ") : "map".equals(contextElement.getQName()) || "bookmap".equals(contextElement.getQName());
        return isMap;
    }

    private static boolean isTopicElement(Context context, ContextElement contextElement) {
        boolean isTopic = false;
        String contextClass = context.getDefaultAttributeValue(contextElement, "class");
        isTopic = contextClass != null ? contextClass.contains(" topic/topic ") : "topic".equals(contextElement.getQName()) || "task".equals(contextElement.getQName()) || "concept".equals(contextElement.getQName()) || "reference".equals(contextElement.getQName()) || context.getElementStack().indexOf(contextElement) == 0;
        return isTopic;
    }

    public int[] locateIDType(String systemID, Context context, String attrName, String attrNs, String attributeValue, IDTypeIdentifier idIdentifier, short mode) {
        int[] idLocation = null;
        if (idIdentifier instanceof DITAIDTypeIdentifier) {
            ContextElement parentElement;
            DITAIDTypeIdentifier ditaID = (DITAIDTypeIdentifier)idIdentifier;
            Stack elementStack = context.getElementStack();
            if (!elementStack.isEmpty() && (parentElement = (ContextElement)elementStack.peek()) != null) {
                if ((mode & 1) != 0) {
                    idLocation = DITAIDTypeRecognizer.locateDeclaration(systemID, context, attrName, attributeValue, ditaID, parentElement);
                }
                if (idLocation == null && (mode & 2) != 0) {
                    idLocation = DITAIDTypeRecognizer.locateReference(systemID, attrName, attributeValue, ditaID);
                }
            }
        }
        return idLocation;
    }

    private static int[] locateReference(String systemID, String attrName, String attributeValue, DITAIDTypeIdentifier ditaID) {
        int[] idLocation = null;
        if (HREF_ATTRIBUTE_NAME.equals(attrName) || CONREF_ATTRIBUTE_NAME.equals(attrName)) {
            idLocation = DITAIDTypeRecognizer.locateDirectReference(systemID, attributeValue, ditaID);
        } else if (KEYREF_ATTRIBUTE_NAME.equals(attrName) || CONKEYREF_ATTRIBUTE_NAME.equals(attrName)) {
            try {
                idLocation = DITAIDTypeRecognizer.locateIndirectReference(systemID, attributeValue, ditaID);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return idLocation;
    }

    private static int[] locateIndirectReference(String systemID, String attributeValue, DITAIDTypeIdentifier ditaID) throws MalformedURLException {
        String elementID = ditaID.getElementID();
        String topicID = ditaID.getTopicID();
        int[] idLocation = null;
        RefTarget keyRefTarget = DITAIDTypeRecognizer.getKeyRefTarget(attributeValue, systemID);
        if (keyRefTarget != null && Equaler.verifyEquals((Object)ditaID.getLocation(), (Object)keyRefTarget.url.toString())) {
            if (elementID == null) {
                if (Equaler.verifyEquals((Object)keyRefTarget.topicID, (Object)topicID) && keyRefTarget.elementID == null) {
                    // empty if block
                }
            } else if (Equaler.verifyEquals((Object)keyRefTarget.elementID, (Object)elementID) && (Equaler.verifyEquals((Object)topicID, (Object)keyRefTarget.topicID) || FIRST_TOPIC_ID.equals(keyRefTarget.topicID) && (ditaID.isTopicFirstInFile() || ditaID.isElementInMap()))) {
                idLocation = keyRefTarget.elementIDLocation;
            }
        }
        return idLocation;
    }

    private static int[] locateDirectReference(String systemID, String attributeValue, DITAIDTypeIdentifier ditaID) {
        String baseSystemID = systemID;
        String elementID = ditaID.getElementID();
        String topicID = ditaID.getTopicID();
        int[] idLocation = null;
        int indexOfAnchor = attributeValue.indexOf(35);
        if (indexOfAnchor != -1) {
            if (indexOfAnchor > 0) {
                try {
                    URL targetURL = new URL(new URL(systemID), attributeValue.substring(0, indexOfAnchor));
                    baseSystemID = targetURL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (baseSystemID != null && Equaler.verifyEquals((Object)baseSystemID, (Object)ditaID.getLocation()) && indexOfAnchor < attributeValue.length() - 1) {
                String pathInTopic = attributeValue.substring(indexOfAnchor + 1);
                int slashIndex = pathInTopic.indexOf(47);
                if (elementID == null && slashIndex == -1) {
                    if (Equaler.verifyEquals((Object)topicID, (Object)pathInTopic)) {
                        int so = indexOfAnchor + 1;
                        idLocation = new int[]{so, so + pathInTopic.length()};
                    }
                } else if (slashIndex != -1) {
                    if (slashIndex > 0 && slashIndex < pathInTopic.length() - 1) {
                        String currentTopicID = pathInTopic.substring(0, slashIndex);
                        String currentElementID = pathInTopic.substring(slashIndex + 1);
                        if (topicID != null && (topicID.equals(currentTopicID) || SAME_TOPIC_ID.equals(currentTopicID))) {
                            if (currentElementID.equals(elementID)) {
                                idLocation = new int[]{indexOfAnchor + 1 + slashIndex + 1, indexOfAnchor + 1 + slashIndex + 1 + currentElementID.length()};
                            } else if (elementID == null) {
                                idLocation = new int[]{indexOfAnchor + 1, indexOfAnchor + 1 + currentTopicID.length()};
                            }
                        }
                    }
                } else if (elementID == null) {
                    String currentTopicID;
                    if (slashIndex > 0 && slashIndex < pathInTopic.length() - 1 && (currentTopicID = pathInTopic.substring(0, slashIndex)).equals(topicID)) {
                        idLocation = new int[]{indexOfAnchor + 1, indexOfAnchor + 1 + pathInTopic.length()};
                    }
                } else if (ditaID.isElementInMap() && Equaler.verifyEquals((Object)elementID, (Object)pathInTopic)) {
                    idLocation = new int[]{indexOfAnchor + 1, indexOfAnchor + 1 + pathInTopic.length()};
                }
            }
        }
        return idLocation;
    }

    private static int[] locateDeclaration(String systemID, Context context, String attrName, String attributeValue, DITAIDTypeIdentifier ditaID, ContextElement parentElement) {
        int[] idLocation = null;
        String elementID = ditaID.getElementID();
        String topicID = ditaID.getTopicID();
        if (Equaler.verifyEquals((Object)systemID, (Object)ditaID.getLocation()) && ID_ATTRIBUTE_NAME.equals(attrName)) {
            boolean parentElementIsTopic = DITAIDTypeRecognizer.isTopicElement(context, parentElement);
            if (parentElementIsTopic) {
                if (elementID == null && Equaler.verifyEquals((Object)topicID, (Object)attributeValue)) {
                    idLocation = new int[]{0, attributeValue.length()};
                }
            } else {
                ClosestTopicIDDetails details = DITAIDTypeRecognizer.getClosestTopicID(context);
                if (details != null) {
                    if (Equaler.verifyEquals((Object)details.topicID, (Object)topicID) && Equaler.verifyEquals((Object)elementID, (Object)attributeValue)) {
                        idLocation = new int[]{0, attributeValue.length()};
                    }
                } else {
                    Stack elementStack = context.getElementStack();
                    if (elementStack != null && !elementStack.isEmpty() && DITAIDTypeRecognizer.isMapElement(context, (ContextElement)elementStack.get(0)) && ditaID.isElementInMap() && Equaler.verifyEquals((Object)elementID, (Object)attributeValue)) {
                        idLocation = new int[]{0, attributeValue.length()};
                    }
                }
            }
        }
        return idLocation;
    }

    private static RefTarget getKeyRefTarget(String keyRefValue, String baseSystemID) throws MalformedURLException {
        URL hrefLocation;
        KeyInfo keyInfo;
        String keyName = keyRefValue;
        String elementID = null;
        int[] elementIDLocation = null;
        int indexOfSlash = keyRefValue.indexOf(47);
        if (indexOfSlash != -1) {
            keyName = keyName.substring(0, indexOfSlash);
            if (indexOfSlash < keyRefValue.length() - 1) {
                elementID = keyRefValue.substring(indexOfSlash + 1);
                elementIDLocation = new int[]{indexOfSlash + 1, indexOfSlash + 1 + elementID.length()};
            }
        }
        if ((keyInfo = (KeyInfo)DITAAccess.getKeys((URL)new URL(baseSystemID)).get(keyName)) != null && (hrefLocation = keyInfo.getHrefLocation()) != null) {
            String topicID = hrefLocation.getRef();
            if (topicID != null) {
                topicID = URLUtil.uncorrect((String)topicID);
                hrefLocation = URLUtil.removeAnchor((URL)hrefLocation);
            }
            RefTarget target = new RefTarget();
            target.elementID = elementID;
            target.elementIDLocation = elementIDLocation;
            target.topicID = topicID != null ? topicID : FIRST_TOPIC_ID;
            target.url = hrefLocation;
            return target;
        }
        return null;
    }

    public boolean isDefaultIDTypeRecognitionAvailable() {
        return false;
    }

    public boolean isIDTypeRecognitionAvailable() {
        return true;
    }

    private static class ClosestTopicIDDetails {
        String topicID;
        boolean firstTopicInFile;

        private ClosestTopicIDDetails() {
        }
    }

    private static class RefTarget {
        URL url;
        String topicID;
        String elementID;
        int[] elementIDLocation;

        private RefTarget() {
        }
    }
}

