/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.conref;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TextReferenceReader
implements XMLReader {
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private String referenceSystemId;
    private String encoding;
    private int lineStart = 0;
    private int lineEnd = Integer.MAX_VALUE;
    private static final Pattern CONTENT_RANGE_REGEX = Pattern.compile(".+#token=([^,\\s]*)(?:,([^,\\s]+))?$");
    private static final Pattern LINE_REGEX = Pattern.compile(".+#line=(?:(\\d+)|(\\d+)?,(\\d+)?)$");
    private static final Pattern LINE_RANGE_REGEX = Pattern.compile(".+#line-range\\((\\d+)(?:,\\s*(\\d+))?\\)$");

    public TextReferenceReader(String referenceSystemId, String encoding, AuthorUtilAccess authorUtilAccess) {
        this.referenceSystemId = referenceSystemId;
        this.encoding = encoding;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.contentHandler != null) {
            if (this.entityResolver != null && this.referenceSystemId != null && (input = this.entityResolver.resolveEntity(null, this.referenceSystemId)) != null) {
                this.referenceSystemId = input.getSystemId();
            }
            StringBuilder content = null;
            if (this.referenceSystemId != null) {
                this.extractLineRange();
                content = this.extractContent(input);
            }
            if (content != null) {
                int length = content.length();
                char[] chars = new char[length];
                content.getChars(0, length, chars, 0);
                this.contentHandler.startDocument();
                this.contentHandler.characters(chars, 0, length);
                this.contentHandler.endDocument();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder extractContent(InputSource input) throws IOException {
        Matcher mi;
        StringBuilder content = null;
        String lineStartContent = null;
        String lineEndContent = null;
        if (this.lineStart == 0 && this.lineEnd == Integer.MAX_VALUE && (mi = CONTENT_RANGE_REGEX.matcher(this.referenceSystemId)).matches()) {
            if (mi.group(1) != null && mi.group(1).length() != 0 && (lineStartContent = mi.group(1).trim()).isEmpty()) {
                lineStartContent = null;
            }
            if (mi.group(2) != null && (lineEndContent = mi.group(2).trim()).isEmpty()) {
                lineEndContent = null;
            }
        }
        URL url = new URL(this.referenceSystemId);
        Reader inputReader = null;
        if (input != null) {
            if (input.getCharacterStream() != null) {
                inputReader = input.getCharacterStream();
            } else if (input.getByteStream() != null) {
                inputReader = new InputStreamReader(input.getByteStream(), this.encoding);
            }
        }
        if (inputReader == null) {
            InputStream is = url.openStream();
            inputReader = new InputStreamReader(is, this.encoding);
        }
        BufferedReader reader = new BufferedReader(inputReader);
        try {
            content = new StringBuilder();
            String line = reader.readLine();
            boolean firstLine = true;
            boolean startAppendContent = false;
            int i = 0;
            while (line != null) {
                if (lineStartContent != null || lineEndContent != null) {
                    if (lineEndContent != null && line.contains(lineEndContent)) {
                        startAppendContent = false;
                    }
                    if (startAppendContent) {
                        if (firstLine) {
                            firstLine = false;
                        } else {
                            content.append('\n');
                        }
                        content.append(line);
                    }
                    if (lineStartContent == null && firstLine) {
                        startAppendContent = true;
                        firstLine = false;
                        content.append(line);
                    } else if (lineStartContent != null && line.contains(lineStartContent)) {
                        startAppendContent = true;
                    }
                } else if (i >= this.lineStart && i <= this.lineEnd) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        content.append('\n');
                    }
                    content.append(line);
                }
                line = reader.readLine();
                ++i;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content;
    }

    private void extractLineRange() {
        Matcher m = LINE_REGEX.matcher(this.referenceSystemId);
        if (m.matches()) {
            if (m.group(1) != null) {
                try {
                    this.lineEnd = this.lineStart = NumberParserUtil.parseInt((String)m.group(1).trim());
                }
                catch (NumberFormatException e) {
                    this.lineStart = 0;
                    this.lineEnd = Integer.MAX_VALUE;
                }
            } else {
                if (m.group(2) != null) {
                    try {
                        this.lineStart = NumberParserUtil.parseInt((String)m.group(2).trim());
                    }
                    catch (NumberFormatException e) {
                        this.lineStart = 0;
                    }
                } else {
                    this.lineStart = 0;
                }
                if (m.group(3) != null) {
                    try {
                        this.lineEnd = NumberParserUtil.parseInt((String)m.group(3).trim()) - 1;
                    }
                    catch (NumberFormatException e) {
                        this.lineEnd = Integer.MAX_VALUE;
                    }
                } else {
                    this.lineEnd = Integer.MAX_VALUE;
                }
            }
        } else {
            Matcher mc = LINE_RANGE_REGEX.matcher(this.referenceSystemId);
            if (mc.matches()) {
                try {
                    this.lineStart = NumberParserUtil.parseInt((String)mc.group(1).trim()) - 1;
                }
                catch (NumberFormatException e) {
                    this.lineStart = 0;
                }
                if (mc.group(2) != null) {
                    try {
                        this.lineEnd = NumberParserUtil.parseInt((String)mc.group(2).trim()) - 1;
                    }
                    catch (NumberFormatException e) {
                        this.lineEnd = Integer.MAX_VALUE;
                    }
                } else {
                    this.lineEnd = Integer.MAX_VALUE;
                }
            } else {
                this.lineStart = 0;
                this.lineEnd = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new SAXException("Not implemented!");
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

