/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.KeysManagerBase;
import ro.sync.ecss.extensions.api.AuthorAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class WebappKeysUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)WebappKeysUtil.class.getName());

    private WebappKeysUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getKeyRefForUrl(AuthorAccess authorAccess, String referenceUrl) {
        String keyRef;
        ContextKeyManager contextKeyManager = authorAccess.getEditorAccess().getEditingContext().getContextKeyManager();
        URL editorLocation = authorAccess.getEditorAccess().getEditorLocation();
        try {
            URL referenceAbsoluteUrl = new URL(editorLocation, referenceUrl);
            keyRef = DITAAccess.getKeyRefValueForUrl((KeysManagerBase)contextKeyManager, (URL)referenceAbsoluteUrl, (URL)editorLocation);
        }
        catch (MalformedURLException e) {
            logger.debug("Bad cross refrence value", (Throwable)e);
            keyRef = null;
        }
        return keyRef;
    }
}

