/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorReferenceResolver;
import ro.sync.ecss.extensions.api.ReferenceResolverException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorDocumentProvider;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorReferenceNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DOTProjectAuthorReferenceResolver
implements AuthorReferenceResolver {
    private static final String INCLUDE_ELEMENT_NAME = "include";
    private static final String HREF_ATTR_NAME = "href";
    private static final Logger logger = LoggerFactory.getLogger((String)DOTProjectAuthorReferenceResolver.class.getName());

    public String getDescription() {
        return "Resolves the 'include' references in DITA-OT projects.";
    }

    public SAXSource resolveReference(AuthorNode node, String systemID, AuthorAccess authorAccess, EntityResolver entityResolver) throws ReferenceResolverException {
        String referenceSystemId = this.getReferenceSystemID(node, authorAccess);
        if (referenceSystemId != null) {
            try {
                InputSource inputSource = new InputSource(referenceSystemId);
                XMLReader reader = authorAccess.getXMLUtilAccess().newNonValidatingXMLReader();
                reader.setEntityResolver(entityResolver);
                return new SAXSource(reader, inputSource);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e, (Throwable)e);
                }
                ReferenceResolverException rre = new ReferenceResolverException(e.getMessage(), false, false);
                rre.initCause((Throwable)e);
                throw rre;
            }
        }
        return null;
    }

    public boolean isReferenceChanged(AuthorNode node, String attributeName) {
        return HREF_ATTR_NAME.equals(attributeName);
    }

    public boolean hasReferences(AuthorNode node) {
        return INCLUDE_ELEMENT_NAME.equals(this.getDisplayName(node)) && Objects.nonNull(DOTProjectAuthorReferenceResolver.extractHref(node));
    }

    public String getReferenceUniqueID(AuthorNode node) {
        return DOTProjectAuthorReferenceResolver.extractHref(node);
    }

    public String getReferenceSystemID(AuthorNode node, AuthorAccess authorAccess) {
        return Optional.ofNullable(DOTProjectAuthorReferenceResolver.extractHref(node)).map(href -> authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(node.getXMLBaseURL(), href, false, true).toExternalForm()).orElse(null);
    }

    public String getDisplayName(AuthorNode node) {
        return node.getDisplayName();
    }

    public boolean hasEditableReference(String systemID, AuthorNode referenceNodeParent) {
        return Objects.nonNull(DOTProjectAuthorReferenceResolver.extractHref(referenceNodeParent));
    }

    public void replaceReference(AuthorDocumentProvider targetProvider, AuthorAccess authorAccess, AuthorReferenceNode referenceNode) throws IOException {
        try {
            List contentNodes = referenceNode.getContentNodes();
            if (!contentNodes.isEmpty()) {
                AuthorNode newRootElement = (AuthorNode)contentNodes.get(0);
                AuthorDocumentFragment contentToSave = authorAccess.getDocumentController().createDocumentFragment(newRootElement.getStartOffset(), newRootElement.getEndOffset(), true);
                if (contentToSave != null) {
                    targetProvider.getAuthorDocumentController().replaceRoot(contentToSave);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean allowsValidatationForEditableReference(String systemID, AuthorNode referenceNodeParent) {
        return this.hasEditableReference(systemID, referenceNodeParent);
    }

    private static String extractHref(AuthorNode node) {
        return Optional.of(node).filter(t -> t.getType() == 0).map(AuthorElement.class::cast).map(el -> el.getAttribute(HREF_ATTR_NAME)).map(attrVal -> attrVal.getValue()).orElse(null);
    }
}

