/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.operations.InsertListOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class DITAInsertListOperation
extends InsertListOperation {
    static final String ORDERED_LIST = "orderedlist";
    static final String UNORDERED_LIST = "unorderedlist";
    static final String SIMPLE_LIST = "simplelist";
    private static final Logger logger = LoggerFactory.getLogger((String)DITAInsertListOperation.class.getName());
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, new ArgumentDescriptor("listType", 3, "Controls the type of list to be inserted. Accepted values are: orderedlist, unorderedlist and simplelist. Default value is orderedlist.", new String[]{"orderedlist", "unorderedlist", "simplelist"}, "orderedlist"), CONVERT_ELEMENT_AT_CARET_ARGUMENT_DESCRIPTOR};

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert an ordered/unordered list.";
    }

    @Override
    protected CommonsOperationsUtil.ConversionElementHelper getConversionElementsChecker() {
        return new CommonsOperationsUtil.ConversionElementHelper(){

            @Override
            public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
                String clazz;
                AuthorElement element;
                AttrValue attribute;
                boolean canBeConverted = false;
                if (node instanceof AuthorElement && (attribute = (element = (AuthorElement)node).getAttribute("class")) != null && (clazz = attribute.getValue()) != null && (clazz.contains(" topic/p ") || clazz.contains(" topic/ol ") || clazz.contains(" topic/ul ") || clazz.contains(" topic/li ") || clazz.contains(" topic/sl ") || clazz.contains(" topic/sli "))) {
                    canBeConverted = true;
                }
                if (!canBeConverted) {
                    throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("list.convert.exception"));
                }
                return canBeConverted;
            }
        };
    }

    @Override
    protected void insertContent(AuthorAccess authorAccess, AuthorNode listNode, List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFragmentsInfos) {
        if (listNode instanceof AuthorElement) {
            List contentNodes = ((AuthorElement)listNode).getContentNodes();
            for (int i = 0; i < contentNodes.size(); ++i) {
                String value;
                AttrValue attribute;
                AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                if (!(authorNode instanceof AuthorElement) || (attribute = ((AuthorElement)authorNode).getAttribute("class")) == null || !"- topic/li ".equals(value = attribute.getValue()) || i >= selectedFragmentsInfos.size()) continue;
                try {
                    String xmlFragment = authorAccess.getDocumentController().serializeFragmentToXML(selectedFragmentsInfos.get(i).getSelectedFragment());
                    Map<String, String> attributes = selectedFragmentsInfos.get(i).getAttributes();
                    if (attributes != null) {
                        Set<String> names = attributes.keySet();
                        for (String attrName : names) {
                            if ("id".equals(attrName)) continue;
                            authorAccess.getDocumentController().setAttribute(attrName, new AttrValue(attributes.get(attrName)), (AuthorElement)authorNode);
                        }
                    }
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment, authorNode.getStartOffset() + 1, 7, false);
                    continue;
                }
                catch (BadLocationException | AuthorOperationException e) {
                    logger.error((Object)e, e);
                }
            }
        }
    }

    @Override
    protected String getNamespace() {
        return null;
    }

    @Override
    protected String getXMLFragment(AuthorAccess authorAccess, String listType, String parentListType) {
        StringBuilder frag = new StringBuilder();
        if (SIMPLE_LIST.equals(listType)) {
            String listElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/sl ", (String)"sl");
            String listItemElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/sli ", (String)"sli");
            frag.append("<").append(listElName).append(">");
            frag.append("<").append(listItemElName).append("/").append(">");
            frag.append("<").append("/").append(listElName).append(">");
        } else {
            String liElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/li ", (String)"li");
            if (ORDERED_LIST.equals(parentListType) || UNORDERED_LIST.equals(parentListType)) {
                frag.append("<").append(liElName).append(">");
            }
            if (ORDERED_LIST.endsWith(listType)) {
                String olElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/ol ", (String)"ol");
                frag.append("<").append(olElName).append("><").append(liElName).append("/></").append(olElName).append(">");
            } else {
                String ulElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/ul ", (String)"ul");
                frag.append("<").append(ulElName).append("><").append(liElName).append("/></").append(ulElName).append(">");
            }
            if (ORDERED_LIST.equals(parentListType) || UNORDERED_LIST.equals(parentListType)) {
                frag.append("</").append(liElName).append(">");
            }
        }
        return frag.toString();
    }

    @Override
    protected StringBuilder getListXMLFragment(String listType, Map<String, String> attributes, int numberOfListItems, AuthorAccess authorAccess) {
        boolean orderedList = listType.equals(ORDERED_LIST);
        StringBuilder listXMLFragment = new StringBuilder();
        String listElementName = orderedList ? DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/ol ", (String)"ol") : DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/ul ", (String)"ul");
        String serializedAttributes = CommonsOperationsUtil.serializeAttributes(attributes, Collections.emptySet());
        listXMLFragment.append("<").append(listElementName).append(serializedAttributes).append(">");
        for (int i = 0; i < numberOfListItems; ++i) {
            String liElName = DITAAccess.getPossibleElementQName((AuthorDocumentController)authorAccess.getDocumentController(), (String)" topic/li ", (String)"li");
            listXMLFragment.append("<").append(liElName).append("/>");
        }
        listXMLFragment.append("</").append(listElementName).append(">");
        return listXMLFragment;
    }

    @Override
    protected String getParentListType(AuthorNode node) {
        String parentType = null;
        while (node != null) {
            AttrValue classAttr;
            if (node instanceof AuthorElement && (classAttr = ((AuthorElement)node).getAttribute("class")) != null && classAttr.getValue() != null) {
                if (classAttr.getValue().contains(" topic/ol ")) {
                    parentType = ORDERED_LIST;
                } else if (classAttr.getValue().contains(" topic/ul ")) {
                    parentType = UNORDERED_LIST;
                } else if (classAttr.getValue().contains(" topic/sl ")) {
                    parentType = SIMPLE_LIST;
                }
                if (parentType != null || classAttr.getValue().contains(" topic/li ")) break;
            }
            node = node.getParent();
        }
        return parentType;
    }

    @Override
    protected boolean isListElement(AuthorNode node) {
        AttrValue classAttr;
        boolean isListElement = false;
        if (node instanceof AuthorElement && (classAttr = ((AuthorElement)node).getAttribute("class")) != null && classAttr.getValue() != null) {
            isListElement = classAttr.getValue().contains(" topic/ol ") || classAttr.getValue().contains(" topic/ul ") || classAttr.getValue().contains(" topic/li ") || classAttr.getValue().contains(" topic/sl ");
        }
        return isListElement;
    }

    @Override
    protected boolean isList(AuthorNode node) {
        AttrValue classAttr;
        boolean isList = false;
        if (node instanceof AuthorElement && (classAttr = ((AuthorElement)node).getAttribute("class")) != null && classAttr.getValue() != null) {
            isList = classAttr.getValue().contains(" topic/ol ") || classAttr.getValue().contains(" topic/ul ") || classAttr.getValue().contains(" topic/sl ");
        }
        return isList;
    }

    @Override
    protected String getListTypeDescription(String listType) {
        String toRet = "";
        if (ORDERED_LIST.equals(listType)) {
            toRet = "ordered";
        } else if (UNORDERED_LIST.equals(listType)) {
            toRet = "unordered";
        } else if (SIMPLE_LIST.equals(listType)) {
            toRet = "simple";
        }
        return toRet;
    }
}

