/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.KeysManagerBase;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class DITAExternalObjectInsertionHandlerUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAExternalObjectInsertionHandlerUtil.class.getName());

    private DITAExternalObjectInsertionHandlerUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String[] getReferenceAttributeNameAndValue(ContextKeyManagerProvider keysManagerProvider, AuthorAccess authorAccess, URL base, URL url, AuthorNode contextNode) {
        return DITAExternalObjectInsertionHandlerUtil.getReferenceAttributeNameAndValueInternal(keysManagerProvider, authorAccess.getEditorAccess().getEditorLocation(), base, url, contextNode, false);
    }

    public static String[] getMediaReferenceAttributeNameAndValue(ContextKeyManagerProvider keysManagerProvider, URL editorLocation, URL base, URL url, AuthorNode contextNode) {
        return DITAExternalObjectInsertionHandlerUtil.getReferenceAttributeNameAndValueInternal(keysManagerProvider, editorLocation, base, url, contextNode, true);
    }

    public static String[] getReferenceAttributeNameAndValueInternal(ContextKeyManagerProvider keysManagerProvider, URL editorLocation, URL base, URL url, AuthorNode contextNode, boolean isMediaElement) {
        String matchedKey;
        String refAttrName = isMediaElement ? "data" : "href";
        String refAttrValue = null;
        if (url != null && DITAAccess.preferAddingKeyrefToAlreadyReferencedResource((URL)editorLocation) && (matchedKey = DITAAccess.getKeyForUrl((KeysManagerBase)(keysManagerProvider != null ? keysManagerProvider.getContextKeyManager() : null), (URL)url, (URL)editorLocation, (AuthorNode)contextNode)) != null) {
            refAttrName = isMediaElement ? "datakeyref" : "keyref";
            refAttrValue = matchedKey;
        }
        if (refAttrValue == null && url != null) {
            refAttrValue = URLUtil.makeRelative((URL)base, (URL)url);
        }
        if (isMediaElement) {
            refAttrValue = MediaObjectsUtil.correctMediaEmbeddedReference(refAttrValue);
        }
        return new String[]{refAttrName, refAttrValue};
    }

    public static void insertContentReference(ContextKeyManagerProvider keysManagerProvider, AuthorAccess authorAccess, URL url) throws AuthorOperationException {
        String path = URLUtil.getURLParameterValue((URL)url, (String)"ReusableComponentTargetPath");
        String targetElementQName = URLUtil.getURLParameterValue((URL)url, (String)"ReusableComponentTargetQname");
        String elementClass = URLUtil.getURLParameterValue((URL)url, (String)"ReusableComponentElementClass");
        if (path != null && targetElementQName != null && elementClass != null) {
            url = URLUtil.removeQuery((URL)url);
            URL editorLocation = authorAccess.getEditorAccess().getEditorLocation();
            boolean insertedKey = false;
            String keyForUrl = DITAAccess.getKeyForUrl((KeysManagerBase)(keysManagerProvider != null ? keysManagerProvider.getContextKeyManager() : null), (URL)url, (URL)editorLocation);
            if (keyForUrl != null) {
                int indexOf = path.indexOf(47);
                if (indexOf != -1) {
                    path = path.substring(indexOf + 1);
                }
                String conkeyrefValue = keyForUrl + "/" + path;
                DITAAccess.insertReference((AuthorAccess)authorAccess, (String)conkeyrefValue, (int)2, (String)targetElementQName, (String)elementClass);
                insertedKey = true;
            }
            if (!insertedKey) {
                String relativeLocation = URLUtil.makeRelative((URL)editorLocation, (URL)url, (boolean)true, (boolean)false);
                String conrefAttrValue = relativeLocation + "#" + path;
                DITAAccess.insertReference((AuthorAccess)authorAccess, (String)conrefAttrValue, (String)targetElementQName, (String)elementClass);
            }
        }
    }

    public static String clearInternalQueryParamsFromExtractedRefAttrVal(URL base, String refAttrValue) {
        String clearedValue;
        block10: {
            if (refAttrValue == null) {
                return null;
            }
            clearedValue = refAttrValue;
            if (refAttrValue.contains("?oxy") || refAttrValue.contains("&oxy")) {
                URL toUse;
                boolean relative;
                block9: {
                    relative = false;
                    toUse = null;
                    try {
                        toUse = new URL(clearedValue);
                    }
                    catch (MalformedURLException e) {
                        try {
                            toUse = new URL(base, clearedValue);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (toUse == null) break block9;
                        relative = true;
                    }
                }
                try {
                    if (toUse != null) {
                        URLInfo info = new URLInfo(toUse);
                        URL cleanedUrl = info.getURL(true, false, true);
                        clearedValue = relative ? URLUtil.makeRelative((URL)base, (URL)cleanedUrl) : cleanedUrl.toExternalForm();
                    }
                }
                catch (MalformedURLException e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug((Object)e, (Throwable)e);
                }
            }
        }
        return clearedValue;
    }

    public static KeyInfo detectKeyInfo(URL urlToDrop, URL originatorURL) {
        String keyName = URLUtil.getURLParameterValue((URL)urlToDrop, (String)"FullyQualifiedKeyName");
        if (keyName != null) {
            List keys = DITAAccess.getKeysForInsertion((URL)originatorURL);
            return keys.stream().filter(KeyInfo::isRelative).filter(k -> keyName.equals(k.getOriginalQualifiedKeyName())).findFirst().orElseGet(() -> keys.stream().filter(k -> keyName.equals(k.getKeyName())).findFirst().orElse(null));
        }
        return null;
    }
}

