/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.link.ElementLocator;
import ro.sync.ecss.extensions.api.link.IDTypeVerifier;
import ro.sync.ecss.extensions.commons.DefaultElementLocatorProvider;
import ro.sync.ecss.extensions.dita.DITAElementLocator;
import ro.sync.ecss.extensions.dita.DITAIDElementLocator;
import ro.sync.ecss.extensions.dita.DITAMapKeyDefElementLocator;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAElementLocatorProvider
extends DefaultElementLocatorProvider {
    private boolean locateInsideDITAMap;

    public DITAElementLocatorProvider() {
    }

    public DITAElementLocatorProvider(boolean locateInsideDITAMap) {
        this.locateInsideDITAMap = locateInsideDITAMap;
    }

    @Override
    public ElementLocator getElementLocator(IDTypeVerifier idVerifier, String link) {
        ElementLocator locator = null;
        if (link.startsWith("element(")) {
            locator = super.getElementLocator(idVerifier, link);
        } else if (link.startsWith("keyref(") && link.endsWith(")")) {
            locator = new DITAMapKeyDefElementLocator(link);
        } else if (link.indexOf(47) != -1) {
            if (link.indexOf(47) != link.length() - 1) {
                locator = new DITAElementLocator(link);
            }
        } else {
            locator = new DITAIDElementLocator(new IDTypeVerifier(){

                public boolean hasIDType(String elementName, String elementNs, String attrName, String attrNs) {
                    return "id".equals(attrName);
                }
            }, link, this.locateInsideDITAMap);
        }
        return locator;
    }
}

