/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.exml.workspace.api.editor.ReadOnlyReason;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class SetReadOnlyStatusOperation
implements AuthorOperation {
    public static final String ARGUMENT_READ_ONLY = "read-only";
    public static final String ARGUMENT_READ_ONLY_REASON = "reason";
    public static final String ARGUMENT_READ_ONLY_CODE = "reason-code";
    protected static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("read-only", 3, "Sets the read-only status of the current document.Can be: \n - true: for making the document read-only\n - false: for making the document writable\nDefault value is true.", new String[]{"true", "false"}, "true"), new ArgumentDescriptor("reason", 0, "The reason for the document being read-only. It will be displayed when the user tries to edit the document.\nIf not specified, a default message will be displayed to the user."), new ArgumentDescriptor("reason-code", 0, "The code for the reason for the document being read-only. It will be accessible through API. Optional.")};

    public String getDescription() {
        return "Changes the document read-only status.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        boolean shouldMakeReadOnly = "true".equals("" + args.getArgumentValue(ARGUMENT_READ_ONLY));
        String reason = (String)args.getArgumentValue(ARGUMENT_READ_ONLY_REASON);
        String reasonCode = (String)args.getArgumentValue(ARGUMENT_READ_ONLY_CODE);
        if (shouldMakeReadOnly) {
            authorAccess.getEditorAccess().setReadOnly(new ReadOnlyReason(reason, reasonCode));
        } else {
            authorAccess.getEditorAccess().setEditable(!shouldMakeReadOnly);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

