/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationWithCustomUndoBehavior;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ReloadContentOperation
implements AuthorOperation,
AuthorOperationWithCustomUndoBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ReloadContentOperation.class.getName());
    static final String ARGUMENT_MARK_AS_NOT_MODIFIED = "markAsNotModified";
    static final String ARGUMENT_FORCED = "forced";
    static final String ARGUMENT_DISCARD_UNDOABLE_EDITS = "discard_undoable_edits";
    private static ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("markAsNotModified", 0, "After reloading the content the editor may appear as modified. Sometimes, the content is already present on the file server, so the user should not save it again. This flags can be used in these cases to prevent the editor from showing as modified", new String[]{"true", "false"}, "false"), new ArgumentDescriptor("forced", 0, "Control whether we force reloading the document even if the content did not change.", new String[]{"true", "false"}, "true"), new ArgumentDescriptor("discard_undoable_edits", 0, "Control whether we discard undoable edits.", new String[]{"true", "false"}, "false")};

    public String getDescription() {
        return "Reloads the content of the editor by reading again from the URL used to open it";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        int caretBefore = editorAccess.getAuthorSelectionModel().getSelectionInterval().getEndOffset();
        URL systemIdUrl = editorAccess.getEditorLocation();
        Reader contentReader = null;
        boolean modified = true;
        try {
            contentReader = authorAccess.getUtilAccess().createReader(systemIdUrl, "UTF-8");
            if (ReloadContentOperation.isArgumentTrue(args, ARGUMENT_FORCED)) {
                editorAccess.reloadContent(contentReader, ReloadContentOperation.isArgumentTrue(args, ARGUMENT_DISCARD_UNDOABLE_EDITS));
            } else {
                modified = ReloadContentOperation.reloadFromReaderIfModified(editorAccess, contentReader);
            }
        }
        catch (IOException e) {
            throw new AuthorOperationException("Could not read the content of the editor from its URL: " + systemIdUrl, (Throwable)e);
        }
        finally {
            if (contentReader != null) {
                try {
                    contentReader.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Could not close reader.", (Throwable)e);
                }
            }
        }
        if (ReloadContentOperation.isArgumentTrue(args, ARGUMENT_MARK_AS_NOT_MODIFIED)) {
            authorAccess.getEditorAccess().setModified(false);
        }
        if (modified) {
            int endOffset = authorAccess.getDocumentController().getAuthorDocumentNode().getEndOffset();
            if (caretBefore >= endOffset) {
                caretBefore = endOffset - 1;
            }
            authorAccess.getEditorAccess().getAuthorSelectionModel().setSelection(caretBefore, caretBefore);
        }
    }

    private static boolean isArgumentTrue(ArgumentsMap args, String argumentName) {
        Object argumentValue = args.getArgumentValue(argumentName);
        return Boolean.TRUE.equals(argumentValue) || "true".equals(argumentValue);
    }

    private static boolean reloadFromReaderIfModified(AuthorEditorAccess editorAccess, Reader contentReader) throws IOException {
        String contentFromUrl = IOUtil.read((Reader)contentReader).toString();
        String contentFromDoc = IOUtil.read((Reader)editorAccess.createContentReader()).toString();
        boolean modified = true;
        if (!contentFromUrl.equals(contentFromDoc)) {
            try (StringReader cachedReader = new StringReader(contentFromUrl);){
                editorAccess.reloadContent((Reader)cachedReader, false);
            }
        } else {
            modified = false;
        }
        return modified;
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }
}

