/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentInformation;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentProcessor;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DefaultUniqueAttributesRecognizer
implements UniqueAttributesRecognizer,
ClipboardFragmentProcessor {
    protected String idAttrQname = "id";
    protected AuthorAccess authorAccess;
    private GenerateIDElementsInfo defaultOptions = new GenerateIDElementsInfo(false, "${localName}_${id}", new String[0]);
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultUniqueAttributesRecognizer.class.getName());

    public DefaultUniqueAttributesRecognizer() {
    }

    public DefaultUniqueAttributesRecognizer(String idAttrQname) {
        this.idAttrQname = idAttrQname;
    }

    public boolean copyAttributeOnSplit(String attrQName, AuthorElement element) {
        return !this.idAttrQname.equals(attrQName);
    }

    public void activated(AuthorAccess authorAccess) {
        this.authorAccess = authorAccess;
        this.defaultOptions = GenerateIDElementsInfo.loadDefaultsFromConfiguration(authorAccess, this.getDefaultOptionsXMLResourceName());
        if (this.defaultOptions.getAttrQname() != null) {
            this.idAttrQname = this.defaultOptions.getAttrQname();
        }
    }

    public void deactivated(AuthorAccess authorAccess) {
        this.authorAccess = null;
    }

    protected GenerateIDElementsInfo getDefaultOptions() {
        return this.defaultOptions;
    }

    protected String getDefaultOptionsXMLResourceName() {
        return null;
    }

    public boolean isAutoIDGenerationActive() {
        GenerateIDElementsInfo generateIDElementsInfo = this.getGenerateIDElementsInfo();
        return generateIDElementsInfo != null && generateIDElementsInfo.isAutoGenerateIDs() && generateIDElementsInfo.getElementsWithIDGeneration() != null;
    }

    protected String getGenerateIDAttributeQName(AuthorElement element, String[] elemsWithAutoGeneration, boolean forceGeneration) {
        String idAttrName = null;
        if (forceGeneration) {
            idAttrName = this.idAttrQname;
        } else {
            for (int i = 0; i < elemsWithAutoGeneration.length; ++i) {
                String pattern = elemsWithAutoGeneration[i];
                boolean match = false;
                if (element.getLocalName().equals(pattern)) {
                    match = true;
                }
                if (!match) continue;
                idAttrName = this.idAttrQname;
                break;
            }
        }
        return idAttrName;
    }

    protected String generateUniqueIDFor(String idGenerationPattern, AuthorElement element) {
        URL edLocation = element.getXMLBaseURL();
        return GenerateIDElementsInfo.generateID(idGenerationPattern, element.getLocalName(), edLocation != null ? edLocation.toString() : null);
    }

    public void assignUniqueIDs(int startOffset, int endOffset, boolean forceGeneration) {
        GenerateIDElementsInfo currentElemsInfo;
        if (this.authorAccess != null && (currentElemsInfo = this.getGenerateIDElementsInfo()) != null && (forceGeneration || currentElemsInfo.getElementsWithIDGeneration() != null && currentElemsInfo.getElementsWithIDGeneration().length > 0)) {
            try {
                AuthorNode commonParent = this.authorAccess.getDocumentController().getCommonParentNode(this.authorAccess.getDocumentController().getAuthorDocumentNode(), startOffset, endOffset);
                this.authorAccess.getDocumentController().beginCompoundEdit();
                ArrayList<AttributeSetInfo> toGenerate = new ArrayList<AttributeSetInfo>();
                this.generateUniqueIDs(this.authorAccess, commonParent, startOffset, endOffset, currentElemsInfo.getIdGenerationPattern(), currentElemsInfo.getElementsWithIDGeneration(), forceGeneration, toGenerate);
                this.setIDs(toGenerate);
            }
            catch (BadLocationException e) {
                logger.warn((Object)e, (Throwable)e);
            }
        }
    }

    private void generateUniqueIDs(AuthorAccess authorAccess, AuthorNode currentNode, int startSel, int endSel, String idGenerationPattern, String[] elementsToGenerateFor, boolean forceGeneration, List<AttributeSetInfo> attrsToGenerate) {
        if (authorAccess.getDocumentController().isEditable(currentNode)) {
            boolean nodeIntersectsSelection;
            int startOffset = currentNode.getStartOffset();
            int endOffset = currentNode.getEndOffset();
            boolean nodeContainsSelection = startSel <= startOffset && endOffset <= endSel || startSel <= startOffset && startOffset <= endSel || startSel <= endOffset && endOffset <= endSel;
            boolean bl = nodeIntersectsSelection = startOffset <= startSel && startSel <= endOffset || startOffset <= endSel && endSel <= endOffset || startSel <= startOffset && startOffset <= endSel || startSel <= endOffset && endOffset <= endSel;
            if (nodeIntersectsSelection) {
                AttributeSetInfo generatedId;
                if (nodeContainsSelection && (generatedId = this.generateUniqueIdForNode(currentNode, idGenerationPattern, elementsToGenerateFor, forceGeneration)) != null) {
                    attrsToGenerate.add(generatedId);
                }
                if (currentNode instanceof AuthorParentNode) {
                    AuthorParentNode sentinelNode = (AuthorParentNode)currentNode;
                    List contentNodes = sentinelNode.getContentNodes();
                    for (int i = 0; i < contentNodes.size(); ++i) {
                        this.generateUniqueIDs(authorAccess, (AuthorNode)contentNodes.get(i), startSel, endSel, idGenerationPattern, elementsToGenerateFor, forceGeneration, attrsToGenerate);
                    }
                }
            }
        }
    }

    private AttributeSetInfo generateUniqueIdForNode(AuthorNode node, String idGenerationPattern, String[] elementsToGenerateFor, boolean forceGeneration) {
        AttrValue attr;
        AuthorElement element;
        String generateIdAttrQName;
        AttributeSetInfo generatedAttr = null;
        if (node.getType() == 0 && (generateIdAttrQName = this.getGenerateIDAttributeQName(element = (AuthorElement)node, elementsToGenerateFor, forceGeneration)) != null && ((attr = element.getAttribute(generateIdAttrQName)) == null || "".equals(attr.getValue()) || !attr.isSpecified())) {
            AttributeSetInfo info = new AttributeSetInfo();
            info.attrQName = generateIdAttrQName;
            info.attrValue = this.generateUniqueIDFor(idGenerationPattern, element);
            info.element = element;
            generatedAttr = info;
        }
        return generatedAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIDs(List<AttributeSetInfo> idsList) {
        try {
            int noOfIDs = idsList.size();
            if (noOfIDs == 1) {
                AttributeSetInfo info = idsList.get(0);
                this.authorAccess.getDocumentController().setAttribute(info.attrQName, new AttrValue(info.attrValue), info.element);
            } else {
                int[] elemOffsets = new int[noOfIDs];
                AuthorNode[] nodes = new AuthorNode[noOfIDs];
                ArrayList attrs = new ArrayList(noOfIDs);
                for (int i = 0; i < elemOffsets.length; ++i) {
                    AttributeSetInfo attributeSetInfo = idsList.get(i);
                    nodes[i] = attributeSetInfo.element;
                    elemOffsets[i] = attributeSetInfo.element.getStartOffset();
                    HashMap<String, AttrValue> attrsToGenerate = new HashMap<String, AttrValue>();
                    attrsToGenerate.put(attributeSetInfo.attrQName, new AttrValue(attributeSetInfo.attrValue));
                    attrs.add(attrsToGenerate);
                }
                AuthorNode commonAncestor = this.authorAccess.getDocumentController().getCommonAncestor(nodes);
                if (commonAncestor == null) {
                    commonAncestor = this.authorAccess.getDocumentController().getAuthorDocumentNode();
                }
                if (!attrs.isEmpty()) {
                    this.authorAccess.getDocumentController().setMultipleDistinctAttributes(commonAncestor.getStartOffset(), elemOffsets, attrs);
                }
            }
        }
        finally {
            this.authorAccess.getDocumentController().endCompoundEdit();
        }
    }

    public GenerateIDElementsInfo getGenerateIDElementsInfo() {
        if (this.authorAccess != null) {
            return new GenerateIDElementsInfo(this.authorAccess, this.getDefaultOptions());
        }
        return null;
    }

    public void process(ClipboardFragmentInformation fragmentInformation) {
        String location;
        if (this.authorAccess == null) {
            logger.warn("NULL Author Access, should not happen", (Throwable)new Exception());
            return;
        }
        GenerateIDElementsInfo currentElemsInfo = this.getGenerateIDElementsInfo();
        if (currentElemsInfo != null && !currentElemsInfo.isFilterIDsOnCopy()) {
            return;
        }
        boolean removeUniqueIDs = false;
        String string = location = fragmentInformation.getLocationOfLastPaste() != null ? fragmentInformation.getLocationOfLastPaste() : fragmentInformation.getOriginalLocation();
        if (location != null && !location.equals(this.authorAccess.getEditorAccess().getEditorLocation().toString())) {
            removeUniqueIDs = !this.preserveIDsWhenPastingBetweenResources(fragmentInformation.getPurposeID());
        } else {
            int purposeID = fragmentInformation.getPurposeID();
            if (purposeID == 0 || purposeID == 2) {
                removeUniqueIDs = true;
            }
        }
        if (removeUniqueIDs) {
            this.filterIDAttributes(fragmentInformation.getFragment().getContentNodes());
        }
    }

    protected boolean preserveIDsWhenPastingBetweenResources(int fragmentPurpose) {
        return true;
    }

    private void filterIDAttributes(List<AuthorNode> contentNodes) {
        for (int i = 0; i < contentNodes.size(); ++i) {
            AuthorNode node = contentNodes.get(i);
            if (node.getType() == 0) {
                ((AuthorElement)node).removeAttribute(this.idAttrQname);
            }
            if (!(node instanceof AuthorParentNode)) continue;
            this.filterIDAttributes(((AuthorParentNode)node).getContentNodes());
        }
    }

    public String getDescription() {
        return "Default unique attributes generation";
    }

    private static class AttributeSetInfo {
        private AuthorElement element;
        private String attrQName;
        private String attrValue;

        private AttributeSetInfo() {
        }
    }
}

