/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class XPathAttributesUtil {
    private static final Map<String, Map<String, List<String>>> XPATH_ATTRS;
    private static final String XSD_XPATH_ATTRS_MAP_KEY = "xsd";
    private static final String XSLT_XPATH_ATTRS_MAP_KEY = "xslt";
    private static final String XSPEC_XPATH_ATTRS_MAP_KEY = "xspec";
    private static final String SCH_XPATH_ATTRS_MAP_KEY = "sch";
    private static final String USE_WHEN = "use-when";
    private static final String MATCH = "match";
    private static final String SELECT = "select";
    private static final String TEST = "test";
    private static final String XPATH = "xpath";
    private static final String PARAM = "param";
    private static final String ASSERT = "assert";

    private XPathAttributesUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Map<String, List<String>> getSchematronElementsToXPathAttributesMap() {
        return XPATH_ATTRS.get(SCH_XPATH_ATTRS_MAP_KEY);
    }

    public static Map<String, List<String>> getSchemaElementsToXPathAttributesMap() {
        return XPATH_ATTRS.get(XSD_XPATH_ATTRS_MAP_KEY);
    }

    public static Map<String, List<String>> getStylesheetElementsToXPathAttributesMap() {
        return XPATH_ATTRS.get(XSLT_XPATH_ATTRS_MAP_KEY);
    }

    public static Map<String, List<String>> getXSPECElementsToXPathAttributesMap() {
        return XPATH_ATTRS.get(XSPEC_XPATH_ATTRS_MAP_KEY);
    }

    static {
        List<String> listMatchSelectUsewhen = List.of(MATCH, SELECT, USE_WHEN);
        List<String> listSelectUsewhen = List.of(SELECT, USE_WHEN);
        List<String> listUsewhen = List.of(USE_WHEN);
        List<String> listSelect = List.of(SELECT);
        List<String> listTest = List.of(TEST);
        HashMap<String, List<String>> xsltXPathAttrs = new HashMap<String, List<String>>();
        xsltXPathAttrs.put("accumulator", List.of("applies-to", "initial-value", USE_WHEN));
        xsltXPathAttrs.put("accumulator-rule", listMatchSelectUsewhen);
        xsltXPathAttrs.put("analyze-string", listSelectUsewhen);
        xsltXPathAttrs.put("apply-templates", listSelectUsewhen);
        xsltXPathAttrs.put(ASSERT, List.of(SELECT, TEST, USE_WHEN));
        xsltXPathAttrs.put("attribute", listSelectUsewhen);
        xsltXPathAttrs.put("break", listSelectUsewhen);
        xsltXPathAttrs.put("catch", listSelectUsewhen);
        xsltXPathAttrs.put("comment", listSelectUsewhen);
        xsltXPathAttrs.put("copy", List.of(SELECT, "on-empty", USE_WHEN));
        xsltXPathAttrs.put("copy-of", listSelectUsewhen);
        xsltXPathAttrs.put("element", List.of("on-empty", USE_WHEN));
        xsltXPathAttrs.put("evaluate", List.of(XPATH, "with-params", "context-item", "namespace-context", USE_WHEN));
        xsltXPathAttrs.put("for-each", listSelectUsewhen);
        xsltXPathAttrs.put("for-each-group", List.of(SELECT, "group-by", "group-adjacent", "group-starting-with", "group-ending-with", USE_WHEN));
        xsltXPathAttrs.put("if", List.of(TEST, USE_WHEN));
        xsltXPathAttrs.put("iterate", listSelectUsewhen);
        xsltXPathAttrs.put("key", List.of(MATCH, "use", USE_WHEN));
        xsltXPathAttrs.put("map-entry", List.of("key", SELECT, USE_WHEN));
        xsltXPathAttrs.put("merge-key", listSelectUsewhen);
        xsltXPathAttrs.put("merge-source", List.of(SELECT, "for-each-item", "for-each-stream", USE_WHEN));
        xsltXPathAttrs.put("message", listSelectUsewhen);
        xsltXPathAttrs.put("namespace", listSelectUsewhen);
        xsltXPathAttrs.put("number", List.of(SELECT, "value", "count", "from", USE_WHEN));
        xsltXPathAttrs.put("on-completion", listSelectUsewhen);
        xsltXPathAttrs.put("on-empty", listSelectUsewhen);
        xsltXPathAttrs.put("on-non-empty", listSelectUsewhen);
        xsltXPathAttrs.put("package", listUsewhen);
        xsltXPathAttrs.put(PARAM, listSelectUsewhen);
        xsltXPathAttrs.put("perform-sort", listSelectUsewhen);
        xsltXPathAttrs.put("processing-instruction", listSelectUsewhen);
        xsltXPathAttrs.put("sequence", listSelectUsewhen);
        xsltXPathAttrs.put("sort", listSelectUsewhen);
        xsltXPathAttrs.put("stylesheet", listUsewhen);
        xsltXPathAttrs.put("value-of", listSelectUsewhen);
        xsltXPathAttrs.put("variable", listSelectUsewhen);
        xsltXPathAttrs.put("when", List.of(TEST, USE_WHEN));
        xsltXPathAttrs.put("with-param", listSelectUsewhen);
        xsltXPathAttrs.put("template", List.of(MATCH, USE_WHEN));
        xsltXPathAttrs.put("transform", listUsewhen);
        xsltXPathAttrs.put("try", listSelectUsewhen);
        xsltXPathAttrs.put("set-attribute", listSelect);
        xsltXPathAttrs.put("set-property", List.of("object", SELECT));
        xsltXPathAttrs.put("assign", listSelect);
        xsltXPathAttrs.put("return", listSelect);
        xsltXPathAttrs.put("while", listTest);
        Map<String, List<String>> xsdXPathAttrs = Map.of("alternative", listTest, ASSERT, listTest, "field", List.of(XPATH), "selector", List.of(XPATH));
        HashMap<String, List<String>> schXPathAttrs = new HashMap<String, List<String>>();
        schXPathAttrs.put("rule", List.of("context"));
        schXPathAttrs.put("let", List.of("value"));
        schXPathAttrs.put("name", List.of("path"));
        schXPathAttrs.put("value-of", listSelect);
        schXPathAttrs.put(ASSERT, List.of(TEST, "subject"));
        schXPathAttrs.put("report", List.of(TEST, "subject"));
        schXPathAttrs.put("pattern", List.of("documents"));
        schXPathAttrs.put("add", listMatchSelectUsewhen);
        schXPathAttrs.put("delete", List.of(MATCH, USE_WHEN));
        schXPathAttrs.put("replace", listMatchSelectUsewhen);
        schXPathAttrs.put("stringReplace", listMatchSelectUsewhen);
        schXPathAttrs.put("keep", listSelect);
        schXPathAttrs.put("fix", List.of(USE_WHEN, "use-for-each"));
        schXPathAttrs.put("group", listUsewhen);
        schXPathAttrs.put(PARAM, List.of("default"));
        schXPathAttrs.put("with-param", listSelect);
        schXPathAttrs.put("user-entry", List.of("default"));
        Map<String, List<String>> xspecXPathAttrs = Map.of("context", listSelect, "expect", List.of(SELECT, TEST), PARAM, listSelect);
        XPATH_ATTRS = Map.of(XSLT_XPATH_ATTRS_MAP_KEY, Collections.unmodifiableMap(xsltXPathAttrs), XSD_XPATH_ATTRS_MAP_KEY, xsdXPathAttrs, SCH_XPATH_ATTRS_MAP_KEY, Collections.unmodifiableMap(schXPathAttrs), XSPEC_XPATH_ATTRS_MAP_KEY, xspecXPathAttrs);
    }
}

