/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker;

import com.oxygenxml.tokenmarker.LexerException;
import com.oxygenxml.tokenmarker.LexicalState;
import com.oxygenxml.tokenmarker.LexicalStateOverLong;
import com.oxygenxml.tokenmarker.Symbol;
import java.io.IOException;
import java.io.Reader;

public abstract class AbstractLexer {
    public static final int YYINITIAL = 0;
    protected int cLen = 0;
    protected byte lastToken = (byte)127;
    protected boolean onlyWSOccurred = true;
    protected boolean veryFirst = true;
    protected boolean atDocStart = false;
    private boolean activateNonWSOccurranceTracking = false;
    private static final LexicalState INITIAL_STATE = new LexicalStateOverLong();
    private LexicalState lexicalState = this.createLexicalState();
    private final SymbolImpl symbol = new SymbolImpl();

    protected AbstractLexer() {
    }

    protected AbstractLexer(boolean activateNonWSOccurranceTracking) {
        this.activateNonWSOccurranceTracking = activateNonWSOccurranceTracking;
    }

    protected LexicalState createLexicalState() {
        return new LexicalStateOverLong();
    }

    protected LexicalState getInitialLexicalState() {
        return INITIAL_STATE;
    }

    protected void pushState(int state) {
        this.lexicalState.push(state);
    }

    protected int popState() {
        return this.lexicalState.pop();
    }

    protected int peekState() {
        return this.lexicalState.peek();
    }

    protected void incrementNestingLevel() {
        this.lexicalState.setNestingLevel(this.lexicalState.getNestingLevel() + 1);
    }

    protected void decrementNestingLevel() {
        int nestingLevel = this.lexicalState.getNestingLevel();
        if (nestingLevel > 0) {
            this.lexicalState.setNestingLevel(nestingLevel - 1);
        }
    }

    protected int getNestingLevel() {
        return this.lexicalState.getNestingLevel();
    }

    public LexicalState getLexicalState() {
        this.lexicalState.setYYState(this.yystate());
        return this.lexicalState;
    }

    public int isStateOpen(int state) {
        int depth;
        int n = depth = state == this.yystate() ? 0 : -1;
        if (depth == -1) {
            depth = this.lexicalState.contains(state);
            if (this.peekState() == state) {
                this.popState();
            }
        }
        return depth;
    }

    public int getNextState(int defaultState, int nextState1, int nextState2) {
        int next1 = this.isStateOpen(nextState1);
        int next2 = this.isStateOpen(nextState2);
        if (next1 == -1 && next2 == -1) {
            return defaultState;
        }
        if (next1 == -1) {
            return nextState2;
        }
        if (next2 == -1) {
            return nextState1;
        }
        return next1 < next2 ? nextState2 : nextState1;
    }

    public void setLexicalState(LexicalState lexicalState) {
        this.lexicalState = lexicalState;
        this.yybegin(lexicalState.getYYState());
    }

    public void setDocumentStart(boolean atDocStart) {
        this.atDocStart = atDocStart;
    }

    protected Symbol symbol(byte type, int length) {
        if (this.activateNonWSOccurranceTracking && this.onlyWSOccurred) {
            this.onlyWSOccurred = this.yytext().trim().isEmpty();
        }
        this.veryFirst = false;
        this.atDocStart = false;
        this.symbol.tokenID = type;
        this.symbol.length = length;
        this.lastToken = type;
        return this.symbol;
    }

    protected boolean containsOnly(String tokenString, char ch) {
        if (tokenString != null && tokenString.trim().length() > 0) {
            tokenString = tokenString.trim();
            for (int i = 0; i < tokenString.length(); ++i) {
                if (tokenString.charAt(i) == ch) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected int countFirstOcurrences(String tokenString, char ch) {
        int ocurrences = 0;
        if (tokenString != null) {
            for (int i = 0; i < tokenString.length() && tokenString.charAt(i) == ch; ++i) {
                ++ocurrences;
            }
        }
        return ocurrences;
    }

    protected abstract int yylength();

    protected abstract String yytext();

    protected abstract void yyreset(Reader var1);

    protected abstract Symbol yylex() throws IOException, LexerException;

    protected abstract int yystate();

    protected abstract void yybegin(int var1);

    protected Symbol symbol(byte type) {
        return this.symbol(type, this.yylength());
    }

    protected Symbol flush(byte symbolType) {
        int length = this.cLen;
        this.cLen = 0;
        return this.symbol(symbolType, length);
    }

    public void reset(Reader reader) {
        this.onlyWSOccurred = true;
        this.veryFirst = true;
        this.yyreset(reader);
        this.cLen = 0;
    }

    public abstract String getName();

    private static class SymbolImpl
    implements Symbol {
        int length = 0;
        byte tokenID = 0;

        private SymbolImpl() {
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public byte getTokenId() {
            return this.tokenID;
        }
    }
}

