/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.pdfbox.CloneAnnotations;
import org.apache.fop.render.pdf.pdfbox.FOPPDFFont;
import org.apache.fop.render.pdf.pdfbox.HandleAnnotations;
import org.apache.fop.render.pdf.pdfbox.MergeAnnotations;
import org.apache.fop.render.pdf.pdfbox.MergeFontsPDFWriter;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapterUtil;
import org.apache.fop.render.pdf.pdfbox.PDFCloner;
import org.apache.fop.render.pdf.pdfbox.PDFUtil;
import org.apache.fop.render.pdf.pdfbox.PDFWriter;
import org.apache.fop.render.pdf.pdfbox.PatternUtil;
import org.apache.fop.render.pdf.pdfbox.UniqueName;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class PDFBoxAdapter {
    protected static final Set<String> FILTER_FILTER = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Filter", "DecodeParms")));
    private final PDFPage targetPage;
    protected final PDFDocument pdfDoc;
    protected final Map<Object, Object> clonedVersion;
    protected final Map<Object, Object> objectCache;
    private Map<COSName, String> newXObj = new HashMap<COSName, String>();
    private Map<Integer, PDFArray> pageNumbers;
    private Collection<String> parentFonts = new ArrayList<String>();
    protected int currentMCID;
    protected UniqueName uniqueName;
    private HandleAnnotations handleAnnotations;

    public PDFBoxAdapter(PDFPage targetPage, Map<Object, Object> objectCachePerFile, Map<Integer, PDFArray> pageNumbers) {
        this(targetPage, objectCachePerFile, null, pageNumbers, new HashMap<Object, Object>());
    }

    public PDFBoxAdapter(PDFPage targetPage, Map<Object, Object> objectCachePerFile, Map<String, Object> usedFields, Map<Integer, PDFArray> pageNumbers, Map<Object, Object> objectCache) {
        this.targetPage = targetPage;
        this.pdfDoc = this.targetPage.getDocument();
        this.clonedVersion = objectCachePerFile;
        this.pageNumbers = pageNumbers;
        this.objectCache = objectCache;
        this.handleAnnotations = this.pdfDoc.isMergeFormFieldsEnabled() ? new MergeAnnotations(this, usedFields) : new CloneAnnotations(this);
    }

    public PDFPage getTargetPage() {
        return this.targetPage;
    }

    public int getCurrentMCID() {
        return this.currentMCID;
    }

    public void setCurrentMCID(int currentMCID) {
        this.currentMCID = currentMCID;
    }

    protected Object getCachedClone(Object base) throws IOException {
        Object key = PDFBoxAdapterUtil.getBaseKey(base);
        Object o = this.clonedVersion.get(key);
        if (o == null) {
            return this.objectCache.get(key);
        }
        return o;
    }

    protected Object cloneForNewDocument(Object base) throws IOException {
        return new PDFCloner(this, false).cloneForNewDocument(base);
    }

    protected Object cloneForNewDocument(Object base, Object keyBase, Collection exclude) throws IOException {
        return new PDFCloner(this, false).cloneForNewDocument(base, keyBase, exclude);
    }

    protected void cacheClonedObject(Object base, Object cloned) throws IOException {
        new PDFCloner(this, false).cacheClonedObject(base, cloned);
    }

    protected void transferDict(COSDictionary orgDict, PDFStream targetDict, Set filter) throws IOException {
        this.transferDict(orgDict, targetDict, filter, false);
    }

    private void transferDict(COSDictionary orgDict, PDFStream targetDict, Set filter, boolean inclusive) throws IOException {
        Set keys = orgDict.keySet();
        for (COSName key : keys) {
            if (inclusive && !filter.contains(key.getName()) || !inclusive && filter.contains(key.getName())) continue;
            targetDict.put(key.getName(), this.cloneForNewDocument(orgDict.getItem(key)));
        }
    }

    public Object createStreamFromPDFBoxPage(PDDocument sourceDoc, PDPage sourcePage, String key, AffineTransform pageAdjust, FontInfo fontinfo, Rectangle destRect) throws IOException {
        COSDictionary sourcePageResources = this.getResources(sourcePage);
        PatternUtil patternUtil = new PatternUtil(this.targetPage, destRect, sourcePage, this.pdfDoc.isFormXObjectEnabled());
        this.uniqueName = new UniqueName(key, sourcePageResources, patternUtil.getPatternNames(), this.pdfDoc.isFormXObjectEnabled(), destRect);
        key = patternUtil.getKey(key);
        this.handleAnnotations(sourceDoc, sourcePage, pageAdjust, destRect);
        if (this.pageNumbers.containsKey(this.targetPage.getPageIndex())) {
            this.pageNumbers.get(this.targetPage.getPageIndex()).set(0, (Object)this.targetPage.makeReference());
        }
        PDStream pdStream = this.getContents(sourcePage);
        COSDictionary fonts = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.FONT);
        COSDictionary fontsBackup = null;
        String newStream = null;
        if (fonts != null && this.pdfDoc.isMergeFontsEnabled()) {
            fontsBackup = new COSDictionary(fonts);
            MergeFontsPDFWriter m = new MergeFontsPDFWriter(fonts, fontinfo, this.uniqueName, this.parentFonts, this.currentMCID);
            newStream = m.writeText(pdStream);
        }
        if (!this.pdfDoc.isFormXObjectEnabled()) {
            if (newStream == null && (newStream = (String)this.clonedVersion.get(key)) == null) {
                PDFWriter writer = new PDFWriter(this.uniqueName, this.currentMCID);
                newStream = writer.writeText(pdStream);
                this.clonedVersion.put(key, newStream);
            }
            pdStream = new PDStream(sourceDoc, (InputStream)new ByteArrayInputStream(newStream.getBytes("ISO-8859-1")));
        }
        this.mergeXObj(sourcePageResources, fontinfo, this.uniqueName);
        PDFDictionary pageResources = (PDFDictionary)this.cloneForNewDocument(sourcePageResources, sourcePageResources, patternUtil.getExclude());
        this.updateMergeFontInfo(pageResources, fontinfo);
        this.updateXObj(sourcePageResources, pageResources);
        if (fontsBackup != null) {
            sourcePageResources.setItem(COSName.FONT, (COSBase)fontsBackup);
        }
        COSStream originalPageContents = pdStream.getCOSObject();
        this.bindOptionalContent(sourceDoc);
        PDFStream pageStream = (PDFStream)this.cloneForNewDocument(originalPageContents, originalPageContents, patternUtil.getExclude());
        Set filter = Collections.EMPTY_SET;
        if (pageStream == null) {
            pageStream = new PDFStream();
        }
        if (this.pdfDoc.isFormXObjectEnabled()) {
            return this.getFormXObject(pageResources, pageStream, key, sourcePage);
        }
        if (originalPageContents != null) {
            this.transferDict((COSDictionary)originalPageContents, pageStream, filter);
        }
        this.transferPageDict(fonts, this.uniqueName, sourcePageResources);
        patternUtil.promotePatterns();
        PDRectangle mediaBox = sourcePage.getMediaBox();
        PDRectangle cropBox = sourcePage.getCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int rotation = PDFUtil.getNormalizedRotation(sourcePage);
        float w = (float)destRect.getWidth() / 1000.0f;
        float h = (float)destRect.getHeight() / 1000.0f;
        if (rotation == 90 || rotation == 270) {
            float tmp = w;
            w = h;
            h = tmp;
        }
        pageAdjust.setTransform(AffineTransform.getScaleInstance(w / viewBox.getWidth(), h / viewBox.getHeight()));
        pageAdjust.translate(0.0, viewBox.getHeight());
        pageAdjust.rotate(-Math.PI);
        pageAdjust.scale(-1.0, 1.0);
        pageAdjust.translate(-viewBox.getLowerLeftX(), -viewBox.getLowerLeftY());
        PDFBoxAdapterUtil.rotate(rotation, viewBox, pageAdjust);
        StringBuilder boxStr = new StringBuilder();
        boxStr.append(PDFNumber.doubleOut((double)mediaBox.getLowerLeftX())).append(' ').append(PDFNumber.doubleOut((double)mediaBox.getLowerLeftY())).append(' ').append(PDFNumber.doubleOut((double)mediaBox.getWidth())).append(' ').append(PDFNumber.doubleOut((double)mediaBox.getHeight())).append(" re W n\n");
        return boxStr.toString() + IOUtils.toString((InputStream)pdStream.createInputStream(), (String)"ISO-8859-1");
    }

    private PDStream getContents(PDPage page) throws IOException {
        PDStream pdStream = new PDStream(new COSStream());
        OutputStream os = pdStream.createOutputStream();
        IOUtils.copy((InputStream)page.getContents(), (OutputStream)os);
        os.close();
        return pdStream;
    }

    private void updateMergeFontInfo(PDFDictionary pageResources, FontInfo fontinfo) {
        PDFDictionary fontDict = (PDFDictionary)pageResources.get("Font");
        if (fontDict != null && this.pdfDoc.isMergeFontsEnabled()) {
            for (Map.Entry fontEntry : fontinfo.getUsedFonts().entrySet()) {
                Typeface font = (Typeface)fontEntry.getValue();
                if (!(font instanceof FOPPDFFont)) continue;
                FOPPDFFont pdfFont = (FOPPDFFont)font;
                if (pdfFont.getRef() == null) {
                    pdfFont.setRef(new PDFDictionary());
                    this.pdfDoc.assignObjectNumber((PDFObject)pdfFont.getRef());
                }
                fontDict.put((String)fontEntry.getKey(), (Object)pdfFont.getRef());
            }
        }
    }

    private PDFFormXObject getFormXObject(PDFDictionary pageResources, PDFStream pageStream, String key, PDPage page) throws IOException {
        if (this.pdfDoc.isMergeFontsEnabled()) {
            throw new RuntimeException("merge-fonts and form-xobject can't both be enabled");
        }
        if (!pageResources.hasObjectNumber()) {
            this.pdfDoc.registerObject((PDFObject)pageResources);
        }
        PDFFormXObject form = this.pdfDoc.addFormXObject(null, pageStream, pageResources.makeReference(), key);
        HashSet<String> page2Form = new HashSet<String>(Arrays.asList("Group", "LastModified", "Metadata"));
        this.transferDict(page.getCOSObject(), pageStream, page2Form, true);
        AffineTransform at = form.getMatrix();
        PDRectangle mediaBox = page.getMediaBox();
        PDRectangle cropBox = page.getCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int rotation = PDFUtil.getNormalizedRotation(page);
        at.scale(1.0f / viewBox.getWidth(), 1.0f / viewBox.getHeight());
        at.translate(mediaBox.getLowerLeftX() - viewBox.getLowerLeftX(), mediaBox.getLowerLeftY() - viewBox.getLowerLeftY());
        switch (rotation) {
            case 90: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(0.0, viewBox.getWidth());
                at.rotate(-1.5707963267948966);
                break;
            }
            case 180: {
                at.translate(viewBox.getWidth(), viewBox.getHeight());
                at.rotate(-Math.PI);
                break;
            }
            case 270: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(viewBox.getHeight(), 0.0);
                at.rotate(-4.71238898038469);
                break;
            }
        }
        form.setMatrix(at);
        form.setBBox((Rectangle2D)new Rectangle2D.Float(viewBox.getLowerLeftX(), viewBox.getLowerLeftY(), viewBox.getUpperRightX(), viewBox.getUpperRightY()));
        return form;
    }

    private COSDictionary getResources(PDPage page) {
        PDResources res = page.getResources();
        if (res == null) {
            return new COSDictionary();
        }
        return res.getCOSObject();
    }

    private void mergeXObj(COSDictionary sourcePageResources, FontInfo fontinfo, UniqueName uniqueName) throws IOException {
        COSDictionary xobj = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.XOBJECT);
        if (xobj != null && this.pdfDoc.isMergeFontsEnabled()) {
            for (Map.Entry i : xobj.entrySet()) {
                MergeFontsPDFWriter writer;
                String c;
                COSDictionary src;
                COSObject v = (COSObject)i.getValue();
                COSStream stream = (COSStream)v.getObject();
                COSDictionary res = (COSDictionary)stream.getDictionaryObject(COSName.RESOURCES);
                if (res == null || (src = (COSDictionary)res.getDictionaryObject(COSName.FONT)) == null) continue;
                COSDictionary target = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.FONT);
                if (target == null) {
                    sourcePageResources.setItem(COSName.FONT, (COSBase)src);
                } else {
                    for (Map.Entry entry : src.entrySet()) {
                        if (target.keySet().contains(entry.getKey())) continue;
                        target.setItem(uniqueName.getName((COSName)entry.getKey()), (COSBase)entry.getValue());
                    }
                }
                if ((c = ((PDFWriter)(writer = new MergeFontsPDFWriter(src, fontinfo, uniqueName, this.parentFonts, 0))).writeText(new PDStream(stream))) == null) continue;
                stream.removeItem(COSName.FILTER);
                this.newXObj.put((COSName)i.getKey(), c);
                for (Object e : src.keySet().toArray()) {
                    COSName name = (COSName)e;
                    src.setItem(uniqueName.getName(name), src.getItem(name));
                    src.removeItem(name);
                }
            }
        }
    }

    private void updateXObj(COSDictionary sourcePageResources, PDFDictionary pageResources) throws IOException {
        COSDictionary xobj = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.XOBJECT);
        if (xobj != null && this.pdfDoc.isMergeFontsEnabled()) {
            PDFDictionary target = (PDFDictionary)pageResources.get("XObject");
            for (COSName entry : xobj.keySet()) {
                if (!this.newXObj.containsKey(entry)) continue;
                PDFStream s = (PDFStream)target.get(this.uniqueName.getName(entry));
                s.setData(this.newXObj.get(entry).getBytes("ISO-8859-1"));
                PDFDictionary xobjr = (PDFDictionary)s.get("Resources");
                xobjr.put("Font", pageResources.get("Font"));
            }
        }
    }

    private void transferPageDict(COSDictionary srcPgFonts, UniqueName uniqueName, COSDictionary sourcePageResources) throws IOException {
        if (srcPgFonts != null) {
            for (Map.Entry f : srcPgFonts.entrySet()) {
                String name = uniqueName.getName((COSName)f.getKey());
                this.targetPage.getPDFResources().addFont(name, (PDFDictionary)this.cloneForNewDocument(f.getValue()));
            }
        }
        for (Map.Entry e : sourcePageResources.entrySet()) {
            this.transferDict(e, uniqueName);
        }
    }

    private void transferDict(Map.Entry<COSName, COSBase> dict, UniqueName uniqueName) throws IOException {
        COSBase src = dict.getValue() instanceof COSObject ? ((COSObject)dict.getValue()).getObject() : dict.getValue();
        if (dict.getKey() != COSName.FONT && src instanceof COSDictionary) {
            String name = dict.getKey().getName();
            PDFDictionary newDict = (PDFDictionary)this.targetPage.getPDFResources().get(name);
            if (newDict == null) {
                newDict = new PDFDictionary((PDFObject)this.targetPage.getPDFResources());
            }
            COSDictionary srcDict = (COSDictionary)src;
            for (Map.Entry v : srcDict.entrySet()) {
                newDict.put(uniqueName.getName((COSName)v.getKey()), this.cloneForNewDocument(v.getValue()));
            }
            this.targetPage.getPDFResources().put(name, (Object)newDict);
        }
    }

    private void bindOptionalContent(PDDocument sourceDoc) throws IOException {
    }

    private void handleAnnotations(PDDocument sourceDoc, PDPage page, AffineTransform at, Rectangle pos) throws IOException {
        PDFArray clonedFields;
        PDDocumentCatalog srcCatalog = sourceDoc.getDocumentCatalog();
        PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
        List pageAnnotations = page.getAnnotations();
        if (srcAcroForm == null && pageAnnotations.isEmpty()) {
            return;
        }
        PDFBoxAdapterUtil.moveAnnotations(page, pageAnnotations, at, pos);
        COSObject cosPage = null;
        COSDictionary parentDic = (COSDictionary)page.getCOSObject().getDictionaryObject(COSName.PARENT, COSName.P);
        COSArray kids = (COSArray)parentDic.getDictionaryObject(COSName.KIDS);
        for (int i = 0; i < kids.size(); ++i) {
            COSObject kid = (COSObject)kids.get(i);
            if (!this.pageNumbers.containsKey(i)) {
                PDFArray a = new PDFArray();
                a.add(null);
                this.pdfDoc.assignObjectNumber((PDFObject)a);
                this.pdfDoc.addTrailerObject((PDFObject)a);
                this.pageNumbers.put(i, a);
            }
            this.cacheClonedObject(kid, this.pageNumbers.get(i));
            if (kid.getObject() != page.getCOSObject()) continue;
            cosPage = kid;
        }
        if (cosPage == null) {
            throw new IOException("Illegal PDF. Page not part of parent page node.");
        }
        Set<?> fields = this.copyAnnotations(page, srcAcroForm);
        boolean formAlreadyCopied = this.getCachedClone(srcAcroForm) != null;
        PDFRoot catalog = this.pdfDoc.getRoot();
        PDFDictionary destAcroForm = (PDFDictionary)catalog.get(COSName.ACRO_FORM.getName());
        if (!formAlreadyCopied && destAcroForm == null) {
            if (srcAcroForm != null) {
                List<COSName> exclude = Collections.singletonList(COSName.FIELDS);
                destAcroForm = (PDFDictionary)this.cloneForNewDocument(srcAcroForm, srcAcroForm, exclude);
            } else {
                destAcroForm = new PDFDictionary((PDFObject)this.pdfDoc.getRoot());
            }
            this.pdfDoc.assignObjectNumber((PDFObject)destAcroForm);
            this.pdfDoc.addTrailerObject((PDFObject)destAcroForm);
            catalog.put(COSName.ACRO_FORM.getName(), (Object)destAcroForm);
        }
        if ((clonedFields = (PDFArray)destAcroForm.get(COSName.FIELDS.getName())) == null) {
            clonedFields = new PDFArray();
            destAcroForm.put(COSName.FIELDS.getName(), (Object)clonedFields);
        }
        for (Object field : fields) {
            if (field instanceof COSBase) {
                field = this.cloneForNewDocument(field, field, Arrays.asList(COSName.KIDS));
            }
            if (clonedFields.contains(field)) continue;
            clonedFields.add(field);
        }
    }

    private Set<?> copyAnnotations(PDPage page, PDAcroForm srcAcroForm) throws IOException {
        COSArray annots = (COSArray)page.getCOSObject().getDictionaryObject(COSName.ANNOTS);
        if (annots != null) {
            for (COSBase annotBase : annots) {
                PDFObject clonedAnnot;
                ArrayList<COSName> exclude = new ArrayList<COSName>();
                exclude.add(COSName.P);
                if (annotBase instanceof COSObject) {
                    COSObject annot = (COSObject)annotBase;
                    this.handleAnnotations.load(annot, srcAcroForm);
                    if (((COSDictionary)annot.getObject()).getItem(COSName.STRUCT_PARENT) != null) {
                        exclude.add(COSName.PARENT);
                    }
                }
                if ((clonedAnnot = (PDFObject)new PDFCloner(this, this.pdfDoc.isMergeFormFieldsEnabled()).cloneForNewDocument(annotBase, annotBase, exclude)) instanceof PDFDictionary) {
                    this.handleAnnotations.cloneAnnotParent(annotBase, (PDFDictionary)clonedAnnot, exclude);
                    clonedAnnot.setParent((PDFObject)this.targetPage);
                    PDFBoxAdapterUtil.updateAnnotationLink((PDFDictionary)clonedAnnot);
                }
                this.targetPage.addAnnotation(clonedAnnot);
            }
        }
        return this.handleAnnotations.getFields();
    }
}

