/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;
import net.sf.xslthl.WholeHighlighter;
import net.sf.xslthl.highlighters.xml.ElementPrefix;
import net.sf.xslthl.highlighters.xml.ElementSet;
import net.sf.xslthl.highlighters.xml.RealElementSet;

public class XMLHighlighter
extends WholeHighlighter {
    static final Character APOSTROPHE = Character.valueOf('\'');
    static final Character EQUALS = Character.valueOf('=');
    static final Character EXCLAMATION_MARK = Character.valueOf('!');
    static final Character GREATER_THAN = Character.valueOf('>');
    static final Character HYPHEN = Character.valueOf('-');
    static final Character LESS_THAN = Character.valueOf('<');
    static final Character QUESTION_MARK = Character.valueOf('?');
    static final Character QUOTE = Character.valueOf('\"');
    static final Character SLASH = Character.valueOf('/');
    protected Collection<ElementSet> elementSets = new HashSet<ElementSet>();
    protected String styleElement = "tag";
    protected String styleAttribute = "attribute";
    protected String styleValue = "value";
    protected String stylePi = "directive";
    protected String styleComment = "comment";
    protected String styleDoctype = "doctype";

    protected String getStyleForTagName(String tagName) {
        for (ElementSet es : this.elementSets) {
            if (!es.matches(tagName)) continue;
            return es.getStyle();
        }
        return null;
    }

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        if (params != null) {
            this.styleAttribute = params.getParam("styleAttribute", this.styleAttribute);
            this.styleComment = params.getParam("styleComment", this.styleComment);
            this.styleDoctype = params.getParam("styleDoctype", this.styleDoctype);
            this.styleElement = params.getParam("styleElement", this.styleElement);
            this.stylePi = params.getParam("stylePi", this.stylePi);
            this.styleValue = params.getParam("styleValue", this.styleValue);
            params.getMultiParams("elementSet", this.elementSets, new Params.ParamsLoader<RealElementSet>(){

                @Override
                public RealElementSet load(Params params) throws HighlighterConfigurationException {
                    return new RealElementSet(params);
                }
            });
            params.getMultiParams("elementPrefix", this.elementSets, new Params.ParamsLoader<ElementPrefix>(){

                @Override
                public ElementPrefix load(Params params) throws HighlighterConfigurationException {
                    return new ElementPrefix(params);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    void readTagContent(CharIter in, List<Block> out) {
        while (!(in.finished() || XMLHighlighter.GREATER_THAN.equals(in.current()) || XMLHighlighter.SLASH.equals(in.current()))) {
            block8: {
                if (Character.isWhitespace(in.current().charValue())) break block8;
                if (in.isMarked()) {
                    out.add(in.markedToBlock());
                }
                while (!(in.finished() || XMLHighlighter.EQUALS.equals(in.current()) || Character.isWhitespace(in.current().charValue()))) {
                    in.moveNext();
                }
                out.add(in.markedToStyledBlock(this.styleAttribute));
                while (!in.finished() && Character.isWhitespace(in.current().charValue())) {
                    in.moveNext();
                }
                if (in.finished() || !XMLHighlighter.EQUALS.equals(in.current())) continue;
                in.moveNext();
                while (!in.finished() && Character.isWhitespace(in.current().charValue())) {
                    in.moveNext();
                }
                out.add(in.markedToBlock());
                if (in.finished() || !XMLHighlighter.QUOTE.equals(in.current()) && !XMLHighlighter.APOSTROPHE.equals(in.current())) ** GOTO lbl33
                boundary = in.current();
                in.moveNext();
                while (!in.finished() && !boundary.equals(in.current())) {
                    in.moveNext();
                }
                if (!in.finished()) {
                    in.moveNext();
                }
                out.add(in.markedToStyledBlock(this.styleValue));
                continue;
lbl-1000:
                // 1 sources

                {
                    in.moveNext();
lbl33:
                    // 2 sources

                    ** while (!in.finished() && !XMLHighlighter.GREATER_THAN.equals((Object)in.current()) && !XMLHighlighter.SLASH.equals((Object)in.current()) && !Character.isWhitespace((char)in.current().charValue()))
                }
lbl34:
                // 1 sources

                out.add(in.markedToStyledBlock(this.styleValue));
                continue;
            }
            in.moveNext();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        while (!in.finished()) {
            block26: {
                if (!XMLHighlighter.LESS_THAN.equals(in.current())) break block26;
                out.add(in.markedToBlock());
                in.moveNext();
                if (!in.hasNext()) continue;
                if (XMLHighlighter.SLASH.equals(in.current())) {
                    while (!in.finished() && !XMLHighlighter.GREATER_THAN.equals(in.current())) {
                        in.moveNext();
                    }
                    style = this.getStyleForTagName(in.getMarked().trim().substring(2));
                    in.moveNext();
                    if (style != null) {
                        out.add(in.markedToStyledBlock(style));
                        continue;
                    }
                    out.add(in.markedToStyledBlock(this.styleElement));
                    continue;
                }
                if (XMLHighlighter.QUESTION_MARK.equals(in.current())) {
                    while (!(in.finished() || XMLHighlighter.GREATER_THAN.equals(in.current()) && XMLHighlighter.QUESTION_MARK.equals(in.prev()))) {
                        in.moveNext();
                    }
                    in.moveNext();
                    out.add(in.markedToStyledBlock(this.stylePi));
                    continue;
                }
                if (XMLHighlighter.EXCLAMATION_MARK.equals(in.current()) && XMLHighlighter.HYPHEN.equals(in.next()) && XMLHighlighter.HYPHEN.equals(in.next(2))) {
                    while (!(in.finished() || XMLHighlighter.GREATER_THAN.equals(in.current()) && XMLHighlighter.HYPHEN.equals(in.prev()) && XMLHighlighter.HYPHEN.equals(in.prev(2)))) {
                        in.moveNext();
                    }
                    in.moveNext();
                    out.add(in.markedToStyledBlock(this.styleComment));
                    continue;
                }
                if (XMLHighlighter.EXCLAMATION_MARK.equals(in.current()) && in.startsWith("[CDATA[", 1)) {
                    in.moveNext(8);
                    out.add(in.markedToStyledBlock(this.styleElement));
                    idx = in.indexOf("]]>");
                    if (idx == -1) {
                        in.moveToEnd();
                    } else {
                        in.moveNext(idx);
                    }
                    out.add(in.markedToBlock());
                    if (idx == -1) continue;
                    in.moveNext(3);
                    out.add(in.markedToStyledBlock(this.styleElement));
                    continue;
                }
                if (!XMLHighlighter.EXCLAMATION_MARK.equals(in.current()) || !in.startsWith("DOCTYPE", 1)) ** GOTO lbl66
                cnt = 1;
                while (!in.finished() && cnt > 0) {
                    if (in.current().equals(XMLHighlighter.GREATER_THAN)) {
                        --cnt;
                    } else if (in.current().equals(XMLHighlighter.LESS_THAN)) {
                        ++cnt;
                    }
                    in.moveNext();
                }
                out.add(in.markedToStyledBlock(this.styleDoctype));
                continue;
lbl-1000:
                // 1 sources

                {
                    in.moveNext();
lbl66:
                    // 2 sources

                    ** while (!in.finished() && !XMLHighlighter.GREATER_THAN.equals((Object)in.current()) && !XMLHighlighter.SLASH.equals((Object)in.current()) && !Character.isWhitespace((char)in.current().charValue()))
                }
lbl67:
                // 1 sources

                style = this.getStyleForTagName(in.getMarked().trim().substring(1));
                shortTag = false;
                cnt = 0;
                while (!in.finished() && !XMLHighlighter.GREATER_THAN.equals(in.current()) && !XMLHighlighter.SLASH.equals(in.current()) && Character.isWhitespace(in.current().charValue())) {
                    in.moveNext();
                    ++cnt;
                }
                if (!in.finished()) {
                    if (XMLHighlighter.SLASH.equals(in.current())) {
                        in.moveNext();
                        ++cnt;
                    }
                    if (XMLHighlighter.GREATER_THAN.equals(in.current())) {
                        in.moveNext();
                        shortTag = true;
                    } else {
                        in.moveNext(-cnt);
                    }
                }
                if (style != null) {
                    out.add(in.markedToStyledBlock(style));
                } else {
                    out.add(in.markedToStyledBlock(this.styleElement));
                }
                if (shortTag || in.finished() || !Character.isWhitespace(in.current().charValue())) continue;
                this.readTagContent(in, out);
                if (in.finished()) continue;
                if (XMLHighlighter.SLASH.equals(in.current())) {
                    in.moveNext();
                }
                in.moveNext();
                if (style != null) {
                    out.add(in.markedToStyledBlock(style));
                    continue;
                }
                out.add(in.markedToStyledBlock(this.styleElement));
                continue;
            }
            in.moveNext();
        }
        if (in.isMarked()) {
            out.add(in.markedToBlock());
        }
        return false;
    }

    @Override
    public String getDefaultStyle() {
        return "xml";
    }
}

