/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.xslthl.Block;
import net.sf.xslthl.Config;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.StyledBlock;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xpath.NodeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectorXalan {
    protected static NodeList highlight(ExpressionContext c, String source, MainHighlighter hl, Config config) throws Exception {
        NodeSet list = new NodeSet();
        List<Block> l = hl.highlight(source);
        for (Block b : l) {
            Node elm;
            if (b.isStyled()) {
                elm = DocumentInstance.doc.createElementNS(config.uri, ((StyledBlock)b).getStyle());
                elm.setTextContent(b.getText());
            } else {
                elm = DocumentInstance.doc.createTextNode(b.getText());
            }
            list.addElement(elm);
        }
        return list;
    }

    public static final NodeList highlight(ExpressionContext context, String hlCode, NodeList nodes) {
        return ConnectorXalan.highlight(context, hlCode, nodes, null);
    }

    public static final NodeList highlight(ExpressionContext context, String hlCode, NodeList nodes, String configFilename) {
        try {
            Config c = Config.getInstance(configFilename);
            MainHighlighter hl = c.getMainHighlighter(hlCode);
            NodeSet list = new NodeSet();
            int i = 0;
            while (i < nodes.getLength()) {
                Node n = nodes.item(i);
                NodeList childs = n.getChildNodes();
                int j = 0;
                while (j < childs.getLength()) {
                    Node m = childs.item(j);
                    if (m.getNodeType() == 3) {
                        if (hl != null) {
                            list.addNodes(ConnectorXalan.highlight(context, m.getNodeValue(), hl, c));
                        } else {
                            list.addNode((Node)DocumentInstance.doc.createTextNode(m.getNodeValue()));
                        }
                    } else {
                        list.addNode(m);
                    }
                    ++j;
                }
                ++i;
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class DocumentInstance {
        private static final Document doc;

        static {
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        private DocumentInstance() {
        }
    }
}

