/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.xslthl.FilteredElementIterator;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.Params;
import net.sf.xslthl.Version;
import net.sf.xslthl.highlighters.AnnotationHighlighter;
import net.sf.xslthl.highlighters.HTMLHighlighter;
import net.sf.xslthl.highlighters.HeredocHighlighter;
import net.sf.xslthl.highlighters.HexaDecimalHighlighter;
import net.sf.xslthl.highlighters.KeywordsHighlighter;
import net.sf.xslthl.highlighters.MultilineCommentHighlighter;
import net.sf.xslthl.highlighters.NestedMultilineCommentHighlighter;
import net.sf.xslthl.highlighters.NumberHighlighter;
import net.sf.xslthl.highlighters.OnelineCommentHighlighter;
import net.sf.xslthl.highlighters.RegexHighlighterEx;
import net.sf.xslthl.highlighters.StringHighlighter;
import net.sf.xslthl.highlighters.WordHighlighter;
import net.sf.xslthl.highlighters.XMLHighlighter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Config {
    public static final String CONFIG_PROPERTY = "xslthl.config";
    @Deprecated
    public static final String VERBOSE_LOADING_PROPERTY = "xslthl.config.verbose";
    public static final String LOGLEVEL_PROPERTY = "xslthl.loglevel";
    public static final String NO_EXTERNAL_PROPERTY = "xslthl.noexternal";
    private static final Map<String, Config> instances = new HashMap<String, Config>();
    public static final Map<String, Class<? extends Highlighter>> highlighterClasses = new HashMap<String, Class<? extends Highlighter>>();
    public static final String PLUGIN_PREFIX = "java:";
    protected String prefix = "http://xslthl.sf.net";
    protected String uri = "xslthl";
    protected Map<String, MainHighlighter> highlighters = new HashMap<String, MainHighlighter>();
    protected Logger logger = Logger.getLogger("net.sf.xslthl");
    @Deprecated
    protected boolean verbose;

    static {
        highlighterClasses.put("multiline-comment", MultilineCommentHighlighter.class);
        highlighterClasses.put("nested-multiline-comment", NestedMultilineCommentHighlighter.class);
        highlighterClasses.put("oneline-comment", OnelineCommentHighlighter.class);
        highlighterClasses.put("string", StringHighlighter.class);
        highlighterClasses.put("heredoc", HeredocHighlighter.class);
        highlighterClasses.put("keywords", KeywordsHighlighter.class);
        highlighterClasses.put("annotation", AnnotationHighlighter.class);
        highlighterClasses.put("regex", RegexHighlighterEx.class);
        highlighterClasses.put("word", WordHighlighter.class);
        highlighterClasses.put("number", NumberHighlighter.class);
        highlighterClasses.put("hexnumber", HexaDecimalHighlighter.class);
        highlighterClasses.put("xml", XMLHighlighter.class);
        highlighterClasses.put("html", HTMLHighlighter.class);
    }

    public static Config getInstance() {
        return Config.getInstance(null);
    }

    public static Config getInstance(String filename) {
        String key;
        String string = key = filename == null ? "" : filename;
        if (!instances.containsKey(key)) {
            Config conf = new Config(filename);
            instances.put(key, conf);
        }
        return instances.get(key);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public MainHighlighter getMainHighlighter(String id) {
        if (id != null && id.length() > 0 && !this.highlighters.containsKey(id) && !Boolean.getBoolean(NO_EXTERNAL_PROPERTY)) {
            String uri = null;
            try {
                URI location = new URI(id);
                if (location.getScheme() != null) {
                    uri = location.toString();
                }
            }
            catch (URISyntaxException location) {
                // empty catch block
            }
            if (uri == null) {
                File floc = new File(id);
                if (floc.getAbsoluteFile().exists()) {
                    uri = floc.getAbsoluteFile().toURI().toString();
                } else {
                    this.logger.info(String.format("%s is not an known language id, valid URI, or existing file name", id));
                }
            }
            if (uri != null) {
                try {
                    this.logger.info(String.format("Loading external highlighter from %s", uri.toString()));
                    MainHighlighter hl = this.loadHl(id, uri);
                    this.highlighters.put(id, hl);
                    return hl;
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, String.format("Unable to load highlighter from %s: %s", id, e.getMessage()), e);
                }
            }
        }
        return this.highlighters.get(id);
    }

    protected MainHighlighter loadHl(String id, String filename) throws Exception {
        MainHighlighter main = new MainHighlighter(id, filename);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(filename);
        HashSet<String> tagNames = new HashSet<String>();
        tagNames.add("highlighter");
        tagNames.add("wholehighlighter");
        this.createHighlighters(main, new FilteredElementIterator(doc.getDocumentElement(), tagNames));
        return main;
    }

    protected void createHighlighters(MainHighlighter main, Iterator<Element> elements) {
        while (elements.hasNext()) {
            Element hl = elements.next();
            Params params = new Params(hl);
            String type = hl.getAttribute("type");
            try {
                Class<? extends Highlighter> hlClass = highlighterClasses.get(type);
                if (hlClass == null && type.startsWith(PLUGIN_PREFIX)) {
                    hlClass = this.loadPlugin(main, type, hl.getAttribute("classpath"));
                }
                if (hlClass != null) {
                    Highlighter hlinstance = hlClass.newInstance();
                    hlinstance.init(params);
                    main.add(hlinstance);
                    continue;
                }
                this.logger.severe(String.format("Unknown highlighter: %s", type));
            }
            catch (HighlighterConfigurationException e) {
                this.logger.log(Level.SEVERE, String.format("Invalid configuration for highlighter %s: %s", type, e.getMessage()), e);
            }
            catch (InstantiationException e) {
                this.logger.log(Level.SEVERE, String.format("Error constructing highlighter %s: %s", type, e.getMessage()), e);
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, String.format("IError constructing highlighter %s: %s", type, e.getMessage()), e);
            }
        }
    }

    protected Class<? extends Highlighter> loadPlugin(MainHighlighter main, String type, String classpath) {
        ClassLoader cl = Config.class.getClassLoader();
        if (classpath != null && classpath.length() > 0) {
            String[] paths = classpath.split(";");
            final ArrayList<URL> urls = new ArrayList<URL>();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if ((path = path.trim()).length() != 0) {
                    try {
                        URL url;
                        if (main.getFilename() == null) {
                            url = new URL(path);
                        } else {
                            URL base = new URL(main.getFilename());
                            url = new URL(base, path);
                        }
                        urls.add(url);
                    }
                    catch (MalformedURLException e) {
                        this.logger.log(Level.WARNING, String.format("Invalid classpath entry %s: %s", path, e.getMessage()), e);
                    }
                }
                ++n2;
            }
            if (urls.size() > 0) {
                final ClassLoader parentCl = cl;
                PrivilegedAction<URLClassLoader> getCl = new PrivilegedAction<URLClassLoader>(){

                    @Override
                    public URLClassLoader run() {
                        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentCl);
                    }
                };
                try {
                    cl = AccessController.doPrivileged(getCl);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, String.format("Unable to create class loader with urls %s. %s", urls, e.getMessage()), e);
                    return null;
                }
            }
        }
        try {
            String className = type.substring(PLUGIN_PREFIX.length());
            Class<?> tmp = cl.loadClass(className);
            if (Highlighter.class.isAssignableFrom(tmp)) {
                return tmp.asSubclass(Highlighter.class);
            }
            this.logger.log(Level.SEVERE, String.format("Class %s is not a subclass of %s", tmp.getName(), Highlighter.class.getName()));
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, String.format("Unable to resolve highlighter class: %s", e.getMessage()), e);
        }
        return null;
    }

    protected Config() {
        this(null);
    }

    protected Config(String configFilename) {
        Level logLevel = Level.WARNING;
        try {
            logLevel = Level.parse(System.getProperty(LOGLEVEL_PROPERTY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.setLevel(logLevel);
        this.logger.info("Initializing xslthl " + Version.getVersion());
        this.loadConfiguration(configFilename);
    }

    protected void loadConfiguration(String configFilename) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            if (configFilename == null || "".equals(configFilename)) {
                this.logger.config("No config file specified, falling back to default behavior");
                configFilename = System.getProperty(CONFIG_PROPERTY) != null ? System.getProperty(CONFIG_PROPERTY) : "xslthl-config.xml";
            }
            this.logger.info(String.format("Loading Xslthl configuration from %s", configFilename));
            Document doc = builder.parse(configFilename);
            NodeList hls = doc.getDocumentElement().getElementsByTagName("highlighter");
            HashMap<String, MainHighlighter> fileMapping = new HashMap<String, MainHighlighter>();
            int i = 0;
            while (i < hls.getLength()) {
                String filename;
                String absFilename;
                Element hl = (Element)hls.item(i);
                String id = hl.getAttribute("id");
                if (this.highlighters.containsKey(id)) {
                    this.logger.warning(String.format("Highlighter with id '%s' already exists!", id));
                }
                if (fileMapping.containsKey(absFilename = new URL(new URL(configFilename), filename = hl.getAttribute("file")).toString())) {
                    this.logger.config(String.format("Reusing loaded highlighter for %s from %s", id, absFilename));
                    this.highlighters.put(id, (MainHighlighter)fileMapping.get(absFilename));
                } else {
                    this.logger.info(String.format("Loading %s highligter from %s", id, absFilename));
                    try {
                        MainHighlighter mhl = this.loadHl(id, absFilename);
                        this.highlighters.put(id, mhl);
                        fileMapping.put(absFilename, mhl);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, String.format("Failed to load highlighter from %s: %s", absFilename, e.getMessage()), e);
                    }
                }
                ++i;
            }
            NodeList prefixNode = doc.getDocumentElement().getElementsByTagName("namespace");
            if (prefixNode.getLength() == 1) {
                Element e = (Element)prefixNode.item(0);
                this.prefix = e.getAttribute("prefix");
                this.uri = e.getAttribute("uri");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, String.format("Cannot read configuration %s: %s", configFilename, e.getMessage()), e);
        }
        if (!this.highlighters.containsKey("xml")) {
            MainHighlighter xml = new MainHighlighter("xml", null);
            xml.add(new XMLHighlighter());
            this.highlighters.put("xml", xml);
        }
        if (!this.highlighters.containsKey("html")) {
            MainHighlighter html = new MainHighlighter("html", null);
            html.add(new HTMLHighlighter());
            this.highlighters.put("html", html);
        }
    }
}

