/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.keywords;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.indexer.keywords.IKeywordsRepository;

public class KeywordsRepository
implements IKeywordsRepository {
    private static final Logger logger = LoggerFactory.getLogger((String)KeywordsRepository.class.getName());
    private final List<KeywordInfo> keywordsInfos = new ArrayList<KeywordInfo>();
    private final HashMap<String, List<Integer>> phrasesMap = new HashMap();
    private int phraseCount = 0;
    private final TreeSet<String> allPhrases = new TreeSet();
    private boolean enableRepository = true;
    private String languageCode;
    private File userDictionaryFile;
    private boolean userMessageDisplayed;

    @Override
    public void addKeyword(String keyword) {
        this.registerKeyword(keyword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] cjkTokenizeWithLucene(String txt) {
        ArrayList<String> words = new ArrayList<String>();
        StringReader reader = new StringReader(txt);
        CJKAnalyzer analyzer = null;
        if ("zh".equals(this.languageCode) || "ko".equals(this.languageCode)) {
            analyzer = new CJKAnalyzer(null);
        } else if ("ja".equals(this.languageCode)) {
            try {
                UserDictionary userDict;
                block29: {
                    userDict = null;
                    if (this.userDictionaryFile != null) {
                        try {
                            userDict = UserDictionary.open((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.userDictionaryFile), "UTF8")));
                        }
                        catch (FileNotFoundException e) {
                            if (!this.userMessageDisplayed) {
                                logger.warn("WARNING: User dictionary file not found, indexing without any user dictionary: " + this.userDictionaryFile.getPath());
                            }
                        }
                        catch (IOException e) {
                            if (this.userMessageDisplayed) break block29;
                            logger.warn("WARNING: User dictionary file cannot be loaded because: " + e.getMessage());
                            logger.warn("WARNING: Indexing without any user dictionary: " + this.userDictionaryFile.getPath());
                        }
                    }
                }
                analyzer = new JapaneseAnalyzer(userDict, JapaneseTokenizer.Mode.SEARCH, null, JapaneseAnalyzer.getDefaultStopTags());
                if (!this.userMessageDisplayed) {
                    logger.info("INFO: Kuromoji analyzer detected and loaded, indexing WebHelp pages with Kuromoji analyzer.");
                    this.userMessageDisplayed = true;
                }
            }
            catch (IllegalArgumentException e) {
                if (!this.userMessageDisplayed) {
                    logger.warn("WARNING: Could not create Kuromoji analyzer: " + e.getMessage());
                    this.userMessageDisplayed = true;
                }
                analyzer = new CJKAnalyzer(null);
            }
            catch (SecurityException e) {
                if (!this.userMessageDisplayed) {
                    logger.warn("WARNING: Could not create Kuromoji analyzer: " + e.getMessage());
                    this.userMessageDisplayed = true;
                }
                analyzer = new CJKAnalyzer(null);
            }
        }
        if (analyzer != null) {
            TokenStream stream = null;
            try {
                stream = analyzer.tokenStream("indexer", (Reader)reader);
                CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                stream.reset();
                while (stream.incrementToken()) {
                    String word = termAtt.toString();
                    String toBeUpdated = word.toLowerCase();
                    words.add(toBeUpdated);
                }
            }
            catch (IOException e) {
                logger.error("Error creating token stream for language: " + this.languageCode);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.end();
                        stream.close();
                        analyzer.close();
                    }
                    catch (IOException e) {
                        logger.error("Error closing token stream for language: " + this.languageCode);
                    }
                }
            }
        } else {
            logger.error("Analyzer was not created when tokenize the documenation titles for search autocomplete. Language: " + this.languageCode);
        }
        return words.toArray(new String[0]);
    }

    private void registerKeyword(String keyword) {
        if (this.enableRepository) {
            String phraseNormalized = this.normalizeString(keyword);
            String phraseLowerCase = phraseNormalized.toLowerCase();
            if (phraseNormalized.length() > 0 && !this.allPhrases.contains(phraseLowerCase)) {
                String phID = "p" + this.phraseCount;
                ++this.phraseCount;
                this.allPhrases.add(phraseLowerCase);
                ArrayList<Integer> phraseWordIds = new ArrayList<Integer>();
                String[] words = phraseNormalized.split("(\\s)+");
                words = "zh".equals(this.languageCode) || "ko".equals(this.languageCode) || "ja".equals(this.languageCode) ? this.cjkTokenizeWithLucene(phraseNormalized) : phraseNormalized.split("(\\s)+");
                for (int i = 0; i < words.length; ++i) {
                    String w = words[i];
                    int wid = -1;
                    for (int j = 0; j < this.keywordsInfos.size(); ++j) {
                        KeywordInfo wi = this.keywordsInfos.get(j);
                        if (!wi.word.equalsIgnoreCase(w)) continue;
                        wid = j;
                        wi.phraseIDs.add(phID);
                        phraseWordIds.add(j);
                        break;
                    }
                    if (wid != -1) continue;
                    KeywordInfo wi = new KeywordInfo(w);
                    wi.addPhraseID(phID);
                    this.keywordsInfos.add(wi);
                    phraseWordIds.add(this.keywordsInfos.size() - 1);
                }
                this.phrasesMap.put(phID, phraseWordIds);
            }
        }
    }

    @Override
    public List<KeywordInfo> getKeywords() {
        return this.keywordsInfos;
    }

    @Override
    public Map<String, List<Integer>> getPhraseMap() {
        return this.phrasesMap;
    }

    @Override
    public void addTopicTitle(String title) {
        this.registerKeyword(title);
    }

    private String normalizeString(String toNormalize) {
        StringBuilder sb = new StringBuilder();
        toNormalize = toNormalize.trim();
        boolean firstWh = true;
        for (int i = 0; i < toNormalize.length(); ++i) {
            char charAt = toNormalize.charAt(i);
            if (Character.isWhitespace(charAt)) {
                if (!firstWh) continue;
                sb.append(charAt);
                firstWh = false;
                continue;
            }
            sb.append(charAt);
            firstWh = true;
        }
        return sb.toString();
    }

    @Override
    public void setEnableRepository(boolean enableRepository) {
        this.enableRepository = enableRepository;
    }

    @Override
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    @Override
    public void setUserDictionary(String userDictionaryPath) {
        this.userDictionaryFile = userDictionaryPath == null || userDictionaryPath.contains("${") ? null : new File(userDictionaryPath);
    }

    public static class KeywordInfo {
        public final String word;
        public final Set<String> phraseIDs;

        public KeywordInfo(String word) {
            this.word = word;
            this.phraseIDs = new LinkedHashSet<String>();
        }

        public void addPhraseID(String phID) {
            this.phraseIDs.add(phID);
        }
    }
}

