/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.js;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.indexer.js.JsFilesBuilder;
import ro.sync.exml.indexer.keywords.IKeywordsRepository;
import ro.sync.exml.indexer.keywords.KeywordsRepository;
import ro.sync.exml.indexer.score.ScoreRepository;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

public class WebHelpResponsiveJsFilesBuilder
extends JsFilesBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)WebHelpResponsiveJsFilesBuilder.class.getName());
    private static final String SEARCH_LINK_TO_PARENT_PROPERTIES_FILE_NAME = "search-link-to-parent.properties";
    private static final String MAP_STRING = "MAP";
    private static final int MAP_INDEX = -1;

    @Override
    public void writeHTMLInfoList(String fileO, List<IndexedFileInfo> list, boolean doStem) {
        Iterator<IndexedFileInfo> it = null;
        if (list == null) {
            return;
        }
        if (fileO == null) {
            return;
        }
        it = list.iterator();
        try (FileOutputStream fOut = new FileOutputStream(fileO);
             BufferedOutputStream bout = new BufferedOutputStream(fOut);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");){
            out.write("var htmlFileInfoList = [");
            while (it.hasNext()) {
                IndexedFileInfo tempInfo = it.next();
                String tempPath = tempInfo.getRelativePath().replace(File.separatorChar, '/');
                String tempTitle = tempInfo.getTitle();
                String tempShortdesc = tempInfo.getShortdesc();
                if (tempTitle != null) {
                    tempTitle = tempTitle.replaceAll("\\s+", " ");
                    tempTitle = this.escapeHtml(tempTitle);
                    tempTitle = this.escapeJavaScript(tempTitle);
                }
                if (tempShortdesc != null) {
                    tempShortdesc = this.escapeHtml(tempShortdesc);
                    tempShortdesc = this.escapeJavaScript(tempShortdesc);
                }
                if (tempShortdesc != null) {
                    String stripNonAlphabeticalChars = this.stripNonAlphabeticalChars(tempShortdesc);
                    out.write("\"" + tempPath + "@@@" + tempTitle + "@@@" + stripNonAlphabeticalChars + "...\"");
                } else {
                    out.write("\"" + tempPath + "@@@" + tempTitle + "@@@...\"");
                }
                if (!it.hasNext()) continue;
                out.write(",");
            }
            out.write("];\n");
            out.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writeIndex(String indexFileName, ScoreRepository sk, String indexerLanguage) {
        if (sk == null || indexFileName == null) {
            return;
        }
        File fileOut = new File(indexFileName);
        String stopwordsFile = fileOut.getParent() + File.separator + "stopwords" + fileOut.getName();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(stopwordsFile)), "UTF-8");){
            this.writeStopWords(out, sk);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        TreeMap<String, String> scores = sk.getScores();
        Iterator<String> wordsIterator = scores.keySet().iterator();
        int indexSize = scores.size();
        for (int i = 1; i <= 3; ++i) {
            String fOutName = fileOut.getParent() + File.separator + "index-" + i + fileOut.getName();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fOutName)), "UTF-8");){
                out.write("// Auto generated index for searching.\n");
                out.write("var index" + i + " = {");
                int count = 0;
                while (wordsIterator.hasNext()) {
                    String tstr = wordsIterator.next();
                    String tstrEscaped = tstr.replace("\\", "\\\\");
                    tstrEscaped = tstrEscaped.replace("\"", "\\\"");
                    String score = scores.get(tstr);
                    if (score != null && score.endsWith(";")) {
                        score = score.substring(0, score.length() - 1);
                    }
                    String indexEntry = "\"" + tstrEscaped + "\":" + score;
                    out.write(indexEntry);
                    if (indexSize / ++count < 3 && i < 3) break;
                    if (!wordsIterator.hasNext()) continue;
                    out.write(",");
                }
                out.write("};\n");
                out.flush();
                continue;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("Generated index files are located in " + fileOut.getParent());
    }

    @Override
    public void writeKeywords(String keywordsFileName, IKeywordsRepository keywordsRepository) {
        if (keywordsFileName == null || keywordsRepository == null) {
            return;
        }
        File fileOut = new File(keywordsFileName);
        List<KeywordsRepository.KeywordInfo> keywords = keywordsRepository.getKeywords();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fileOut)), "UTF-8");){
            out.append("var keywords=[");
            Iterator<KeywordsRepository.KeywordInfo> iterator = keywords.iterator();
            while (iterator.hasNext()) {
                KeywordsRepository.KeywordInfo kw = iterator.next();
                out.append("{w:\"" + this.escapeJavaScript(kw.word) + "\",p:[");
                Iterator<String> phIdsIter = kw.phraseIDs.iterator();
                while (phIdsIter.hasNext()) {
                    String phID = phIdsIter.next();
                    out.append("\"" + phID + "\"");
                    if (!phIdsIter.hasNext()) continue;
                    out.append(",");
                }
                out.append("]}");
                if (!iterator.hasNext()) continue;
                out.append(",");
            }
            out.append("];");
            out.append("\nvar ph={};\n");
            Map<String, List<Integer>> phraseMap = keywordsRepository.getPhraseMap();
            for (String phID : phraseMap.keySet()) {
                out.append("ph[\"" + phID + "\"]=");
                out.append(phraseMap.get(phID).toString());
                out.append(";\n");
            }
            out.append("var keywordsInfo = {\n    keywords: keywords,\n    ph: ph\n}\n");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error("Cannot write search keywords: " + e.getMessage());
        }
    }

    @Override
    public void writeStopWords(OutputStreamWriter osw, ScoreRepository sk) throws IOException {
        if (sk == null || osw == null) {
            logger.error("Cannot write stopwords, null parameter.");
            return;
        }
        osw.write("// Auto generated list of analyzer stop words that must be ignored by search.\n");
        osw.write("var stopwords = [");
        ArrayList<String> stopWords = sk.getStopWords();
        Iterator<String> iterator = stopWords.iterator();
        while (iterator.hasNext()) {
            String nextStopWord = iterator.next();
            osw.write("\"" + nextStopWord + "\"");
            if (!iterator.hasNext()) continue;
            osw.write(",");
        }
        osw.write("];\n");
        osw.flush();
    }

    @Override
    public void writeLinkToParent(File file, List<IndexedFileInfo> list, File parentDirectory) {
        if (list == null) {
            return;
        }
        if (file == null) {
            return;
        }
        Properties linkToParent = new Properties();
        File searchLinkToParentFile = new File(parentDirectory, SEARCH_LINK_TO_PARENT_PROPERTIES_FILE_NAME);
        try (FileInputStream in2 = new FileInputStream(searchLinkToParentFile);){
            linkToParent.load(in2);
        }
        catch (Exception in2) {
            // empty catch block
        }
        try (FileOutputStream fOut = new FileOutputStream(file);
             BufferedOutputStream bout = new BufferedOutputStream(fOut);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");){
            out.write("/*Maps current topic to its parent: \"topicIndex:parentIndex\". -1 represents the map.*/\n");
            out.write("var linkToParent = {");
            HashMap<String, Integer> topicTocIdsToIndex = new HashMap<String, Integer>();
            for (int i = 0; i < list.size(); ++i) {
                String topicTocID = list.get(i).getTopicTocID();
                if (topicTocID == null) continue;
                topicTocIdsToIndex.put(topicTocID, i);
            }
            Set<Map.Entry<Object, Object>> entrySet = linkToParent.entrySet();
            boolean firstEntry = true;
            for (Map.Entry<Object, Object> entry : entrySet) {
                Object topicTocID = entry.getKey();
                Object parentTocID = entry.getValue();
                Integer topicIndex = (Integer)topicTocIdsToIndex.get(topicTocID);
                StringBuilder sb = new StringBuilder();
                if (topicIndex == null) continue;
                sb.append(topicIndex).append(":");
                if (MAP_STRING.equals(parentTocID)) {
                    sb.append(-1);
                } else {
                    Integer parentTopicIDIndex = (Integer)topicTocIdsToIndex.get(parentTocID);
                    if (parentTopicIDIndex != null) {
                        sb.append(parentTopicIDIndex);
                    } else {
                        sb = null;
                    }
                }
                if (sb == null) continue;
                if (!firstEntry) {
                    out.write(",");
                } else {
                    firstEntry = false;
                }
                out.write(sb.toString());
            }
            out.write("};\n");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

