/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.edit.provider;

import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import ro.sync.emf.common.command.Command;
import ro.sync.emf.common.command.CommandWrapper;
import ro.sync.emf.common.command.CompoundCommand;
import ro.sync.emf.common.command.UnexecutableCommand;
import ro.sync.emf.common.notify.AdapterFactory;
import ro.sync.emf.common.notify.Notification;
import ro.sync.emf.common.notify.Notifier;
import ro.sync.emf.common.notify.impl.AdapterImpl;
import ro.sync.emf.common.util.BasicEList;
import ro.sync.emf.common.util.EList;
import ro.sync.emf.common.util.ResourceLocator;
import ro.sync.emf.common.util.UniqueEList;
import ro.sync.emf.ecore.EObject;
import ro.sync.emf.ecore.EReference;
import ro.sync.emf.ecore.EStructuralFeature;
import ro.sync.emf.ecore.util.FeatureMap;
import ro.sync.emf.ecore.util.FeatureMapUtil;
import ro.sync.emf.edit.command.AddCommand;
import ro.sync.emf.edit.command.CommandActionDelegate;
import ro.sync.emf.edit.command.CommandParameter;
import ro.sync.emf.edit.command.CreateChildCommand;
import ro.sync.emf.edit.command.RemoveCommand;
import ro.sync.emf.edit.command.SetCommand;
import ro.sync.emf.edit.domain.EditingDomain;
import ro.sync.emf.edit.provider.ComposeableAdapterFactory;
import ro.sync.emf.edit.provider.IEditingDomainItemProvider;
import ro.sync.emf.edit.provider.IItemPropertyDescriptor;
import ro.sync.emf.edit.provider.ITreeItemContentProvider;
import ro.sync.emf.edit.provider.IWrapperItemProvider;
import ro.sync.emf.edit.provider.ItemPropertyDescriptor;

public class ItemProviderAdapter
extends AdapterImpl
implements ResourceLocator {
    protected AdapterFactory adapterFactory;
    protected List<IItemPropertyDescriptor> itemPropertyDescriptors;
    protected List<EStructuralFeature> childrenFeatures;
    @Deprecated
    protected List<EReference> childrenReferences;
    protected List<Notifier> targets;
    protected Map<Object, ChildrenStore> childrenStoreMap;

    public ItemProviderAdapter(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public Object getEditableValue(Object object) {
        return object;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList<IItemPropertyDescriptor>();
        }
        return this.itemPropertyDescriptors;
    }

    public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyId) {
        for (IItemPropertyDescriptor itemPropertyDescriptor : this.getPropertyDescriptors(object)) {
            if (!propertyId.equals(itemPropertyDescriptor.getId(object)) && !propertyId.equals(itemPropertyDescriptor.getFeature(object))) continue;
            return itemPropertyDescriptor;
        }
        return null;
    }

    public Object getPropertyValue(Object object, String property) {
        return this.getPropertyDescriptor(object, property).getPropertyValue(object);
    }

    public boolean isPropertySet(Object object, String property) {
        return this.getPropertyDescriptor(object, property).isPropertySet(object);
    }

    public void resetPropertyValue(Object object, String property) {
        this.getPropertyDescriptor(object, property).resetPropertyValue(object);
    }

    public void setPropertyValue(Object object, String property, Object value) {
        this.getPropertyDescriptor(object, property).setPropertyValue(object, value);
    }

    public Collection<?> getElements(Object object) {
        return this.getChildren(object);
    }

    public Collection<?> getChildren(Object object) {
        ChildrenStore store = this.getChildrenStore(object);
        if (store != null) {
            return store.getChildren();
        }
        ArrayList<Object> result = store != null ? null : new ArrayList<Object>();
        EObject eObject = (EObject)object;
        for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
            if (eStructuralFeature.isMany()) {
                List children = (List)eObject.eGet(eStructuralFeature);
                int index = 0;
                for (Object unwrappedChild : children) {
                    Object child = this.wrap(eObject, eStructuralFeature, unwrappedChild, index);
                    if (store != null) {
                        store.getList(eStructuralFeature).add(child);
                    } else {
                        result.add(child);
                    }
                    ++index;
                }
                continue;
            }
            Object child = eObject.eGet(eStructuralFeature);
            if (child == null) continue;
            child = this.wrap(eObject, eStructuralFeature, child, -1);
            if (store != null) {
                store.setValue(eStructuralFeature, child);
                continue;
            }
            result.add(child);
        }
        return store != null ? store.getChildren() : result;
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, false);
    }

    protected boolean hasChildren(Object object, boolean optimized) {
        if (!optimized) {
            return !this.getChildren(object).isEmpty();
        }
        EObject eObject = (EObject)object;
        for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
            List children;
            if (!(eStructuralFeature.isMany() ? !(children = (List)eObject.eGet(eStructuralFeature)).isEmpty() : eObject.eGet(eStructuralFeature, false) != null)) continue;
            return true;
        }
        return false;
    }

    protected Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList<EStructuralFeature>();
        }
        return this.childrenFeatures;
    }

    @Deprecated
    protected Collection<? extends EReference> getChildrenReferences(Object object) {
        if (this.childrenReferences == null) {
            this.childrenReferences = new ArrayList<EReference>();
        }
        return this.childrenReferences;
    }

    private Collection<? extends EStructuralFeature> getAnyChildrenFeatures(Object object) {
        Collection<? extends EStructuralFeature> result = this.getChildrenFeatures(object);
        return result.isEmpty() ? this.getChildrenReferences(object) : result;
    }

    protected Object getFeatureValue(EObject object, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            return this.getReferenceValue(object, (EReference)feature);
        }
        return object.eGet(feature);
    }

    @Deprecated
    protected Object getReferenceValue(EObject object, EReference reference) {
        return object.eGet(reference);
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        EReference oldFeature = this.getChildReference(object, child);
        if (oldFeature != null) {
            return oldFeature;
        }
        for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(object)) {
            if (!this.isValidValue(object, child, eStructuralFeature)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    protected boolean isValidValue(Object object, Object value, EStructuralFeature feature) {
        if (feature.getEType().isInstance(value)) {
            if (FeatureMapUtil.isFeatureMap(feature)) {
                return FeatureMapUtil.getValidator(object instanceof EObject ? ((EObject)object).eClass() : feature.getEContainingClass(), feature).isValid(((FeatureMap.Entry)value).getEStructuralFeature());
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected EReference getChildReference(Object object, Object child) {
        if (child instanceof EObject) {
            for (EReference eReference : this.getChildrenReferences(object)) {
                if (!this.isValidValue(object, child, eReference)) continue;
                return eReference;
            }
        }
        return null;
    }

    protected Collection<? extends EStructuralFeature> getSetFeatures(Object object) {
        return Collections.emptyList();
    }

    protected EStructuralFeature getSetFeature(Object object, Object value) {
        for (EStructuralFeature eStructuralFeature : this.getSetFeatures(object)) {
            if (!this.isValidValue(object, value, eStructuralFeature)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public Object getParent(Object object) {
        EObject eObject = (EObject)object;
        Notifier result = eObject.eContainer();
        if (result == null) {
            result = eObject.eResource();
        }
        return result;
    }

    public String getText(Object object) {
        return object.toString();
    }

    public String getUpdateableText(Object object) {
        return this.getText(object);
    }

    public String crop(String text) {
        if (text != null) {
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (!Character.isISOControl(chars[i])) continue;
                return text.substring(0, i) + "...";
            }
        }
        return text;
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        EObject eObject = (EObject)object;
        ArrayList<Object> newChildDescriptors = new ArrayList<Object>();
        this.collectNewChildDescriptors(newChildDescriptors, object);
        if (sibling != null) {
            sibling = this.unwrap(sibling);
            Collection<? extends EStructuralFeature> childrenFeatures = this.getAnyChildrenFeatures(object);
            int siblingFeatureIndex = -1;
            int i = 0;
            block0: for (EStructuralFeature eStructuralFeature : childrenFeatures) {
                Object featureValue = eObject.eGet(eStructuralFeature);
                if (eStructuralFeature.isMany()) {
                    for (Object value : (Collection)featureValue) {
                        if (!this.isEquivalentValue(sibling, value)) continue;
                        siblingFeatureIndex = i;
                        break block0;
                    }
                } else if (this.isEquivalentValue(sibling, featureValue)) {
                    siblingFeatureIndex = i;
                    break;
                }
                ++i;
            }
            block2: for (EStructuralFeature eStructuralFeature : newChildDescriptors) {
                CommandParameter parameter;
                EStructuralFeature childFeature;
                if (!(eStructuralFeature instanceof CommandParameter) || (childFeature = (parameter = (CommandParameter)((Object)eStructuralFeature)).getEStructuralFeature()) == null || !childFeature.isMany()) continue;
                i = 0;
                for (Object e : (Collection)eObject.eGet(childFeature)) {
                    if (this.isEquivalentValue(sibling, e)) {
                        parameter.index = i + 1;
                        continue block2;
                    }
                    ++i;
                }
                if (siblingFeatureIndex == -1) continue;
                i = 0;
                for (EStructuralFeature eStructuralFeature2 : childrenFeatures) {
                    if (eStructuralFeature2 == childFeature) {
                        if (i <= siblingFeatureIndex) continue block2;
                        parameter.index = 0;
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        return newChildDescriptors;
    }

    protected boolean isEquivalentValue(Object value, Object referenceValue) {
        Object entryValue;
        if (value == referenceValue) {
            return true;
        }
        return value instanceof FeatureMap.Entry && (entryValue = ((FeatureMap.Entry)value).getValue()) == referenceValue;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        CommandParameter oldCommandParameter = commandParameter;
        commandParameter = this.unwrapCommandValues(commandParameter, commandClass);
        Command result = UnexecutableCommand.INSTANCE;
        if (commandClass == SetCommand.class) {
            result = this.createSetCommand(domain, commandParameter.getEOwner(), commandParameter.getEStructuralFeature() != null ? commandParameter.getEStructuralFeature() : this.getSetFeature(commandParameter.getEOwner(), commandParameter.getValue()), commandParameter.getValue(), commandParameter.getIndex());
        } else if (commandClass == RemoveCommand.class) {
            result = commandParameter.getEStructuralFeature() != null ? this.createRemoveCommand(domain, commandParameter.getEOwner(), commandParameter.getEStructuralFeature(), commandParameter.getCollection()) : this.factorRemoveCommand(domain, commandParameter);
        } else if (commandClass == AddCommand.class) {
            result = commandParameter.getEStructuralFeature() != null ? this.createAddCommand(domain, commandParameter.getEOwner(), commandParameter.getEStructuralFeature(), commandParameter.getCollection(), commandParameter.getIndex()) : this.factorAddCommand(domain, commandParameter);
        } else if (commandClass == CreateChildCommand.class) {
            CommandParameter newChildParameter = (CommandParameter)commandParameter.getValue();
            result = this.createCreateChildCommand(domain, commandParameter.getEOwner(), newChildParameter.getEStructuralFeature(), newChildParameter.getValue(), newChildParameter.getIndex(), commandParameter.getCollection());
        }
        return this.wrapCommand(result, object, commandClass, commandParameter, oldCommandParameter);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        if (index == -1) {
            return this.createSetCommand(domain, owner, feature, value);
        }
        return new SetCommand(domain, owner, feature, value, index);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        return new SetCommand(domain, owner, feature, value);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature instanceof EReference) {
            return this.createRemoveCommand(domain, owner, (EReference)feature, collection);
        }
        return new RemoveCommand(domain, owner, feature, collection);
    }

    @Deprecated
    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EReference feature, Collection<?> collection) {
        return new RemoveCommand(domain, owner, (EStructuralFeature)feature, collection);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature instanceof EReference) {
            return this.createAddCommand(domain, owner, (EReference)feature, collection, index);
        }
        return new AddCommand(domain, owner, feature, collection, index);
    }

    @Deprecated
    protected Command createAddCommand(EditingDomain domain, EObject owner, EReference feature, Collection<?> collection, int index) {
        return new AddCommand(domain, owner, (EStructuralFeature)feature, collection, index);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        if (feature instanceof EReference && value instanceof EObject) {
            return this.createCreateChildCommand(domain, owner, (EReference)feature, (EObject)value, index, collection);
        }
        return new CreateChildCommand(domain, owner, feature, value, index, collection);
    }

    @Deprecated
    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EReference feature, EObject value, int index, Collection<?> collection) {
        return new CreateChildCommand(domain, owner, (EStructuralFeature)feature, (Object)value, index, collection);
    }

    protected Command factorRemoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final EObject eObject = commandParameter.getEOwner();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        CompoundCommand removeCommand = new CompoundCommand(Integer.MAX_VALUE);
        block0: for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(eObject)) {
            Object value;
            if (eStructuralFeature.isMany()) {
                value = (List)this.getFeatureValue(eObject, eStructuralFeature);
                ArrayList childrenOfThisFeature = new ArrayList();
                ListIterator objects = list.listIterator();
                while (objects.hasNext()) {
                    Object o = objects.next();
                    if (!value.contains(o)) continue;
                    childrenOfThisFeature.add(o);
                    objects.remove();
                }
                if (childrenOfThisFeature.isEmpty()) continue;
                removeCommand.append(this.createRemoveCommand(domain, eObject, eStructuralFeature, childrenOfThisFeature));
                continue;
            }
            value = this.getFeatureValue(eObject, eStructuralFeature);
            ListIterator objects = list.listIterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                if (o != value) continue;
                Command setCommand = this.createSetCommand(domain, eObject, eStructuralFeature, null);
                removeCommand.append(new CommandWrapper(setCommand){
                    protected Collection<?> affected;

                    @Override
                    public void execute() {
                        super.execute();
                        this.affected = Collections.singleton(eObject);
                    }

                    @Override
                    public void undo() {
                        super.undo();
                        this.affected = Collections.singleton(value);
                    }

                    @Override
                    public void redo() {
                        super.redo();
                        this.affected = Collections.singleton(eObject);
                    }

                    @Override
                    public Collection<?> getResult() {
                        return Collections.singleton(value);
                    }

                    @Override
                    public Collection<?> getAffectedObjects() {
                        return this.affected;
                    }
                });
                objects.remove();
                continue block0;
            }
        }
        if (list.isEmpty()) {
            return removeCommand.unwrap();
        }
        removeCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        ListIterator children;
        Object firstChild;
        EStructuralFeature childFeature;
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final EObject eObject = commandParameter.getEOwner();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        int index = commandParameter.getIndex();
        CompoundCommand addCommand = new CompoundCommand(Integer.MAX_VALUE);
        while (!list.isEmpty() && (childFeature = this.getChildFeature(eObject, firstChild = (children = list.listIterator()).next())) != null) {
            if (childFeature.isMany()) {
                if (index != -1) {
                    for (EStructuralFeature eStructuralFeature : this.getAnyChildrenFeatures(eObject)) {
                        if (eStructuralFeature == childFeature) break;
                        if (eStructuralFeature.isMany()) {
                            index -= ((List)eObject.eGet(eStructuralFeature)).size();
                            continue;
                        }
                        if (eObject.eGet(eStructuralFeature) == null) continue;
                        --index;
                    }
                    if (index < 0) break;
                }
                ArrayList childrenOfThisFeature = new ArrayList();
                childrenOfThisFeature.add(firstChild);
                children.remove();
                while (children.hasNext()) {
                    Object e = children.next();
                    if (this.getChildFeature(eObject, e) != childFeature) continue;
                    childrenOfThisFeature.add(e);
                    children.remove();
                }
                addCommand.append(this.createAddCommand(domain, eObject, childFeature, childrenOfThisFeature, index));
                if (index >= childrenOfThisFeature.size()) {
                    index -= childrenOfThisFeature.size();
                    continue;
                }
                index = -1;
                continue;
            }
            if (eObject.eGet(childFeature) != null) break;
            Command setCommand = this.createSetCommand(domain, eObject, childFeature, firstChild);
            addCommand.append(new CommandWrapper(setCommand){
                protected Collection<?> affected;

                @Override
                public void execute() {
                    super.execute();
                    this.affected = Collections.singleton(firstChild);
                }

                @Override
                public void undo() {
                    super.undo();
                    this.affected = Collections.singleton(eObject);
                }

                @Override
                public void redo() {
                    super.redo();
                    this.affected = Collections.singleton(firstChild);
                }

                @Override
                public Collection<?> getResult() {
                    return Collections.singleton(firstChild);
                }

                @Override
                public Collection<?> getAffectedObjects() {
                    return this.affected;
                }
            });
            children.remove();
        }
        if (list.isEmpty()) {
            return addCommand.unwrap();
        }
        addCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public void setTarget(Notifier target) {
        if (this.target != null) {
            if (this.target != target) {
                if (this.targets == null) {
                    this.targets = new ArrayList<Notifier>();
                }
                this.targets.add(this.target);
                super.setTarget(target);
            }
        } else {
            super.setTarget(target);
        }
    }

    @Override
    public void unsetTarget(Notifier target) {
        if (target == this.target) {
            if (this.targets == null || this.targets.isEmpty()) {
                super.setTarget(null);
            } else {
                super.setTarget(this.targets.remove(this.targets.size() - 1));
            }
        } else if (this.targets != null) {
            this.targets.remove(target);
        }
        if (this.childrenStoreMap != null) {
            ChildrenStore childrenStore = this.childrenStoreMap.remove(target);
        }
    }

    public void dispose() {
        Notifier oldTarget = this.target;
        this.target = null;
        List<Notifier> oldTargets = this.targets;
        this.targets = null;
        if (oldTarget != null) {
            oldTarget.eAdapters().remove(this);
        }
        if (oldTargets != null) {
            for (Notifier otherTarget : oldTargets) {
                otherTarget.eAdapters().remove(this);
            }
        }
    }

    protected CommandParameter createChildParameter(Object feature, Object child) {
        return new CommandParameter(null, feature, child);
    }

    protected AdapterFactory getRootAdapterFactory() {
        if (this.adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        }
        return this.adapterFactory;
    }

    @Override
    public URL getBaseURL() {
        return null;
    }

    @Override
    public Object getImage(String key) {
        return null;
    }

    protected boolean shouldTranslate() {
        return true;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    @Override
    public String getString(String key, boolean translate) {
        return "";
    }

    @Override
    public String getString(String key, Object[] substitutions) {
        return "";
    }

    @Override
    public String getString(String key, Object[] substitutions, boolean translate) {
        return "";
    }

    protected String getString(String key, String s0) {
        return this.getString(key, s0, this.shouldTranslate());
    }

    protected String getString(String key, String s0, boolean translate) {
        return "";
    }

    protected String getString(String key, String s0, String s1) {
        return this.getString(key, s0, s1, this.shouldTranslate());
    }

    protected String getString(String key, String s0, String s1, boolean translate) {
        return "";
    }

    protected ChildrenStore getChildrenStore(Object object) {
        return this.childrenStoreMap == null ? null : this.childrenStoreMap.get(object);
    }

    protected Object wrap(EObject object, EStructuralFeature feature, Object value, int index) {
        Object wrapper;
        if (!feature.isMany() && index != -1) {
            System.out.println("Bad wrap index.");
            System.out.println("  object: " + object);
            System.out.println("  feature: " + feature);
            System.out.println("  value: " + value);
            System.out.println("  index: " + index);
            new IllegalArgumentException("Bad wrap index.").printStackTrace();
        }
        if ((wrapper = this.createWrapper(object, feature, value, index)) == null) {
            wrapper = value;
        }
        return wrapper;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        return value;
    }

    protected Object unwrap(Object object) {
        while (object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getValue();
        }
        return object;
    }

    protected void disposeWrapper(Object object) {
    }

    protected void disposeWrappers(List<?> objects) {
        for (Object object : objects) {
            this.disposeWrapper(object);
        }
    }

    protected void adjustWrapperIndex(Object object, int increment) {
        IWrapperItemProvider wrapper;
        int index;
        if (object instanceof IWrapperItemProvider && (index = (wrapper = (IWrapperItemProvider)object).getIndex()) != -1) {
            wrapper.setIndex(index + increment);
        }
    }

    protected void adjustWrapperIndices(List<Object> objects, int from, int increment) {
        ListIterator<Object> i = objects.listIterator(from);
        while (i.hasNext()) {
            this.adjustWrapperIndex(i.next(), increment);
        }
    }

    protected void adjustWrapperIndices(List<Object> objects, int from, int to, int increment) {
        ListIterator<Object> i = objects.listIterator(from);
        while (from < to && i.hasNext()) {
            this.adjustWrapperIndex(i.next(), increment);
            ++from;
        }
    }

    protected void updateChildren(Notification notification) {
        EStructuralFeature feature;
        EList<Object> children;
        EObject object = (EObject)notification.getNotifier();
        ChildrenStore childrenStore = this.getChildrenStore(object);
        if (childrenStore != null && (children = childrenStore.getList(feature = (EStructuralFeature)notification.getFeature())) != null) {
            int index = notification.getPosition();
            switch (notification.getEventType()) {
                case 2: {
                    if (feature.isMany()) break;
                }
                case 1: {
                    Object oldChild = childrenStore.get(feature, index);
                    Object newValue = notification.getNewValue();
                    if (this.unwrap(oldChild) == newValue) break;
                    if (feature.isMany() && index == -1) {
                        this.disposeWrappers((List)oldChild);
                    } else {
                        this.disposeWrapper(oldChild);
                    }
                    Object newChild = newValue == null && index == -1 ? null : this.wrap(object, feature, newValue, index);
                    childrenStore.set(feature, index, newChild);
                    break;
                }
                case 3: {
                    EList values = (EList)object.eGet(feature);
                    if (children.size() == values.size()) break;
                    Object newValue = notification.getNewValue();
                    this.adjustWrapperIndices(children, index, 1);
                    children.add(index, this.wrap(object, feature, newValue, index));
                    break;
                }
                case 4: {
                    EList values = (EList)object.eGet(feature);
                    if (children.size() == values.size()) break;
                    this.disposeWrapper(children.remove(index));
                    this.adjustWrapperIndices(children, index, -1);
                    break;
                }
                case 5: {
                    EList values = (EList)object.eGet(feature);
                    if (children.size() == values.size()) break;
                    if (notification.getOldValue() != null) {
                        throw new IllegalArgumentException("No old value expected");
                    }
                    List newValues = (List)notification.getNewValue();
                    ArrayList<Object> newChildren = new ArrayList<Object>(newValues.size());
                    int offset = 0;
                    for (Object newValue : newValues) {
                        newChildren.add(this.wrap(object, feature, newValue, index + offset++));
                    }
                    this.adjustWrapperIndices(children, index, offset);
                    children.addAll(index, newChildren);
                    break;
                }
                case 6: {
                    if (index == -1) {
                        index = 0;
                    }
                    EList values = (EList)object.eGet(feature);
                    if (children.size() == values.size()) break;
                    if (notification.getNewValue() instanceof int[]) {
                        int[] indices = (int[])notification.getNewValue();
                        for (int i = indices.length - 1; i >= 0; --i) {
                            this.disposeWrapper(children.remove(indices[i]));
                            this.adjustWrapperIndices(children, indices[i], -1);
                        }
                        break;
                    }
                    int len = ((List)notification.getOldValue()).size();
                    List sl = children.subList(index, index + len);
                    this.disposeWrappers(sl);
                    sl.clear();
                    this.adjustWrapperIndices(children, index, -len);
                    break;
                }
                case 7: {
                    int oldIndex = (Integer)notification.getOldValue();
                    EList values = (EList)object.eGet(feature);
                    boolean didMove = true;
                    int end = Math.max(oldIndex, index);
                    for (int i = Math.min(oldIndex, index); didMove && i <= end; ++i) {
                        didMove = this.unwrap(children.get(i)) == values.get(i);
                    }
                    if (didMove) break;
                    int delta = index - oldIndex;
                    if (delta < 0) {
                        this.adjustWrapperIndices(children, index, oldIndex, 1);
                    }
                    children.move(index, oldIndex);
                    this.adjustWrapperIndex(children.get(index), delta);
                    if (delta <= 0) break;
                    this.adjustWrapperIndices(children, oldIndex, index, -1);
                    break;
                }
            }
        }
    }

    protected CommandParameter unwrapCommandValues(CommandParameter commandParameter, Class<? extends Command> commandClass) {
        ArrayList newCollection = null;
        Collection<?> oldCollection = commandParameter.getCollection();
        if (oldCollection != null) {
            for (Object oldValue : oldCollection) {
                Object newValue = this.unwrap(oldValue);
                if (newValue != oldValue && newCollection == null) {
                    newCollection = new ArrayList(oldCollection.size());
                    for (Object o : oldCollection) {
                        if (o == oldValue) break;
                        newCollection.add(o);
                    }
                }
                if (newCollection == null) continue;
                newCollection.add(newValue);
            }
        }
        Object oldValue = commandParameter.getValue();
        Object newValue = this.unwrap(oldValue);
        if (newCollection != null || newValue != oldValue) {
            commandParameter = new CommandParameter(commandParameter.owner, commandParameter.feature, newValue, newCollection, commandParameter.index);
        }
        return commandParameter;
    }

    protected Command wrapCommand(Command command, Object object, Class<? extends Command> commandClass, CommandParameter commandParameter, CommandParameter oldCommandParameter) {
        return command;
    }

    protected Collection<? extends IWrapperItemProvider> getWrappedValues(CommandParameter commandParameter) {
        Collection<?> collection = commandParameter.getCollection();
        Object value = commandParameter.getValue();
        if (collection != null) {
            ArrayList<IWrapperItemProvider> result = new ArrayList<IWrapperItemProvider>(collection.size() + 1);
            for (Object o : collection) {
                if (!(o instanceof IWrapperItemProvider)) continue;
                result.add((IWrapperItemProvider)o);
            }
            if (value instanceof IWrapperItemProvider) {
                result.add((IWrapperItemProvider)value);
            }
            return result;
        }
        if (value instanceof IWrapperItemProvider) {
            return Collections.singletonList((IWrapperItemProvider)value);
        }
        return Collections.emptyList();
    }

    protected ItemPropertyDescriptor createItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        return this.createItemPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, feature, isSettable, false, false, category, filterFlags);
    }

    protected ItemPropertyDescriptor createItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, String category, String[] filterFlags) {
        return new ItemPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, category, filterFlags);
    }

    protected static class ChildrenStore {
        protected Entry[] entries;

        public ChildrenStore(Collection<? extends EStructuralFeature> features) {
            this.entries = new Entry[features.size()];
            int i = 0;
            for (EStructuralFeature eStructuralFeature : features) {
                this.entries[i++] = new Entry(eStructuralFeature);
            }
        }

        protected Entry getEntry(EStructuralFeature feature) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].feature != feature) continue;
                return this.entries[i];
            }
            return null;
        }

        protected EList<Object> createList(EStructuralFeature feature) {
            return feature.isMany() ? new BasicEList() : new ModifiableSingletonEList();
        }

        public boolean contains(EStructuralFeature feature) {
            return this.getEntry(feature) != null;
        }

        public EList<Object> getList(EStructuralFeature feature) {
            Entry entry = this.getEntry(feature);
            if (entry == null) {
                return null;
            }
            if (entry.list == null) {
                entry.list = this.createList(feature);
            }
            return entry.list;
        }

        public Object getValue(EStructuralFeature feature) {
            Entry entry = this.getEntry(feature);
            if (entry == null) {
                return null;
            }
            EList<Object> result = null;
            if (feature.isMany()) {
                if (entry.list == null) {
                    entry.list = this.createList(feature);
                }
                result = entry.list;
            } else if (entry.list != null) {
                result = entry.list.get(0);
            }
            return result;
        }

        public boolean setValue(EStructuralFeature feature, Object value) {
            Entry entry = this.getEntry(feature);
            if (entry == null) {
                return false;
            }
            if (entry.list == null && value != null) {
                entry.list = this.createList(feature);
            }
            if (entry.list != null) {
                if (feature.isMany()) {
                    entry.list.clear();
                    if (value != null) {
                        entry.list.addAll((Collection)value);
                    }
                } else {
                    entry.list.set(0, value);
                }
            }
            return true;
        }

        public Object get(EStructuralFeature feature, int index) {
            if (index == -1) {
                return this.getValue(feature);
            }
            EList<Object> list = this.getList(feature);
            return list != null ? list.get(index) : null;
        }

        public boolean set(EStructuralFeature feature, int index, Object object) {
            if (index == -1) {
                return this.setValue(feature, object);
            }
            EList<Object> list = this.getList(feature);
            if (list != null) {
                list.set(index, object);
                return true;
            }
            return false;
        }

        public List<Object> getChildren() {
            int size = 0;
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].list == null) continue;
                size += this.entries[i].feature.isMany() ? this.entries[i].list.size() : (this.entries[i].list.get(0) != null ? 1 : 0);
            }
            ArrayList<Object> result = new ArrayList<Object>(size);
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].list == null) continue;
                if (this.entries[i].feature.isMany()) {
                    result.addAll(this.entries[i].list);
                    continue;
                }
                if (this.entries[i].list.get(0) == null) continue;
                result.add(this.entries[i].list.get(0));
            }
            return result;
        }

        public int getOffset(EStructuralFeature feature) {
            int offset = 0;
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].feature == feature) {
                    return offset;
                }
                if (this.entries[i].list == null) continue;
                offset += this.entries[i].feature.isMany() ? this.entries[i].list.size() : (this.entries[i].list.get(0) != null ? 1 : 0);
            }
            return -1;
        }

        public void clear() {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].list == null) continue;
                if (this.entries[i].feature.isMany()) {
                    this.entries[i].list.clear();
                    continue;
                }
                this.entries[i].list.set(0, null);
            }
        }

        protected static class Entry {
            public EStructuralFeature feature;
            public EList<Object> list;

            public Entry(EStructuralFeature feature) {
                this.feature = feature;
            }
        }
    }

    public class ResultAndAffectedObjectsWrappingCommandActionDelegate
    extends ResultAndAffectedObjectsWrappingCommand
    implements CommandActionDelegate {
        CommandActionDelegate commandActionDelegate;

        public ResultAndAffectedObjectsWrappingCommandActionDelegate(CommandActionDelegate command) {
            super((Command)((Object)command));
            this.commandActionDelegate = command;
        }

        public ResultAndAffectedObjectsWrappingCommandActionDelegate(CommandActionDelegate command, Collection<? extends IWrapperItemProvider> additionalWrappers) {
            super((Command)((Object)command), additionalWrappers);
            this.commandActionDelegate = command;
        }

        @Override
        public Object getImage() {
            return this.commandActionDelegate.getImage();
        }

        @Override
        public String getText() {
            return this.commandActionDelegate.getText();
        }

        @Override
        public String getDescription() {
            return this.commandActionDelegate.getDescription();
        }

        @Override
        public String getToolTipText() {
            return this.commandActionDelegate.getToolTipText();
        }
    }

    public class ResultAndAffectedObjectsWrappingCommand
    extends CommandWrapper {
        protected List<Object> owners;
        protected Collection<? extends IWrapperItemProvider> additionalWrappers;

        public ResultAndAffectedObjectsWrappingCommand(Command command) {
            super(command);
        }

        public ResultAndAffectedObjectsWrappingCommand(Command command, Collection<? extends IWrapperItemProvider> additionalResultWrappers) {
            super(command);
            this.additionalWrappers = additionalResultWrappers;
        }

        @Override
        public Collection<?> getResult() {
            return this.wrapValues(super.getResult(), true);
        }

        @Override
        public Collection<?> getAffectedObjects() {
            return this.wrapValues(super.getAffectedObjects(), false);
        }

        protected Collection<? extends IWrapperItemProvider> wrapValues(Collection<?> unwrappedValues, boolean useAdditionalWrappers) {
            ArrayList result = new ArrayList(unwrappedValues);
            ArrayList<? extends IWrapperItemProvider> wrappers = new ArrayList<IWrapperItemProvider>();
            AdapterFactory af = ItemProviderAdapter.this.adapterFactory instanceof ComposeableAdapterFactory ? ((ComposeableAdapterFactory)ItemProviderAdapter.this.adapterFactory).getRootAdapterFactory() : ItemProviderAdapter.this.adapterFactory;
            for (Object owner : this.getOwners()) {
                Collection<Object> children = Collections.EMPTY_LIST;
                Object object = af.adapt(owner, IEditingDomainItemProvider.class);
                if (object instanceof IEditingDomainItemProvider) {
                    children = ((IEditingDomainItemProvider)object).getChildren(owner);
                } else {
                    Object object2 = af.adapt(owner, ITreeItemContentProvider.class);
                    if (object2 instanceof ITreeItemContentProvider) {
                        children = ((ITreeItemContentProvider)object2).getChildren(owner);
                    }
                }
                for (Object child : children) {
                    if (!(child instanceof IWrapperItemProvider)) continue;
                    wrappers.add((IWrapperItemProvider)child);
                }
            }
            if (useAdditionalWrappers && this.additionalWrappers != null) {
                wrappers.addAll(this.additionalWrappers);
            }
            ListIterator<IWrapperItemProvider> i = result.listIterator();
            block2: while (i.hasNext()) {
                Object resultObject = i.next();
                for (IWrapperItemProvider iWrapperItemProvider : wrappers) {
                    if (!ItemProviderAdapter.this.isEquivalentValue(ItemProviderAdapter.this.unwrap(iWrapperItemProvider), resultObject)) continue;
                    i.set(iWrapperItemProvider);
                    continue block2;
                }
            }
            ArrayList collection = result;
            return collection;
        }

        public List<Object> getOwners() {
            if (this.owners == null) {
                this.owners = new UniqueEList<Object>();
                this.addOwners(this.getCommand());
            }
            return this.owners;
        }

        protected void addOwners(Command command) {
            if (command instanceof CommandWrapper) {
                this.addOwners(((CommandWrapper)command).getCommand());
            } else if (command instanceof CompoundCommand) {
                CompoundCommand compoundCommand = (CompoundCommand)command;
                List<Command> commandList = compoundCommand.getCommandList();
                int resultIndex = compoundCommand.getResultIndex();
                if (resultIndex == Integer.MAX_VALUE) {
                    for (Command childCommand : commandList) {
                        this.addOwners(childCommand);
                    }
                } else {
                    if (resultIndex == Integer.MIN_VALUE) {
                        resultIndex = commandList.size() - 1;
                    }
                    if (resultIndex >= 0) {
                        this.addOwners(commandList.get(resultIndex));
                    }
                }
            } else if (command instanceof AddCommand) {
                this.owners.add(((AddCommand)command).getOwner());
            } else if (command instanceof RemoveCommand) {
                this.owners.add(((RemoveCommand)command).getOwner());
            } else if (command instanceof SetCommand) {
                this.owners.add(((SetCommand)command).getOwner());
            }
        }
    }

    protected static class ModifiableSingletonEList<E>
    extends AbstractList<E>
    implements EList<E> {
        private E singleElement;

        ModifiableSingletonEList() {
            this.singleElement = null;
        }

        ModifiableSingletonEList(E element) {
            this.singleElement = element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=1");
            }
            return this.singleElement;
        }

        @Override
        public E set(int index, E element) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=1");
            }
            E oldElement = this.singleElement;
            this.singleElement = element;
            return oldElement;
        }

        @Override
        public boolean contains(Object o) {
            return o == null ? this.singleElement == null : o.equals(this.singleElement);
        }

        @Override
        public void move(int index, E o) {
            if (index != 0 || !this.contains(o)) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=1");
            }
        }

        @Override
        public E move(int targetIndex, int sourceIndex) {
            if (targetIndex != 0) {
                throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=1");
            }
            if (sourceIndex != 0) {
                throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=1");
            }
            return this.singleElement;
        }
    }
}

