/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.edit.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import ro.sync.emf.common.command.Command;
import ro.sync.emf.common.util.EList;
import ro.sync.emf.ecore.EObject;
import ro.sync.emf.ecore.EStructuralFeature;
import ro.sync.emf.edit.command.AbstractOverrideableCommand;
import ro.sync.emf.edit.command.CommandParameter;
import ro.sync.emf.edit.domain.EditingDomain;

public class RemoveCommand
extends AbstractOverrideableCommand {
    protected EObject owner;
    protected EStructuralFeature feature;
    protected EList<Object> ownerList;
    protected Collection<Object> collection;
    protected int[] indices;
    protected Collection<?> affectedObjects;

    public static Command create(EditingDomain domain, Object value) {
        return RemoveCommand.create(domain, Collections.singleton(value));
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Object value) {
        return RemoveCommand.create(domain, owner, feature, Collections.singleton(value));
    }

    public static Command create(EditingDomain domain, Collection<?> collection) {
        return RemoveCommand.create(domain, null, null, collection);
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Collection<?> collection) {
        return domain.createCommand(RemoveCommand.class, new CommandParameter(owner, feature, collection));
    }

    public RemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        this(domain, owner, feature, Collections.singleton(value));
    }

    public RemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, "", "");
        this.owner = owner;
        this.feature = feature;
        this.collection = collection == null ? null : new ArrayList(collection);
        this.ownerList = RemoveCommand.getOwnerList(this.owner, feature);
    }

    public RemoveCommand(EditingDomain domain, EList<?> list, Object value) {
        this(domain, list, Collections.singleton(value));
    }

    public RemoveCommand(EditingDomain domain, EList<?> list, Collection<?> collection) {
        super(domain, "", "");
        this.collection = collection == null ? null : new ArrayList(collection);
        EList<?> untypedList = list;
        this.ownerList = untypedList;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EList<Object> getOwnerList() {
        return this.ownerList;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public int[] getIndices() {
        return this.indices;
    }

    @Override
    protected boolean prepare() {
        boolean result = this.ownerList != null && this.collection != null && this.ownerList.containsAll(this.collection) && (this.owner == null || !this.domain.isReadOnly(this.owner.eResource()));
        return result;
    }

    @Override
    public void doExecute() {
        ArrayList<Object> identity = new ArrayList<Object>(this.collection.size());
        int[] identityIndices = new int[this.collection.size()];
        int i = 0;
        ListIterator ownedObjects = this.ownerList.listIterator();
        while (ownedObjects.hasNext()) {
            Object ownedObject = ownedObjects.next();
            if (!this.containsExact(this.collection, ownedObject)) continue;
            this.removeExact(this.collection, ownedObject);
            identity.add(ownedObject);
            identityIndices[i++] = ownedObjects.previousIndex();
        }
        while (i < identityIndices.length) {
            identityIndices[i++] = -1;
        }
        ArrayList<Object> equality = new ArrayList<Object>(this.collection.size());
        int[] equalityIndices = new int[this.collection.size()];
        i = 0;
        ListIterator ownedObjects2 = this.ownerList.listIterator();
        while (ownedObjects2.hasNext()) {
            Object ownedObject = ownedObjects2.next();
            int index = ownedObjects2.previousIndex();
            if (!this.collection.contains(ownedObject) || this.contains(identityIndices, index)) continue;
            this.collection.remove(ownedObject);
            equality.add(ownedObject);
            equalityIndices[i++] = index;
        }
        this.merge(identity, identityIndices, equality, equalityIndices);
        for (i = this.indices.length - 1; i >= 0; --i) {
            this.ownerList.remove(this.indices[i]);
        }
        this.updateEMap(this.owner, this.feature);
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
    }

    protected boolean containsExact(Collection<?> collection, Object target) {
        for (Object object : collection) {
            if (object != target) continue;
            return true;
        }
        return false;
    }

    protected boolean contains(int[] values, int target) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (values[i] != target) continue;
            return true;
        }
        return false;
    }

    protected boolean removeExact(Collection<?> collection, Object target) {
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            if (i.next() != target) continue;
            i.remove();
            return true;
        }
        return false;
    }

    protected void merge(List<Object> objects1, int[] indices1, List<Object> objects2, int[] indices2) {
        Object o2;
        if (objects2.isEmpty()) {
            this.collection = objects1;
            this.indices = indices1;
            return;
        }
        if (objects1.isEmpty()) {
            this.collection = objects2;
            this.indices = indices2;
            return;
        }
        int size = objects1.size() + objects2.size();
        this.collection = new ArrayList<Object>(size);
        this.indices = new int[size];
        int i1 = 0;
        int i2 = 0;
        int i = 0;
        Iterator<Object> iter1 = objects1.iterator();
        Iterator<Object> iter2 = objects2.iterator();
        Object o1 = iter1.hasNext() ? iter1.next() : null;
        Object object = o2 = iter2.hasNext() ? iter2.next() : null;
        while (o1 != null && o2 != null) {
            if (indices1[i1] < indices2[i2]) {
                this.indices[i++] = indices1[i1++];
                this.collection.add(o1);
                o1 = iter1.hasNext() ? iter1.next() : null;
                continue;
            }
            this.indices[i++] = indices2[i2++];
            this.collection.add(o2);
            o2 = iter2.hasNext() ? iter2.next() : null;
        }
        while (o1 != null) {
            this.indices[i++] = indices1[i1++];
            this.collection.add(o1);
            o1 = iter1.hasNext() ? iter1.next() : null;
        }
        while (o2 != null) {
            this.indices[i++] = indices2[i2++];
            this.collection.add(o2);
            o2 = iter2.hasNext() ? iter2.next() : null;
        }
    }

    @Override
    public void doUndo() {
        int i = 0;
        for (Object object : this.collection) {
            this.ownerList.add(this.indices[i++], object);
        }
        this.updateEMap(this.owner, this.feature);
        this.affectedObjects = this.collection;
    }

    @Override
    public void doRedo() {
        for (int i = this.indices.length - 1; i >= 0; --i) {
            this.ownerList.remove(this.indices[i]);
        }
        this.updateEMap(this.owner, this.feature);
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
    }

    @Override
    public Collection<?> doGetResult() {
        return this.collection;
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return this.affectedObjects;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.feature + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (indices: " + Arrays.toString(this.indices) + ")");
        result.append(" (affectedObjects: " + this.affectedObjects + ")");
        return result.toString();
    }
}

